/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.tdpaas.beans.mq.listener;

import com.irdstudio.tdpaas.beans.mq.handle.MQMessageProcessor;
import java.util.List;
import java.util.Map;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageListenerForConcurrently
implements MessageListenerConcurrently {
    private static Logger logger = LoggerFactory.getLogger(MessageListenerForConcurrently.class);
    private Map<String, MQMessageProcessor> handlermap;

    public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
        try {
            for (MessageExt msg : msgs) {
                logger.debug(String.format("start consume message: message:id%s topic:%s tags:%s keys:%s message:%s", msg.getMsgId(), msg.getTopic(), msg.getTags(), msg.getKeys(), new String(msg.getBody(), "utf-8")));
                MQMessageProcessor handler = this.handlermap.get(msg.getTopic());
                handler.handleMessage(msg);
                logger.debug(String.format("consume message success: message:id%s topic:%s tags:%s keys:%s message:%s", msg.getMsgId(), msg.getTopic(), msg.getTags(), msg.getKeys(), new String(msg.getBody(), "utf-8")));
            }
            return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ConsumeConcurrentlyStatus.RECONSUME_LATER;
        }
    }

    public void setHandlermap(Map<String, MQMessageProcessor> handlermap) {
        this.handlermap = handlermap;
    }
}

