/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.parser.impl;

import com.alibaba.citrus.service.requestcontext.parser.AbstractValueParser;
import com.alibaba.citrus.service.requestcontext.parser.ParameterParser;
import com.alibaba.citrus.service.requestcontext.parser.ParameterParserFilter;
import com.alibaba.citrus.service.requestcontext.parser.ParameterValueFilter;
import com.alibaba.citrus.service.requestcontext.parser.ParserRequestContext;
import com.alibaba.citrus.service.requestcontext.parser.UploadedFileFilter;
import com.alibaba.citrus.service.requestcontext.util.QueryStringParser;
import com.alibaba.citrus.service.requestcontext.util.ValueList;
import com.alibaba.citrus.service.upload.UploadException;
import com.alibaba.citrus.service.upload.UploadParameters;
import com.alibaba.citrus.service.upload.UploadService;
import com.alibaba.citrus.service.upload.UploadSizeLimitExceededException;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringEscapeUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterParserImpl
extends AbstractValueParser
implements ParameterParser {
    private static final Logger log = LoggerFactory.getLogger(ParameterParser.class);
    private final UploadService upload;
    private final boolean trimming;
    private boolean uploadProcessed;
    private final ParameterParserFilter[] filters;
    private final String htmlFieldSuffix;

    public ParameterParserImpl(ParserRequestContext requestContext, UploadService upload, boolean trimming, ParameterParserFilter[] filters, String htmlFieldSuffix) {
        super(requestContext);
        this.upload = upload;
        this.trimming = trimming;
        this.filters = filters;
        this.htmlFieldSuffix = htmlFieldSuffix;
        HttpServletRequestWrapper wrapper = (HttpServletRequestWrapper)requestContext.getRequest();
        HttpServletRequest wrappedRequest = (HttpServletRequest)wrapper.getRequest();
        boolean isMultipart = false;
        if (requestContext.isAutoUpload() && upload != null && (isMultipart = upload.isMultipartContent(wrappedRequest))) {
            try {
                this.parseUpload();
            }
            catch (UploadSizeLimitExceededException e) {
                this.add("upload_failed", Boolean.TRUE);
                this.add("upload_size_limit_exceeded", Boolean.TRUE);
                log.warn("File upload exceeds the size limit", (Throwable)e);
            }
            catch (UploadException e) {
                this.add("upload_failed", Boolean.TRUE);
                log.warn("Upload failed", (Throwable)e);
            }
        }
        if (!isMultipart) {
            String method = wrappedRequest.getMethod();
            if (requestContext.isUseServletEngineParser() || "post".equalsIgnoreCase(method) || "put".equalsIgnoreCase(method)) {
                this.parseByServletEngine(wrappedRequest);
            } else {
                this.parseQueryString(requestContext, wrappedRequest);
            }
            this.postProcessParams();
        }
    }

    protected Logger getLogger() {
        return log;
    }

    private void parseByServletEngine(HttpServletRequest wrappedRequest) {
        Map parameters = wrappedRequest.getParameterMap();
        if (parameters != null && parameters.size() > 0) {
            for (Map.Entry entry : parameters.entrySet()) {
                String[] values;
                String key = (String)entry.getKey();
                for (String value : values = (String[])entry.getValue()) {
                    this.add(key, value);
                }
            }
        }
    }

    private void parseQueryString(ParserRequestContext requestContext, HttpServletRequest wrappedRequest) {
        String charset = requestContext.isUseBodyEncodingForURI() ? wrappedRequest.getCharacterEncoding() : requestContext.getURIEncoding();
        QueryStringParser parser = new QueryStringParser(charset, "ISO-8859-1"){

            protected void add(String key, String value) {
                ParameterParserImpl.this.add(key, value);
            }
        };
        parser.parse(wrappedRequest.getQueryString());
    }

    private void postProcessParams() {
        HttpServletRequestWrapper wrapper = (HttpServletRequestWrapper)this.requestContext.getRequest();
        HttpServletRequest wrappedRequest = (HttpServletRequest)wrapper.getRequest();
        boolean[] filtering = null;
        if (!ArrayUtil.isEmptyArray(this.filters)) {
            filtering = new boolean[this.filters.length];
            for (int i = 0; i < this.filters.length; ++i) {
                filtering[i] = this.filters[i].isFiltering(wrappedRequest);
            }
        }
        String[] keys = this.getKeys();
        LinkedList<String> keysToRemove = CollectionUtil.createLinkedList();
        for (String key : keys) {
            if (key.endsWith(this.htmlFieldSuffix)) {
                keysToRemove.add(key);
                key = key.substring(0, key.length() - this.htmlFieldSuffix.length());
                if (this.containsKey(key)) continue;
                this.setObjects(key, this.processValues(key, true, filtering));
                continue;
            }
            boolean isHtml = !StringUtil.isBlank(this.getString(key + this.htmlFieldSuffix));
            this.setObjects(key, this.processValues(key, isHtml, filtering));
        }
        for (String key : keysToRemove) {
            this.remove(key);
        }
    }

    private Object[] processValues(String key, boolean isHtmlField, boolean[] filtering) {
        Object[] values = this.getObjects(key);
        for (int i = 0; i < values.length; ++i) {
            ParameterParserFilter filter;
            int j;
            Object value = values[i];
            if (value instanceof String) {
                if (!isHtmlField && this.requestContext.isUnescapeParameters()) {
                    value = StringEscapeUtil.unescapeEntities(null, (String)value);
                }
                if (filtering != null) {
                    for (j = 0; j < this.filters.length; ++j) {
                        filter = this.filters[j];
                        if (!(filter instanceof ParameterValueFilter) || !filtering[j]) continue;
                        value = ((ParameterValueFilter)filter).filter(key, (String)value, isHtmlField);
                    }
                }
            } else if (value instanceof FileItem && filtering != null) {
                for (j = 0; j < this.filters.length; ++j) {
                    filter = this.filters[j];
                    if (!(filter instanceof UploadedFileFilter) || !filtering[j]) continue;
                    value = ((UploadedFileFilter)filter).filter(key, (FileItem)value);
                }
            }
            values[i] = value;
        }
        return values;
    }

    public FileItem getFileItem(String key) {
        ValueList container = this.getValueList(key, false);
        return container == null ? null : container.getFileItem();
    }

    public FileItem[] getFileItems(String key) {
        ValueList container = this.getValueList(key, false);
        return container == null ? new FileItem[]{} : container.getFileItems();
    }

    public void add(String key, FileItem value) {
        if (value.isFormField()) {
            this.add(key, value.getString());
        } else if (!StringUtil.isEmpty(value.getName()) || value.getSize() > 0L) {
            this.add(key, (Object)value);
        }
    }

    public void add(String key, Object value) {
        if (value == null) {
            value = "";
        }
        if (this.trimming && value instanceof String) {
            value = StringUtil.trimToEmpty((String)value);
        }
        this.getValueList(key, true).addValue(value);
    }

    public void parseUpload() throws UploadException {
        this.parseUpload(null);
    }

    public void parseUpload(UploadParameters params) throws UploadException {
        FileItem[] items;
        if (this.uploadProcessed || this.upload == null) {
            return;
        }
        for (FileItem item : items = this.upload.parseRequest(this.requestContext.getRequest(), params)) {
            this.add(item.getFieldName(), item);
        }
        this.uploadProcessed = true;
        this.postProcessParams();
    }

    protected String getCharacterEncoding() {
        String charset = this.requestContext.getRequest().getCharacterEncoding();
        return charset == null ? "ISO-8859-1" : charset;
    }

    public String toQueryString() {
        QueryStringParser parser = new QueryStringParser();
        for (String element : this.keySet()) {
            String key = element;
            Object[] values = this.getObjects(key);
            if (ArrayUtil.isEmptyArray(values)) continue;
            for (Object valueObject : values) {
                if (valueObject != null && !(valueObject instanceof String)) continue;
                parser.append(key, (String)valueObject);
            }
        }
        return parser.toQueryString();
    }
}

