/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.pipeline.valve;

import com.alibaba.citrus.service.pipeline.PipelineContext;
import com.alibaba.citrus.service.pipeline.support.AbstractValve;
import com.alibaba.citrus.util.StringUtil;

public abstract class AbstractInputOutputValve
extends AbstractValve {
    private static final String DEFAULT_INPUT_OUTPUT_KEY = "result";
    private String inputKey;
    private String outputKey;

    public final void setInput(String inputKey) {
        this.inputKey = StringUtil.trimToNull(inputKey);
    }

    public final void setOutput(String outputKey) {
        this.outputKey = StringUtil.trimToNull(outputKey);
    }

    public final String getInputKey() {
        String key = this.inputKey;
        if (key == null) {
            key = this.getDefaultInputKey();
        }
        if (key == null) {
            key = DEFAULT_INPUT_OUTPUT_KEY;
        }
        return key;
    }

    public final String getOutputKey() {
        String key = this.outputKey;
        if (key == null) {
            key = this.getDefaultOutputKey();
        }
        if (key == null) {
            key = DEFAULT_INPUT_OUTPUT_KEY;
        }
        return key;
    }

    protected String getDefaultInputKey() {
        return null;
    }

    protected String getDefaultOutputKey() {
        return null;
    }

    protected boolean filterInputValue(Object inputValue) {
        return true;
    }

    protected final Object getInputValue(PipelineContext pipelineContext) {
        return pipelineContext.getAttribute(this.getInputKey());
    }

    protected final Object consumeInputValue(PipelineContext pipelineContext) {
        Object value = pipelineContext.getAttribute(this.getInputKey());
        if (this.filterInputValue(value)) {
            pipelineContext.setAttribute(this.getInputKey(), null);
        } else {
            value = null;
        }
        return value;
    }

    protected final void setOutputValue(PipelineContext pipelineContext, Object outputValue) {
        pipelineContext.setAttribute(this.getOutputKey(), outputValue);
    }
}

