/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.config.spring.context.annotation;

import com.alibaba.dubbo.config.annotation.Service;
import com.alibaba.dubbo.config.spring.ServiceBean;
import com.alibaba.dubbo.config.spring.beans.factory.annotation.ReferenceAnnotationBeanPostProcessor;
import com.alibaba.dubbo.config.spring.context.annotation.DubboClassPathBeanDefinitionScanner;
import com.alibaba.dubbo.config.spring.context.annotation.DubboComponentScan;
import com.alibaba.dubbo.config.spring.util.BeanRegistrar;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DubboComponentScanRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware,
BeanClassLoaderAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    private ResourceLoader resourceLoader;
    private Environment environment;
    private ClassLoader classLoader;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Set<String> packagesToScan = this.getPackagesToScan(importingClassMetadata);
        this.registerServiceBeans(packagesToScan, registry);
        this.registerReferenceAnnotationBeanPostProcessor(registry);
    }

    private void registerServiceBeans(Set<String> packagesToScan, BeanDefinitionRegistry registry) {
        DubboClassPathBeanDefinitionScanner dubboClassPathBeanDefinitionScanner = new DubboClassPathBeanDefinitionScanner(registry, this.environment, this.resourceLoader);
        dubboClassPathBeanDefinitionScanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Service.class));
        for (String packageToScan : packagesToScan) {
            Set<BeanDefinitionHolder> beanDefinitionHolders = dubboClassPathBeanDefinitionScanner.doScan(packageToScan);
            for (BeanDefinitionHolder beanDefinitionHolder : beanDefinitionHolders) {
                this.registerServiceBean(beanDefinitionHolder, registry);
            }
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info((Object)(beanDefinitionHolders.size() + " annotated @Service Components { " + beanDefinitionHolders + " } were scanned under package[" + packageToScan + "]"));
        }
    }

    private Class<?> resolveClass(BeanDefinitionHolder beanDefinitionHolder) {
        BeanDefinition beanDefinition = beanDefinitionHolder.getBeanDefinition();
        return this.resolveClass(beanDefinition);
    }

    private Class<?> resolveClass(BeanDefinition beanDefinition) {
        String beanClassName = beanDefinition.getBeanClassName();
        return ClassUtils.resolveClassName((String)beanClassName, (ClassLoader)this.classLoader);
    }

    private void registerServiceBean(BeanDefinitionHolder beanDefinitionHolder, BeanDefinitionRegistry registry) {
        Class<?> beanClass = this.resolveClass(beanDefinitionHolder);
        Service service = (Service)AnnotationUtils.findAnnotation(beanClass, Service.class);
        Class<?> interfaceClass = this.resolveServiceInterfaceClass(beanClass, service);
        String beanName = beanDefinitionHolder.getBeanName();
        AbstractBeanDefinition serviceBeanDefinition = this.buildServiceBeanDefinition(service, interfaceClass, beanName);
        BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)serviceBeanDefinition, (BeanDefinitionRegistry)registry);
    }

    private ManagedList<RuntimeBeanReference> toRuntimeBeanReferences(String ... beanNames) {
        ManagedList runtimeBeanReferences = new ManagedList();
        if (!ObjectUtils.isEmpty((Object[])beanNames)) {
            for (String beanName : beanNames) {
                runtimeBeanReferences.add((Object)new RuntimeBeanReference(beanName));
            }
        }
        return runtimeBeanReferences;
    }

    private AbstractBeanDefinition buildServiceBeanDefinition(Service service, Class<?> interfaceClass, String annotatedServiceBeanName) {
        String[] registryConfigBeanNames;
        ManagedList<RuntimeBeanReference> registryRuntimeBeanReferences;
        String moduleConfigBeanName;
        String applicationConfigBeanName;
        String monitorConfigBeanName;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ServiceBean.class).addConstructorArgValue((Object)service).addPropertyReference("ref", annotatedServiceBeanName).addPropertyValue("interfaceClass", interfaceClass);
        String providerConfigBeanName = service.provider();
        if (StringUtils.hasText((String)providerConfigBeanName)) {
            builder.addPropertyReference("provider", providerConfigBeanName);
        }
        if (StringUtils.hasText((String)(monitorConfigBeanName = service.monitor()))) {
            builder.addPropertyReference("monitor", monitorConfigBeanName);
        }
        if (StringUtils.hasText((String)(applicationConfigBeanName = service.application()))) {
            builder.addPropertyReference("application", applicationConfigBeanName);
        }
        if (StringUtils.hasText((String)(moduleConfigBeanName = service.module()))) {
            builder.addPropertyReference("application", moduleConfigBeanName);
        }
        if (!(registryRuntimeBeanReferences = this.toRuntimeBeanReferences(registryConfigBeanNames = service.registry())).isEmpty()) {
            builder.addPropertyValue("registries", registryRuntimeBeanReferences);
        }
        String[] protocolConfigBeanNames = service.protocol();
        ManagedList<RuntimeBeanReference> protocolRuntimeBeanReferences = this.toRuntimeBeanReferences(protocolConfigBeanNames);
        if (!registryRuntimeBeanReferences.isEmpty()) {
            builder.addPropertyValue("protocols", protocolRuntimeBeanReferences);
        }
        return builder.getBeanDefinition();
    }

    private Class<?> resolveServiceInterfaceClass(Class<?> annotatedServiceBeanClass, Service service) {
        Class<?>[] allInterfaces;
        Class interfaceClass = service.interfaceClass();
        if (Void.TYPE.equals(interfaceClass)) {
            interfaceClass = null;
            String interfaceClassName = service.interfaceName();
            if (StringUtils.hasText((String)interfaceClassName) && ClassUtils.isPresent((String)interfaceClassName, (ClassLoader)this.classLoader)) {
                interfaceClass = ClassUtils.resolveClassName((String)interfaceClassName, (ClassLoader)this.classLoader);
            }
        }
        if (interfaceClass == null && (allInterfaces = annotatedServiceBeanClass.getInterfaces()).length > 0) {
            interfaceClass = allInterfaces[0];
        }
        Assert.notNull(interfaceClass, (String)"@Service interfaceClass() or interfaceName() or interface class must be present!");
        Assert.isTrue((boolean)interfaceClass.isInterface(), (String)"The type that was annotated @Service is not an interface!");
        return interfaceClass;
    }

    private void registerReferenceAnnotationBeanPostProcessor(BeanDefinitionRegistry registry) {
        BeanRegistrar.registerInfrastructureBean(registry, ReferenceAnnotationBeanPostProcessor.BEAN_NAME, ReferenceAnnotationBeanPostProcessor.class);
    }

    private Set<String> getPackagesToScan(AnnotationMetadata metadata) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(DubboComponentScan.class.getName()));
        String[] basePackages = attributes.getStringArray("basePackages");
        Class[] basePackageClasses = attributes.getClassArray("basePackageClasses");
        LinkedHashSet<String> packagesToScan = new LinkedHashSet<String>();
        packagesToScan.addAll(Arrays.asList(basePackages));
        for (Class basePackageClass : basePackageClasses) {
            packagesToScan.add(ClassUtils.getPackageName((Class)basePackageClass));
        }
        if (packagesToScan.isEmpty()) {
            return Collections.singleton(ClassUtils.getPackageName((String)metadata.getClassName()));
        }
        return packagesToScan;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

