/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.dev;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class XSSFDump {
    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            System.out.println("Dumping " + args[i]);
            ZipFile zip = new ZipFile(args[i]);
            XSSFDump.dump(zip);
        }
    }

    public static void dump(ZipFile zip) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        String zipname = zip.getName();
        int sep = zipname.lastIndexOf(46);
        File root = new File(zipname.substring(0, sep));
        root.mkdir();
        Enumeration<? extends ZipEntry> en = zip.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            String name = entry.getName();
            int idx = name.lastIndexOf(47);
            if (idx != -1) {
                File bs = new File(root, name.substring(0, idx));
                bs.mkdirs();
            }
            File f = new File(root, entry.getName());
            FileOutputStream out = new FileOutputStream(f);
            if (entry.getName().endsWith(".xml") || entry.getName().endsWith(".vml") || entry.getName().endsWith(".rels")) {
                try {
                    Document doc = builder.parse(zip.getInputStream(entry));
                    OutputFormat format = new OutputFormat(doc);
                    format.setIndenting(true);
                    XMLSerializer serial = new XMLSerializer(out, format);
                    serial.asDOMSerializer();
                    serial.serialize(doc.getDocumentElement());
                }
                catch (Exception e) {
                    System.err.println("Failed to parse " + entry.getName() + ", dumping raw content");
                    XSSFDump.dump(zip.getInputStream(entry), out);
                }
            } else {
                XSSFDump.dump(zip.getInputStream(entry), out);
            }
            out.close();
        }
    }

    protected static void dump(InputStream is, OutputStream out) throws IOException {
        int pos;
        byte[] chunk = new byte[2048];
        while ((pos = is.read(chunk)) > 0) {
            out.write(chunk, 0, pos);
        }
    }
}

