/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.anon;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.docx4j.docProps.coverPageProps.CoverPageProperties;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.parts.ActiveXControlXmlPart;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePropertiesPart;
import org.docx4j.openpackaging.parts.DefaultXmlPart;
import org.docx4j.openpackaging.parts.DocPropsCorePart;
import org.docx4j.openpackaging.parts.DocPropsCoverPagePart;
import org.docx4j.openpackaging.parts.DocPropsCustomPart;
import org.docx4j.openpackaging.parts.DocPropsExtendedPart;
import org.docx4j.openpackaging.parts.DrawingML.Chart;
import org.docx4j.openpackaging.parts.DrawingML.ChartShapePart;
import org.docx4j.openpackaging.parts.DrawingML.DiagramColorsPart;
import org.docx4j.openpackaging.parts.DrawingML.DiagramDataPart;
import org.docx4j.openpackaging.parts.DrawingML.DiagramDrawingPart;
import org.docx4j.openpackaging.parts.DrawingML.DiagramLayoutHeaderPart;
import org.docx4j.openpackaging.parts.DrawingML.DiagramLayoutPart;
import org.docx4j.openpackaging.parts.DrawingML.DiagramStylePart;
import org.docx4j.openpackaging.parts.DrawingML.Drawing;
import org.docx4j.openpackaging.parts.DrawingML.JaxbDmlPart;
import org.docx4j.openpackaging.parts.DrawingML.ThemeOverridePart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.PresentationML.CommentAuthorsPart;
import org.docx4j.openpackaging.parts.PresentationML.CommentsPart;
import org.docx4j.openpackaging.parts.PresentationML.FontDataPart;
import org.docx4j.openpackaging.parts.PresentationML.HandoutMasterPart;
import org.docx4j.openpackaging.parts.PresentationML.JaxbPmlPart;
import org.docx4j.openpackaging.parts.PresentationML.MainPresentationPart;
import org.docx4j.openpackaging.parts.PresentationML.NotesMasterPart;
import org.docx4j.openpackaging.parts.PresentationML.NotesSlidePart;
import org.docx4j.openpackaging.parts.PresentationML.PresentationPropertiesPart;
import org.docx4j.openpackaging.parts.PresentationML.SlideLayoutPart;
import org.docx4j.openpackaging.parts.PresentationML.SlideMasterPart;
import org.docx4j.openpackaging.parts.PresentationML.SlidePart;
import org.docx4j.openpackaging.parts.PresentationML.TableStylesPart;
import org.docx4j.openpackaging.parts.PresentationML.TagsPart;
import org.docx4j.openpackaging.parts.PresentationML.ViewPropertiesPart;
import org.docx4j.openpackaging.parts.SpreadsheetML.CalcChain;
import org.docx4j.openpackaging.parts.SpreadsheetML.ConnectionsPart;
import org.docx4j.openpackaging.parts.SpreadsheetML.ExternalLinkPart;
import org.docx4j.openpackaging.parts.SpreadsheetML.JaxbSmlPart;
import org.docx4j.openpackaging.parts.SpreadsheetML.PivotCacheDefinition;
import org.docx4j.openpackaging.parts.SpreadsheetML.PivotCacheRecords;
import org.docx4j.openpackaging.parts.SpreadsheetML.PivotTable;
import org.docx4j.openpackaging.parts.SpreadsheetML.PrinterSettings;
import org.docx4j.openpackaging.parts.SpreadsheetML.QueryTablePart;
import org.docx4j.openpackaging.parts.SpreadsheetML.SharedStrings;
import org.docx4j.openpackaging.parts.SpreadsheetML.Styles;
import org.docx4j.openpackaging.parts.SpreadsheetML.TablePart;
import org.docx4j.openpackaging.parts.SpreadsheetML.WorkbookPart;
import org.docx4j.openpackaging.parts.SpreadsheetML.WorksheetPart;
import org.docx4j.openpackaging.parts.ThemePart;
import org.docx4j.openpackaging.parts.VMLBinaryPart;
import org.docx4j.openpackaging.parts.VMLPart;
import org.docx4j.openpackaging.parts.WordprocessingML.AlternativeFormatInputPart;
import org.docx4j.openpackaging.parts.WordprocessingML.BibliographyPart;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;
import org.docx4j.openpackaging.parts.WordprocessingML.CommentsExtendedPart;
import org.docx4j.openpackaging.parts.WordprocessingML.DocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.DocumentSettingsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.EmbeddedPackagePart;
import org.docx4j.openpackaging.parts.WordprocessingML.EndnotesPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FontTablePart;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FootnotesPart;
import org.docx4j.openpackaging.parts.WordprocessingML.GlossaryDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ImageBmpPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ImageEpsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ImageGifPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ImageJpegPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ImagePngPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ImageTiffPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MetafileEmfPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MetafilePart;
import org.docx4j.openpackaging.parts.WordprocessingML.MetafileWmfPart;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ObfuscatedFontPart;
import org.docx4j.openpackaging.parts.WordprocessingML.OleObjectBinaryPart;
import org.docx4j.openpackaging.parts.WordprocessingML.PeoplePart;
import org.docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.VbaDataPart;
import org.docx4j.openpackaging.parts.WordprocessingML.VbaProjectBinaryPart;
import org.docx4j.openpackaging.parts.WordprocessingML.VbaProjectSignatureBin;
import org.docx4j.openpackaging.parts.WordprocessingML.WebSettingsPart;
import org.docx4j.openpackaging.parts.XmlPart;
import org.docx4j.openpackaging.parts.opendope.ComponentsPart;
import org.docx4j.openpackaging.parts.opendope.ConditionsPart;
import org.docx4j.openpackaging.parts.opendope.JaxbCustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.opendope.QuestionsPart;
import org.docx4j.openpackaging.parts.opendope.StandardisedAnswersPart;
import org.docx4j.openpackaging.parts.opendope.XPathsPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartsAnalyzer {
    public static HashSet<Part> identifyUnsafeParts(Set<Map.Entry<PartName, Part>> parts) throws Docx4JException {
        HashSet<Part> unsafeParts = new HashSet<Part>();
        HashSet<Part> unsafeButRemovedParts = new HashSet<Part>();
        for (Map.Entry<PartName, Part> entry : parts) {
            Part p = entry.getValue();
            if (p instanceof BibliographyPart) continue;
            if (p instanceof ActiveXControlXmlPart) {
                unsafeParts.add(p);
                continue;
            }
            if (p instanceof CustomXmlDataStoragePart || p instanceof JaxbCustomXmlDataStoragePart || p instanceof ComponentsPart || p instanceof ConditionsPart || p instanceof QuestionsPart || p instanceof StandardisedAnswersPart || p instanceof XPathsPart) {
                unsafeButRemovedParts.add(p);
                continue;
            }
            if (p.getPartName().getName().startsWith("/word/glossary")) {
                unsafeButRemovedParts.add(p);
                continue;
            }
            if (p instanceof DocPropsCoverPagePart) {
                CoverPageProperties cpp = (CoverPageProperties)((DocPropsCoverPagePart)p).getContents();
                if (cpp == null) continue;
                cpp.setAbstract("some abstract");
                cpp.setCompanyAddress("some address");
                cpp.setCompanyEmail("foo@bar.com");
                cpp.setCompanyFax("12 123 1234");
                cpp.setCompanyPhone("12 123 1234");
                continue;
            }
            if (p instanceof DocPropsCorePart || p instanceof DocPropsCustomPart || p instanceof DocPropsExtendedPart) continue;
            if (p instanceof Chart || p instanceof ChartShapePart || p instanceof DiagramColorsPart || p instanceof DiagramDataPart || p instanceof DiagramDrawingPart || p instanceof DiagramLayoutHeaderPart || p instanceof DiagramLayoutPart || p instanceof DiagramStylePart || p instanceof Drawing || p instanceof JaxbDmlPart) {
                unsafeParts.add(p);
                continue;
            }
            if (p instanceof ThemeOverridePart || p instanceof ThemePart) continue;
            if (p instanceof CommentAuthorsPart || p instanceof CommentsPart || p instanceof FontDataPart || p instanceof HandoutMasterPart || p instanceof JaxbPmlPart || p instanceof MainPresentationPart || p instanceof NotesMasterPart || p instanceof NotesSlidePart || p instanceof PresentationPropertiesPart || p instanceof SlideLayoutPart || p instanceof SlideMasterPart || p instanceof SlidePart || p instanceof TableStylesPart || p instanceof TagsPart || p instanceof ViewPropertiesPart) {
                unsafeParts.add(p);
                continue;
            }
            if (p instanceof CalcChain || p instanceof org.docx4j.openpackaging.parts.SpreadsheetML.CommentsPart || p instanceof ConnectionsPart || p instanceof ExternalLinkPart || p instanceof JaxbSmlPart || p instanceof PivotCacheDefinition || p instanceof PivotCacheRecords || p instanceof PivotTable || p instanceof PrinterSettings || p instanceof QueryTablePart || p instanceof SharedStrings || p instanceof Styles || p instanceof TablePart || p instanceof WorkbookPart || p instanceof WorksheetPart) {
                unsafeParts.add(p);
                continue;
            }
            if (p instanceof VMLBinaryPart || p instanceof VMLPart) {
                unsafeParts.add(p);
                continue;
            }
            if (p instanceof org.docx4j.openpackaging.parts.WordprocessingML.CommentsPart || p instanceof CommentsExtendedPart || p instanceof CustomXmlDataStoragePropertiesPart || p instanceof FooterPart || p instanceof FootnotesPart || p instanceof HeaderPart || p instanceof ImageBmpPart || p instanceof ImageGifPart || p instanceof ImageJpegPart || p instanceof ImagePngPart || p instanceof ImageTiffPart || p instanceof MainDocumentPart || p instanceof DocumentSettingsPart || p instanceof EndnotesPart || p instanceof FontTablePart || p instanceof NumberingDefinitionsPart || p instanceof ObfuscatedFontPart || p instanceof StyleDefinitionsPart || p.getPartName().getName().equals("/word/stylesWithEffects.xml") || p instanceof WebSettingsPart) continue;
            if (p instanceof ImageEpsPart || p instanceof AlternativeFormatInputPart || p instanceof DocumentPart || p instanceof EmbeddedPackagePart || p instanceof GlossaryDocumentPart || p instanceof MetafileEmfPart || p instanceof MetafileWmfPart || p instanceof MetafilePart || p instanceof OleObjectBinaryPart || p instanceof PeoplePart || p instanceof VbaDataPart || p instanceof VbaProjectBinaryPart || p instanceof VbaProjectSignatureBin) {
                unsafeParts.add(p);
                continue;
            }
            if (p instanceof XmlPart || p instanceof DefaultXmlPart || p instanceof JaxbXmlPart || p instanceof BinaryPart) {
                unsafeParts.add(p);
                continue;
            }
            unsafeParts.add(p);
        }
        return unsafeParts;
    }
}

