/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.html;

import org.docx4j.convert.out.AbstractConversionSettings;
import org.docx4j.convert.out.ConversionHTMLScriptElementHandler;
import org.docx4j.convert.out.ConversionHTMLStyleElementHandler;
import org.docx4j.convert.out.HTMLSettings;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.common.AbstractWriterRegistry;
import org.docx4j.convert.out.common.ConversionSectionWrappers;
import org.docx4j.convert.out.common.writer.AbstractMessageWriter;
import org.docx4j.convert.out.html.BookmarkStartWriter;
import org.docx4j.convert.out.html.BrWriter;
import org.docx4j.convert.out.html.FldSimpleWriter;
import org.docx4j.convert.out.html.HTMLConversionImageHandler;
import org.docx4j.convert.out.html.HyperlinkWriter;
import org.docx4j.convert.out.html.SymbolWriter;
import org.docx4j.convert.out.html.TableWriter;
import org.docx4j.fonts.Mapper;
import org.docx4j.fonts.RunFontSelector;
import org.docx4j.model.images.ConversionImageHandler;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.CTBookmark;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class HTMLConversionContext
extends AbstractWmlConversionContext {
    protected Mapper fontMapper;
    protected ConversionHTMLStyleElementHandler styleElementHandler;
    protected ConversionHTMLScriptElementHandler scriptElementHandler;
    protected String userCSS;
    protected String userScript;
    protected String userBodyTop;
    protected String userBodyTail;
    protected static final ConversionHTMLStyleElementHandler DEFAULT_STYLE_ELEMENT_HANDLER = new ConversionHTMLStyleElementHandler(){

        public Element createStyleElement(OpcPackage opcPackage, Document document, String styleDefinition) {
            Element ret = null;
            if (styleDefinition != null && styleDefinition.length() > 0) {
                ret = document.createElement("style");
                ret.appendChild(document.createComment(styleDefinition));
            }
            return ret;
        }
    };
    protected static final ConversionHTMLScriptElementHandler DEFAULT_SCRIPT_ELEMENT_HANDLER = new ConversionHTMLScriptElementHandler(){

        public Element createScriptElement(OpcPackage opcPackage, Document document, String scriptDefinition) {
            Element ret = null;
            if (scriptDefinition != null && scriptDefinition.length() > 0) {
                ret = document.createElement("script");
                ret.setAttribute("type", "text/javascript");
                ret.appendChild(document.createComment(scriptDefinition));
            }
            return ret;
        }
    };
    protected static final AbstractWriterRegistry HTML_WRITER_REGISTRY = new AbstractWriterRegistry(){

        protected void registerDefaultWriterInstances() {
            this.registerWriter(new TableWriter());
            this.registerWriter(new SymbolWriter());
            this.registerWriter(new BrWriter());
            this.registerWriter(new FldSimpleWriter());
            this.registerWriter(new BookmarkStartWriter());
            this.registerWriter(new HyperlinkWriter());
        }
    };
    protected static final AbstractMessageWriter HTML_MESSAGE_WRITER = new AbstractMessageWriter(){

        protected String getOutputPrefix() {
            return "<div style=\"color:red\" >";
        }

        protected String getOutputSuffix() {
            return "</div>";
        }
    };
    private CTBookmark bookmarkStart;

    public HTMLConversionContext(HTMLSettings settings, WordprocessingMLPackage preprocessedPackage, ConversionSectionWrappers conversionSectionWrappers) {
        super(HTML_WRITER_REGISTRY, HTML_MESSAGE_WRITER, settings, preprocessedPackage, conversionSectionWrappers, HTMLConversionContext.createRunFontSelector(preprocessedPackage));
    }

    private static RunFontSelector createRunFontSelector(WordprocessingMLPackage wmlPackage) {
        return new RunFontSelector(wmlPackage, new RunFontSelector.RunFontCharacterVisitor(){
            DocumentFragment df;
            StringBuilder sb = new StringBuilder(1024);
            Element span;
            String lastFont;
            String fallbackFontName;
            private Document document;
            private boolean spanReusable = true;
            private RunFontSelector runFontSelector;

            public void setDocument(Document document) {
                this.document = document;
                this.df = document.createDocumentFragment();
            }

            public boolean isReusable() {
                return this.spanReusable;
            }

            public void addCharacterToCurrent(char c) {
                this.sb.append(c);
            }

            public void addCodePointToCurrent(int cp) {
                this.sb.append(new String(Character.toChars(cp)));
            }

            public void finishPrevious() {
                if (this.sb.length() > 0) {
                    if (this.span == null) {
                        this.span = this.runFontSelector.createElement(this.document);
                        if (this.lastFont != null) {
                            this.runFontSelector.setAttribute(this.span, this.lastFont);
                        }
                    }
                    this.df.appendChild(this.span);
                    this.span.setTextContent(this.sb.toString());
                    this.sb.setLength(0);
                }
            }

            public void createNew() {
                this.span = this.runFontSelector.createElement(this.document);
            }

            public void setMustCreateNewFlag(boolean val) {
                this.spanReusable = !val;
            }

            public void fontAction(String fontname) {
                if (fontname == null) {
                    this.runFontSelector.setAttribute(this.span, this.fallbackFontName);
                } else {
                    this.runFontSelector.setAttribute(this.span, fontname);
                    this.lastFont = fontname;
                }
            }

            public Object getResult() {
                this.span = null;
                return this.df;
            }

            public void setRunFontSelector(RunFontSelector runFontSelector) {
                this.runFontSelector = runFontSelector;
            }

            public void setFallbackFont(String fontname) {
                this.fallbackFontName = fontname;
            }
        }, RunFontSelector.RunFontActionType.XHTML);
    }

    public HTMLConversionContext(AbstractWriterRegistry writerRegistry, HTMLSettings settings, WordprocessingMLPackage preprocessedPackage, ConversionSectionWrappers conversionSectionWrappers) {
        super(writerRegistry, HTML_MESSAGE_WRITER, settings, preprocessedPackage, conversionSectionWrappers, HTMLConversionContext.createRunFontSelector(preprocessedPackage));
    }

    protected void initializeSettings(AbstractConversionSettings settings, OpcPackage localOpcPackage) {
        HTMLSettings htmlSettings = null;
        if (settings == null) {
            settings = new HTMLSettings();
        } else if (!(settings instanceof HTMLSettings)) {
            throw new IllegalArgumentException("The class of the settings isn't HtmlSettings, it is " + settings.getClass().getName());
        }
        htmlSettings = (HTMLSettings)settings;
        super.initializeSettings(htmlSettings, localOpcPackage);
        this.fontMapper = htmlSettings.getFontMapper();
        if (this.fontMapper == null) {
            this.fontMapper = this.getWmlPackage().getFontMapper();
        }
        this.userCSS = htmlSettings.getUserCSS();
        this.userScript = htmlSettings.getUserScript();
        this.userBodyTop = htmlSettings.getUserBodyTop();
        this.userBodyTail = htmlSettings.getUserBodyTail();
        this.styleElementHandler = htmlSettings.getStyleElementHandler();
        if (this.styleElementHandler == null) {
            this.styleElementHandler = DEFAULT_STYLE_ELEMENT_HANDLER;
        }
        this.scriptElementHandler = htmlSettings.getScriptElementHandler();
        if (this.scriptElementHandler == null) {
            this.scriptElementHandler = DEFAULT_SCRIPT_ELEMENT_HANDLER;
        }
    }

    protected ConversionImageHandler initializeImageHandler(AbstractConversionSettings settings, ConversionImageHandler handler) {
        HTMLSettings htmlSettings = (HTMLSettings)settings;
        if (handler == null) {
            handler = new HTMLConversionImageHandler(htmlSettings.getImageDirPath(), htmlSettings.getImageTargetUri(), htmlSettings.isImageIncludeUUID());
        }
        return handler;
    }

    public Mapper getFontMapper() {
        return this.fontMapper;
    }

    public Element createStyleElement(Document document, String styleDefinition) {
        return this.styleElementHandler.createStyleElement(this.getWmlPackage(), document, styleDefinition);
    }

    public Element createScriptElement(Document document, String scriptDefinition) {
        return this.scriptElementHandler.createScriptElement(this.getWmlPackage(), document, scriptDefinition);
    }

    public String getUserCSS() {
        return this.userCSS;
    }

    public String getUserScript() {
        return this.userScript;
    }

    public String getUserBodyTop() {
        return this.userBodyTop;
    }

    public String getUserBodyTail() {
        return this.userBodyTail;
    }

    public CTBookmark getBookmarkStart() {
        return this.bookmarkStart;
    }

    public void setBookmarkStart(CTBookmark bookmarkStart) {
        this.bookmarkStart = bookmarkStart;
    }
}

