/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.html;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.docx4j.model.properties.Property;
import org.docx4j.model.properties.PropertyFactory;
import org.docx4j.model.properties.paragraph.Indent;
import org.docx4j.model.properties.paragraph.PBorderBottom;
import org.docx4j.model.properties.paragraph.PBorderTop;
import org.docx4j.model.properties.paragraph.PShading;
import org.docx4j.model.styles.Node;
import org.docx4j.model.styles.StyleTree;
import org.docx4j.model.styles.Tree;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.wml.CTShd;
import org.docx4j.wml.CTTblPrBase;
import org.docx4j.wml.CTTblStylePr;
import org.docx4j.wml.PPr;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Style;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.TrPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlCssHelper {
    private static Logger log = LoggerFactory.getLogger(HtmlCssHelper.class);
    private static ThreadLocal<Map<String, Property>> threadLocalTempMap = new ThreadLocal();

    public static void createDefaultCss(boolean hasDefaultHeader, boolean hasDefaultFooter, StringBuilder result) {
        result.append("/*paged media */ div.header {display: none }");
        result.append("div.footer {display: none } /*@media print { */");
        if (hasDefaultHeader) {
            result.append("div.header {display: block; position: running(header) }");
        }
        if (hasDefaultFooter) {
            result.append("div.footer {display: block; position: running(footer) }");
        }
        result.append("@page { size: A4; margin: 10%; @top-center {");
        result.append("content: element(header) } @bottom-center {");
        result.append("content: element(footer) } }");
        result.append("/*element styles*/ .del  {text-decoration:line-through;color:red;} ");
        result.append(".ins {text-decoration:none;background:#c0ffc0;padding:1px;}");
    }

    public static void createCssForStyles(OpcPackage opcPackage, StyleTree styleTree, StringBuilder result) {
        result.append("\n /* TABLE STYLES */ \n");
        Tree<StyleTree.AugmentedStyle> tableTree = styleTree.getTableStylesTree();
        for (Node<StyleTree.AugmentedStyle> n : tableTree.toList()) {
            if (n.getData() == null) {
                if (n.equals(tableTree.getRootElement())) continue;
                log.error("Node<AugmentedStyle> unexpectedly null data");
                continue;
            }
            Style style = n.getData().getStyle();
            result.append("table." + style.getStyleId() + " {display:table;");
            if (style.getTblPr() != null) {
                log.debug("Applying tblPr..");
                HtmlCssHelper.createCss(style.getTblPr(), result);
            }
            if (style.getTblStylePr() != null) {
                log.debug("Applying tblStylePr.. TODO!");
                HtmlCssHelper.createCss(style.getTblStylePr(), result);
            }
            if (style.getTrPr() != null) {
                log.debug("Applying trPr.. TODO!");
                HtmlCssHelper.createCss(style.getTrPr(), result);
            }
            if (style.getTcPr() != null) {
                log.debug("Applying tcPr.. ");
                HtmlCssHelper.createCss(style.getTcPr(), result);
            }
            if (style.getPPr() == null) {
                log.debug("null pPr for style " + style.getStyleId());
            } else {
                HtmlCssHelper.createCss(opcPackage, style.getPPr(), result, false, false);
            }
            if (style.getRPr() == null) {
                log.debug("null rPr for style " + style.getStyleId());
            } else {
                HtmlCssHelper.createCss(opcPackage, style.getRPr(), result);
            }
            result.append("}\n");
        }
        result.append("\n /* PARAGRAPH STYLES */ \n");
        Tree<StyleTree.AugmentedStyle> pTree = styleTree.getParagraphStylesTree();
        for (Node node : pTree.toList()) {
            if (node.getData() == null) {
                if (node.equals(pTree.getRootElement())) continue;
                log.error("Node<AugmentedStyle> unexpectedly null data");
                continue;
            }
            Style s = ((StyleTree.AugmentedStyle)node.getData()).getStyle();
            result.append("." + s.getStyleId() + " {display:block;");
            if (s.getPPr() == null) {
                log.debug("null pPr for style " + s.getStyleId());
            } else {
                HtmlCssHelper.createCss(opcPackage, s.getPPr(), result, false, false);
            }
            if (s.getRPr() == null) {
                log.debug("null rPr for style " + s.getStyleId());
            } else {
                HtmlCssHelper.createCss(opcPackage, s.getRPr(), result);
            }
            result.append("}\n");
        }
        result.append("\n /* CHARACTER STYLES */ ");
        Tree<StyleTree.AugmentedStyle> cTree = styleTree.getCharacterStylesTree();
        for (Node<StyleTree.AugmentedStyle> n : cTree.toList()) {
            if (n.getData() == null) {
                if (n.equals(cTree.getRootElement())) continue;
                log.error("Node<AugmentedStyle> unexpectedly null data");
                continue;
            }
            Style s = n.getData().getStyle();
            result.append("span." + s.getStyleId() + " {display:inline;");
            if (s.getRPr() == null) {
                log.warn("! null rPr for character style " + s.getStyleId());
            } else {
                HtmlCssHelper.createCss(opcPackage, s.getRPr(), result);
            }
            result.append("}\n");
        }
    }

    protected static void createCss(CTTblPrBase tblPr, StringBuilder result) {
        if (tblPr == null) {
            return;
        }
        List<Property> properties = PropertyFactory.createProperties(tblPr);
        for (Property p : properties) {
            HtmlCssHelper.appendNonNull(result, p);
        }
    }

    protected static void createCss(List<CTTblStylePr> tblStylePrList, StringBuilder result) {
        if (tblStylePrList == null) {
            return;
        }
        List<Property> properties = PropertyFactory.createProperties(tblStylePrList);
        for (Property p : properties) {
            HtmlCssHelper.appendNonNull(result, p);
        }
    }

    protected static void createCss(TrPr trPr, StringBuilder result) {
        if (trPr == null) {
            return;
        }
        List<Property> properties = PropertyFactory.createProperties(trPr);
        for (Property p : properties) {
            HtmlCssHelper.appendNonNull(result, p);
        }
    }

    protected static void createCss(TcPr tcPr, StringBuilder result) {
        if (tcPr == null) {
            return;
        }
        List<Property> properties = PropertyFactory.createProperties(tcPr);
        for (Property p : properties) {
            HtmlCssHelper.appendNonNull(result, p);
        }
    }

    public static void createCss(OpcPackage opcPackage, PPr pPr, StringBuilder result, boolean ignoreBorders, boolean isListItem) {
        if (isListItem) {
            result.append("display: list-item;");
        }
        if (pPr == null) {
            return;
        }
        List<Property> properties = PropertyFactory.createProperties(opcPackage, pPr);
        for (Property p : properties) {
            if (ignoreBorders && (p instanceof PBorderTop || p instanceof PBorderBottom) || isListItem && p instanceof Indent) continue;
            if (p instanceof PShading) {
                String fill = ((CTShd)p.getObject()).getFill();
                result.append("border-color: #" + fill + "; border-style:solid; border-width:1px;");
            }
            HtmlCssHelper.appendNonNull(result, p);
        }
    }

    public static void createCss(OpcPackage opcPackage, RPr rPr, StringBuilder result) {
        List<Property> properties = PropertyFactory.createProperties(opcPackage, rPr);
        for (Property p : properties) {
            HtmlCssHelper.appendNonNull(result, p);
        }
    }

    private static void appendNonNull(StringBuilder result, Property p) {
        String prop = p.getCssProperty();
        if (prop != null) {
            result.append(prop);
        }
    }

    public static void applyAttributes(List<Property> properties, Element node) {
        Map<String, Property> tempAttributeMap = null;
        StringBuilder buffer = null;
        if (properties != null && !properties.isEmpty()) {
            tempAttributeMap = HtmlCssHelper.getTempMap();
            if (properties != null && !properties.isEmpty()) {
                buffer = new StringBuilder();
                for (int i = 0; i < properties.size(); ++i) {
                    tempAttributeMap.put(properties.get(i).getCssName(), properties.get(i));
                }
                for (Property property : tempAttributeMap.values()) {
                    buffer.append(property.getCssProperty());
                }
                tempAttributeMap.clear();
                HtmlCssHelper.appendStyle(node, buffer.toString());
            }
        }
    }

    public static void appendStyle(Element node, String newValue) {
        String style = node.getAttribute("style");
        if (style != null && style.length() > 0) {
            node.setAttribute("style", style + newValue);
        } else {
            node.setAttribute("style", newValue);
        }
    }

    protected static Map<String, Property> getTempMap() {
        Map<String, Property> ret = threadLocalTempMap.get();
        if (ret == null) {
            ret = new TreeMap<String, Property>();
            threadLocalTempMap.set(ret);
        }
        return ret;
    }
}

