/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.diff;

import com.topologi.diffx.Docx4jDriver;
import com.topologi.diffx.Main;
import com.topologi.diffx.config.DiffXConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.stream.StreamSource;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.utils.ResourceUtils;
import org.docx4j.wml.Body;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.SdtContentBlock;
import org.docx4j.wml.Text;
import org.eclipse.compare.StringComparator;
import org.eclipse.compare.internal.LCSSettings;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Differencer {
    protected static Logger log = LoggerFactory.getLogger(Differencer.class);
    static ObjectFactory wmlFactory = new ObjectFactory();
    private Map<Relationship, Part> composedRels = new HashMap<Relationship, Part>();
    private static final SimpleDateFormat RFC3339_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    static Templates xsltDiffx2Wml;
    static Templates xsltMarkupInsert;
    static Templates xsltMarkupDelete;
    public static Integer nextId;
    private String relsDiffIdentifier;

    public static void log(String message) {
        log.info(message);
    }

    public Map<Relationship, Part> getComposedRels() {
        return this.composedRels;
    }

    public static void setXsltDiffx2Wml(Templates xsltDiffx2Wml) {
        Differencer.xsltDiffx2Wml = xsltDiffx2Wml;
    }

    public static final Integer getId() {
        nextId = nextId + 1;
        return nextId;
    }

    public void setRelsDiffIdentifier(String relsDiffIdentifier) {
        this.relsDiffIdentifier = relsDiffIdentifier;
    }

    public static void registerRelationship(Differencer pd, RelationshipsPart docPartRels, String relId, String newRelId) {
        if (docPartRels == null) {
            return;
        }
        if (docPartRels.getRelationships() == null) {
            log.warn("relationships object is null!");
            return;
        }
        log.debug("Looking for rel " + relId);
        Relationship r = docPartRels.getRelationshipByID(relId);
        if (r == null) {
            log.error("Couldn't find rel " + relId);
            return;
        }
        Part p = docPartRels.getPart(r);
        Relationship r2 = XmlUtils.deepCopy(r, Context.jcRelationships);
        r2.setId(newRelId);
        log.debug(".. added rel " + newRelId + " -- " + r2.getTarget());
        pd.composedRels.put(r2, p);
    }

    public void diff(P pl, P pr, Result result, String author, Calendar date, RelationshipsPart docPartRelsLeft, RelationshipsPart docPartRelsRight) {
        this.diff(pl, pr, result, author, date, docPartRelsLeft, docPartRelsRight, false);
    }

    public void diff(SdtContentBlock cbNewer, SdtContentBlock cbOlder, Result result, String author, Calendar date, RelationshipsPart docPartRelsNewer, RelationshipsPart docPartRelsOlder) {
        this.diffWorker(XmlUtils.marshaltoW3CDomDocument(cbNewer).getDocumentElement(), XmlUtils.marshaltoW3CDomDocument(cbOlder).getDocumentElement(), result, author, date, docPartRelsNewer, docPartRelsOlder);
    }

    public void diff(Body newer, Body older, Result result, String author, Calendar date, RelationshipsPart docPartRelsNewer, RelationshipsPart docPartRelsOlder) {
        this.diffWorker(XmlUtils.marshaltoW3CDomDocument(newer).getDocumentElement(), XmlUtils.marshaltoW3CDomDocument(older).getDocumentElement(), result, author, date, docPartRelsNewer, docPartRelsOlder);
    }

    private void diffWorker(Node newer, Node older, Result result, String author, Calendar date, RelationshipsPart docPartRelsNewer, RelationshipsPart docPartRelsOlder) {
        StringWriter diffxResult = new StringWriter();
        try {
            Docx4jDriver.diff(newer, older, diffxResult);
            ((Writer)diffxResult).close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            diffxResult = null;
        }
        this.toWML(((Object)diffxResult).toString(), result, author, date, docPartRelsNewer, docPartRelsOlder);
    }

    public void toWML(String in, Result result, String author, Calendar date, RelationshipsPart docPartRelsNewer, RelationshipsPart docPartRelsOlder) {
        if (log.isDebugEnabled()) {
            log.debug("in: " + in);
        }
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            inputFactory.setProperty("javax.xml.stream.supportDTD", false);
            int nsIndex = in.indexOf("xmlns:");
            int closeTag = in.indexOf(">", nsIndex);
            String topLevelDecs = in.substring(0, closeTag);
            log.debug(topLevelDecs);
            if (!topLevelDecs.contains("xmlns:a14")) {
                in = topLevelDecs + " xmlns:a14=\"http://schemas.microsoft.com/office/drawing/2010/main\"" + in.substring(closeTag);
            }
            if (!topLevelDecs.contains("xmlns:w14")) {
                in = topLevelDecs + " xmlns:w14=\"http://schemas.microsoft.com/office/word/2010/wordml\"" + in.substring(closeTag);
            }
            if (!topLevelDecs.contains("xmlns:o")) {
                in = topLevelDecs + " xmlns:o=\"urn:schemas-microsoft-com:office:office\"" + in.substring(closeTag);
            }
            if (log.isDebugEnabled()) {
                log.debug("Diff result:" + in);
            }
            StringReader reader = new StringReader(in);
            String simplified = null;
            try {
                simplified = Differencer.combineAdjacent(inputFactory.createXMLStreamReader(reader));
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            log.debug("\n\n Diff'd input to transform: \n\n" + simplified);
            StreamSource src = new StreamSource(new StringReader(simplified));
            this.transformDiffxOutputToWml(result, author, date, docPartRelsNewer, docPartRelsOlder, src);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private void transformDiffxOutputToWml(Result result, String author, Calendar date, RelationshipsPart docPartRelsLeft, RelationshipsPart docPartRelsRight, StreamSource src) throws Exception {
        HashMap<String, Object> transformParameters = new HashMap<String, Object>();
        String dateString = date != null ? RFC3339_FORMAT.format(date.getTime()) : "2009-03-11T17:57:00Z";
        transformParameters.put("Differencer", this);
        transformParameters.put("date", dateString);
        transformParameters.put("author", author);
        transformParameters.put("docPartRelsLeft", docPartRelsLeft);
        transformParameters.put("docPartRelsRight", docPartRelsRight);
        transformParameters.put("relsDiffIdentifier", this.relsDiffIdentifier);
        log.debug("invoking xsltDiffx2Wml");
        XmlUtils.transform(src, xsltDiffx2Wml, transformParameters, result);
    }

    public void markupAsInsertion(SdtContentBlock cbLeft, Result result, String author, Calendar date, RelationshipsPart docPartRelsLeft) {
        StringWriter diffxResult = new StringWriter();
        try {
            JAXBContext jc = Context.jc;
            Marshaller marshaller = jc.createMarshaller();
            Document doc = XmlUtils.neww3cDomDocument();
            marshaller.marshal((Object)cbLeft, (Node)doc);
            HashMap<String, Object> transformParameters = new HashMap<String, Object>();
            if (date != null) {
                String dateString = RFC3339_FORMAT.format(date.getTime());
                transformParameters.put("date", dateString);
            }
            transformParameters.put("Differencer", this);
            transformParameters.put("author", author);
            transformParameters.put("docPartRelsLeft", docPartRelsLeft);
            transformParameters.put("docPartRelsRight", null);
            transformParameters.put("relsDiffIdentifier", this.relsDiffIdentifier);
            XmlUtils.transform(doc, xsltMarkupInsert, transformParameters, result);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void markupAsDeletion(SdtContentBlock cbLeft, Result result, String author, Calendar date, RelationshipsPart docPartRelsRight) {
        StringWriter diffxResult = new StringWriter();
        try {
            JAXBContext jc = Context.jc;
            Marshaller marshaller = jc.createMarshaller();
            Document doc = XmlUtils.neww3cDomDocument();
            marshaller.marshal((Object)cbLeft, (Node)doc);
            HashMap<String, Object> transformParameters = new HashMap<String, Object>();
            if (date != null) {
                String dateString = RFC3339_FORMAT.format(date.getTime());
                transformParameters.put("date", dateString);
            }
            transformParameters.put("Differencer", this);
            transformParameters.put("author", author);
            transformParameters.put("docPartRelsLeft", null);
            transformParameters.put("docPartRelsRight", docPartRelsRight);
            transformParameters.put("relsDiffIdentifier", this.relsDiffIdentifier);
            log.debug("applying xsltMarkupDelete");
            XmlUtils.transform(doc, xsltMarkupDelete, transformParameters, result);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void diff(P pl, P pr, Result result, String author, Calendar date, RelationshipsPart docPartRelsLeft, RelationshipsPart docPartRelsRight, boolean preProcess) {
        String leftXmlOld = null;
        String rightXmlOld = null;
        if (!preProcess || log.isDebugEnabled()) {
            leftXmlOld = XmlUtils.marshaltoString((Object)pl, true, false);
            rightXmlOld = XmlUtils.marshaltoString((Object)pr, true, false);
        }
        if (!preProcess) {
            String naive = Differencer.getDiffxOutput(leftXmlOld, rightXmlOld);
            log.debug("\n\n naive difference \n\n");
            log.debug(naive);
            log.info("\n\n <p> difference without preprocessing </p> \n\n");
            try {
                XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
                inputFactory.setProperty("javax.xml.stream.supportDTD", false);
                StringReader reader = new StringReader(naive);
                String simplified = Differencer.combineAdjacent(inputFactory.createXMLStreamReader(reader));
                log.debug("\n\n combineAdjacent: \n\n" + simplified);
                StreamSource src = new StreamSource(new StringReader(simplified));
                HashMap<String, Object> transformParameters = new HashMap<String, Object>();
                transformParameters.put("Differencer", this);
                transformParameters.put("author", author);
                transformParameters.put("docPartRelsLeft", docPartRelsLeft);
                transformParameters.put("docPartRelsRight", docPartRelsRight);
                transformParameters.put("relsDiffIdentifier", this.relsDiffIdentifier);
                XmlUtils.transform(src, xsltDiffx2Wml, transformParameters, result);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            return;
        }
        StringComparator left = new StringComparator(pl.toString());
        StringComparator right = new StringComparator(pr.toString());
        LCSSettings settings = new LCSSettings();
        RangeDifference[] rd = RangeDifferencer.findRanges(settings, left, right);
        if (log.isDebugEnabled()) {
            log.debug("\n\n RangeDifferences \n\n");
            for (int x = 0; x < rd.length; ++x) {
                log.debug(Differencer.toRangeString(left, rd[x].leftStart(), rd[x].leftLength(), true) + rd[x].kindString() + Differencer.toRangeString(right, rd[x].rightStart(), rd[x].rightLength(), true));
            }
        }
        ArrayList<R> pLeftReplacement = new ArrayList<R>();
        ArrayList<R> pRightReplacement = new ArrayList<R>();
        int pLeftIndex = 0;
        int pRightIndex = 0;
        int[] leftCounts = Differencer.getParagraphRunTextWordCounts(pl);
        int[] rightCounts = Differencer.getParagraphRunTextWordCounts(pr);
        int leftWordCounter = -1;
        int rightWordCounter = -1;
        for (int x = 0; x < rd.length; ++x) {
            String word;
            int i;
            R currentLeftStructure = Differencer.createRunStructure("", pl, pLeftIndex);
            R currentRightStructure = Differencer.createRunStructure("", pr, pRightIndex);
            pLeftReplacement.add(currentLeftStructure);
            pRightReplacement.add(currentRightStructure);
            if (rd[x].kind() == 0) {
                log.debug("NOCHANGE");
                for (i = rd[x].leftStart(); i < rd[x].leftStart() + rd[x].leftLength(); ++i) {
                    word = left.getLeaf(i);
                    if (++leftWordCounter < Differencer.sum(leftCounts, 0, pLeftIndex) && ++rightWordCounter < Differencer.sum(rightCounts, 0, pRightIndex)) {
                        Differencer.addWord(currentLeftStructure, word);
                        Differencer.addWord(currentRightStructure, word);
                        continue;
                    }
                    if (leftWordCounter == Differencer.sum(leftCounts, 0, pLeftIndex) && rightWordCounter == Differencer.sum(rightCounts, 0, pRightIndex)) {
                        ++pLeftIndex;
                        ++pRightIndex;
                    } else if (leftWordCounter == Differencer.sum(leftCounts, 0, pLeftIndex)) {
                        ++pLeftIndex;
                    } else {
                        ++pRightIndex;
                    }
                    currentLeftStructure = Differencer.createRunStructure(word, pl, pLeftIndex);
                    currentRightStructure = Differencer.createRunStructure(word, pr, pRightIndex);
                    pLeftReplacement.add(currentLeftStructure);
                    pRightReplacement.add(currentRightStructure);
                }
                continue;
            }
            if (rd[x].kind() != 2) continue;
            log.debug("CHANGE");
            log.debug(".. left side");
            for (i = rd[x].leftStart(); i < rd[x].leftStart() + rd[x].leftLength(); ++i) {
                word = left.getLeaf(i);
                if (++leftWordCounter < Differencer.sum(leftCounts, 0, pLeftIndex)) {
                    Differencer.addWord(currentLeftStructure, word);
                    continue;
                }
                currentLeftStructure = Differencer.createRunStructure(word, pl, ++pLeftIndex);
                pLeftReplacement.add(currentLeftStructure);
            }
            log.debug(".. right side");
            for (i = rd[x].rightStart(); i < rd[x].rightStart() + rd[x].rightLength(); ++i) {
                word = right.getLeaf(i);
                log.debug(word);
                if (++rightWordCounter < Differencer.sum(rightCounts, 0, pRightIndex)) {
                    Differencer.addWord(currentRightStructure, word);
                    continue;
                }
                currentRightStructure = Differencer.createRunStructure(word, pr, ++pRightIndex);
                pRightReplacement.add(currentRightStructure);
            }
        }
        P newLeftP = wmlFactory.createP();
        newLeftP.setPPr(pl.getPPr());
        newLeftP.getParagraphContent().addAll(pLeftReplacement);
        P newRightP = wmlFactory.createP();
        newRightP.setPPr(pr.getPPr());
        newRightP.getParagraphContent().addAll(pRightReplacement);
        log.debug("\n\n Left input \n\n");
        log.debug(leftXmlOld);
        log.debug("\n\n New left side \n\n");
        String leftXmlNew = XmlUtils.marshaltoString((Object)newLeftP, true, false);
        log.debug(leftXmlNew);
        log.debug("\n\n Right input \n\n");
        log.debug(rightXmlOld);
        log.debug("\n\n New right side \n\n");
        String rightXmlNew = XmlUtils.marshaltoString((Object)newRightP, true, false);
        log.debug(rightXmlNew);
        log.debug("\n\n Difference \n\n");
        String diffx = Differencer.getDiffxOutput(leftXmlNew, rightXmlNew);
        log.debug(diffx);
        log.info("\n\n <p> difference with pre-processing</p> \n\n");
        try {
            StreamSource src = new StreamSource(new StringReader(diffx));
            this.transformDiffxOutputToWml(result, author, date, docPartRelsLeft, docPartRelsRight, src);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        log.debug("\n\n Done!");
    }

    private static int sum(int[] array, int idx1, int idx2) {
        StringBuilder debug = new StringBuilder();
        debug.append("{ ");
        int sum = 0;
        for (int i = idx1; i <= idx2; ++i) {
            debug.append(array[i] + ", ");
            sum += array[i];
        }
        debug.append("} = " + sum);
        return sum;
    }

    private static void addWord(R r, String word) {
        List<Object> runContent = r.getRunContent();
        for (Object o2 : runContent) {
            boolean found = false;
            if (o2 instanceof Text) {
                if (found) {
                    log.debug("TODO: Handle multiple w:t in w:r!");
                }
                found = true;
                Text t = (Text)o2;
                String existingVal = t.getValue();
                t.setValue(existingVal + " " + word);
                continue;
            }
            log.debug(o2.getClass().getName());
        }
    }

    private static R createRunStructure(String textVal, P existingP, int rIndex) {
        R newR = wmlFactory.createR();
        Text newT = wmlFactory.createText();
        newR.getRunContent().add(newT);
        newT.setValue(textVal);
        newT.setSpace("preserve");
        RPr existingRPr = ((R)existingP.getParagraphContent().get(rIndex)).getRPr();
        if (existingRPr != null) {
            newR.setRPr(existingRPr);
        }
        return newR;
    }

    private static String toRangeString(StringComparator sc, int start, int length, boolean space) {
        StringBuilder result = new StringBuilder();
        for (int x = start; x < start + length; ++x) {
            if (space) {
                result.append(sc.getLeaf(x) + " ");
                continue;
            }
            result.append(sc.getLeaf(x));
        }
        return result.toString();
    }

    protected static P loadParagraph(String filename) throws Exception {
        File f = new File(filename);
        FileInputStream is = new FileInputStream(f);
        JAXBContext jc = Context.jc;
        Unmarshaller u = jc.createUnmarshaller();
        u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
        return (P)u.unmarshal((InputStream)is);
    }

    public static int[] getParagraphRunTextWordCounts(P p) {
        List<Object> children = p.getParagraphContent();
        int i = 0;
        int[] result = new int[children.size()];
        for (Object o : children) {
            if (o instanceof R) {
                R r = (R)o;
                List<Object> runContent = r.getRunContent();
                result[i] = 0;
                for (Object o2 : runContent) {
                    boolean found = false;
                    if (o2 instanceof JAXBElement) {
                        if (((JAXBElement)o2).getDeclaredType().getName().equals("org.docx4j.wml.Text")) {
                            if (found) {
                                log.debug("TODO: Handle multiple w:t in w:r!");
                            }
                            found = true;
                            Text t = (Text)((JAXBElement)o2).getValue();
                            result[i] = Differencer.getWordCount(t.getValue());
                            continue;
                        }
                        log.debug(((JAXBElement)o2).getDeclaredType().getName());
                        continue;
                    }
                    log.debug(o2.getClass().getName());
                }
                ++i;
                continue;
            }
            log.debug("Encountered " + children.get(i).getClass().getName());
            return null;
        }
        return result;
    }

    private static int getWordCount(String sentence) {
        return sentence.trim().split("\\s").length;
    }

    public static String getRunString(P p, int i) {
        StringBuilder result = new StringBuilder();
        List<Object> children = p.getParagraphContent();
        if (children.get(i) instanceof R) {
            R r = (R)children.get(i);
            List<Object> runContent = r.getRunContent();
            for (Object o2 : runContent) {
                if (o2 instanceof JAXBElement) {
                    if (((JAXBElement)o2).getDeclaredType().getName().equals("org.docx4j.wml.Text")) {
                        Text t = (Text)((JAXBElement)o2).getValue();
                        result.append(t.getValue());
                        continue;
                    }
                    log.debug(((JAXBElement)o2).getDeclaredType().getName());
                    continue;
                }
                log.debug(o2.getClass().getName());
            }
        } else {
            log.debug("Encountered " + children.get(i).getClass().getName());
            return null;
        }
        return result.toString();
    }

    private static String getDiffxOutput(String xml1, String xml2) {
        StringReader xmlr1 = new StringReader(xml1);
        StringReader xmlr2 = new StringReader(xml2);
        StringWriter out = new StringWriter();
        DiffXConfig diffxConfig = new DiffXConfig();
        diffxConfig.setIgnoreWhiteSpace(false);
        diffxConfig.setPreserveWhiteSpace(true);
        try {
            Main.diff(Differencer.toNode(xmlr1, true), Differencer.toNode(xmlr2, true), (Writer)out, diffxConfig);
            ((Writer)out).close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            out = null;
        }
        return out == null ? null : ((Object)out).toString();
    }

    private static Node toNode(Reader xml, boolean isNSAware) {
        try {
            Document document = XmlUtils.getNewDocumentBuilder().parse(new InputSource(xml));
            return document;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static String combineAdjacent(XMLStreamReader reader) throws XMLStreamException {
        String memory = null;
        StringWriter stringWriter = new StringWriter();
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = factory.createXMLStreamWriter(stringWriter);
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 2: {
                    if (reader.getLocalName().equals("ins")) {
                        memory = "ins";
                        break;
                    }
                    if (reader.getLocalName().equals("del")) {
                        memory = "del";
                        break;
                    }
                    writer.writeEndElement();
                    break;
                }
                case 1: {
                    try {
                        int i;
                        if (memory != null) {
                            if (memory.equals(reader.getLocalName())) {
                                memory = null;
                                break;
                            }
                            writer.writeEndElement();
                            memory = null;
                        }
                        if (reader.getNamespaceURI() == null) {
                            writer.writeStartElement(reader.getLocalName());
                        } else {
                            writer.writeStartElement(reader.getPrefix(), reader.getLocalName(), reader.getNamespaceURI());
                        }
                        for (i = 0; i < reader.getAttributeCount(); ++i) {
                            if (reader.getAttributeNamespace(i) == null) {
                                writer.writeAttribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                                continue;
                            }
                            writer.writeAttribute(reader.getAttributePrefix(i), reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                        }
                        for (i = 0; i < reader.getNamespaceCount(); ++i) {
                            writer.writeNamespace(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
                        }
                        break;
                    }
                    catch (XMLStreamException e) {
                        log.error("Issue at element: " + reader.getLocalName() + "\n", (Throwable)e);
                        throw e;
                    }
                }
                case 4: {
                    if (memory != null) {
                        writer.writeEndElement();
                        memory = null;
                    }
                    writer.writeCharacters(reader.getText());
                    break;
                }
                case 7: {
                    writer.writeStartDocument();
                    break;
                }
                case 8: {
                    writer.writeEndDocument();
                    break;
                }
            }
        }
        writer.flush();
        writer.close();
        return stringWriter.toString();
    }

    public static void main(String[] args) throws Exception {
        StringWriter diffxResult = new StringWriter();
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            inputFactory.setProperty("javax.xml.stream.supportDTD", false);
            String simplified = Differencer.combineAdjacent(inputFactory.createXMLStreamReader(new FileInputStream(new File("tmp_adj.xml"))));
            System.out.println("Done");
        }
        catch (Exception exc) {
            exc.printStackTrace();
            diffxResult = null;
        }
    }

    static {
        try {
            StreamSource xsltSource = new StreamSource(ResourceUtils.getResource("org/docx4j/diff/diffx2wml.xslt"));
            xsltDiffx2Wml = XmlUtils.getTransformerTemplate(xsltSource);
            xsltSource = new StreamSource(ResourceUtils.getResource("org/docx4j/diff/MarkupInsert.xslt"));
            xsltMarkupInsert = XmlUtils.getTransformerTemplate(xsltSource);
            xsltSource = new StreamSource(ResourceUtils.getResource("org/docx4j/diff/MarkupDelete.xslt"));
            xsltMarkupDelete = XmlUtils.getTransformerTemplate(xsltSource);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        nextId = 0;
    }
}

