/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts.autodetect;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.docx4j.fonts.fop.fonts.autodetect.FontFinder;

public class WindowsFontDirFinder
implements FontFinder {
    private String getWinDir(String osName) throws IOException {
        Process process = null;
        Runtime runtime = Runtime.getRuntime();
        process = osName.startsWith("Windows 9") ? runtime.exec("command.com /c echo %windir%") : runtime.exec("cmd.exe /c echo %windir%");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        return bufferedReader.readLine();
    }

    public List find() {
        ArrayList<File> fontDirList;
        block10: {
            char driveLetter;
            File psFontsDir;
            File osFontsDir;
            String osName;
            block9: {
                fontDirList = new ArrayList<File>();
                String windir = null;
                try {
                    windir = System.getProperty("env.windir");
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                osName = System.getProperty("os.name");
                if (windir == null) {
                    try {
                        windir = this.getWinDir(osName);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                osFontsDir = null;
                psFontsDir = null;
                if (windir == null) break block9;
                if (windir.endsWith("/")) {
                    windir = windir.substring(0, windir.length() - 1);
                }
                if ((osFontsDir = new File(windir + File.separator + "FONTS")).exists() && osFontsDir.canRead()) {
                    fontDirList.add(osFontsDir);
                }
                if (!(psFontsDir = new File(windir.substring(0, 2) + File.separator + "PSFONTS")).exists() || !psFontsDir.canRead()) break block10;
                fontDirList.add(psFontsDir);
                break block10;
            }
            String windowsDirName = osName.endsWith("NT") ? "WINNT" : "WINDOWS";
            for (driveLetter = 'C'; driveLetter <= 'E'; driveLetter = (char)(driveLetter + '\u0001')) {
                osFontsDir = new File(driveLetter + ":" + File.separator + windowsDirName + File.separator + "FONTS");
                if (!osFontsDir.exists() || !osFontsDir.canRead()) continue;
                fontDirList.add(osFontsDir);
                break;
            }
            for (driveLetter = 'C'; driveLetter <= 'E'; driveLetter = (char)(driveLetter + '\u0001')) {
                psFontsDir = new File(driveLetter + ":" + File.separator + "PSFONTS");
                if (!psFontsDir.exists() || !psFontsDir.canRead()) continue;
                fontDirList.add(psFontsDir);
                break;
            }
        }
        return fontDirList;
    }
}

