/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.foray.font.format;

import java.io.Serializable;

public final class Panose
implements Serializable {
    private static final long serialVersionUID = -6678392067062344333L;
    private static final byte LETTERFORM_MIN_ITALIC = 9;
    private static final byte WEIGHT_MIN_BOLD = 7;
    private static final byte[] NEUTRAL_WEIGHTS = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private byte[] panoseArray;

    private Panose(byte[] panoseArray) {
        this.panoseArray = (byte[])panoseArray.clone();
    }

    public static Panose makeInstance(byte[] panoseArray) {
        String panoseValidationMessage = Panose.validPanose(panoseArray);
        if (panoseValidationMessage != null) {
            throw new IllegalArgumentException("Illegal Panose Array: " + panoseValidationMessage);
        }
        return new Panose(panoseArray);
    }

    public static Panose forceInstance(byte[] panoseArray) {
        return new Panose(panoseArray);
    }

    public byte[] getPanoseArray() {
        return (byte[])this.panoseArray.clone();
    }

    public byte getElement(int index) {
        return this.panoseArray[index];
    }

    public byte getElement(Field field) {
        byte index = field.getIndex();
        return this.getElement(index);
    }

    public long difference(Panose otherPanose, byte[] weights) {
        byte[] weightsToUse = null;
        if (weights == null) {
            weightsToUse = NEUTRAL_WEIGHTS;
        } else {
            Panose.validateWeights(weights);
            weightsToUse = weights;
        }
        long difference = 0L;
        for (int i = 0; i < Field.values().length; ++i) {
            byte weight = weightsToUse[i];
            int thisDifference = this.getElement(i) - otherPanose.getElement(i);
            difference += (long)(weight * thisDifference * thisDifference);
        }
        return difference;
    }

    private static void validateWeights(byte[] weights) {
        if (weights == null) {
            throw new NullPointerException("Weights may not be null");
        }
        if (weights.length != Field.values().length) {
            throw new IllegalArgumentException("Weights size expected: " + Field.values().length + ", actual: " + weights.length);
        }
        for (int i = 0; i < weights.length; ++i) {
            byte weight = weights[i];
            if (weight >= 0 && weight <= 127) continue;
            throw new IllegalArgumentException("Weight element " + i + " is outside the range of 0 thru 127.");
        }
    }

    public static String validPanose(byte[] panoseDescription) {
        if (panoseDescription == null) {
            return "Panose description cannot be null.";
        }
        if (panoseDescription.length != Field.values().length) {
            return "Illegal Panose description size: " + panoseDescription.length;
        }
        for (int i = 0; i < panoseDescription.length; ++i) {
            byte theByte = panoseDescription[i];
            Field panoseField = Field.values()[i];
            byte maxValue = panoseField.getMaxValue();
            if (theByte >= 0 && theByte <= maxValue) continue;
            return "Invalid value " + theByte + " > " + maxValue + " in position " + i + " of " + Panose.toString(panoseDescription);
        }
        return null;
    }

    public String toString() {
        return Panose.toString(this.panoseArray);
    }

    private static String toString(byte[] panoseArray) {
        StringBuilder sb = new StringBuilder(30);
        sb.append("[ ");
        for (int i = 0; i < panoseArray.length; ++i) {
            byte theByte = panoseArray[i];
            sb.append(theByte + " ");
        }
        sb.append("]");
        return sb.toString();
    }

    public Panose getBold() {
        byte weightValue = this.getElement(Field.WEIGHT);
        if (weightValue >= 7) {
            return this;
        }
        byte[] newArray = (byte[])this.panoseArray.clone();
        newArray[Field.WEIGHT.getIndex()] = 7;
        return Panose.forceInstance(newArray);
    }

    public Panose getItalic() {
        byte letterformValue = this.getElement(Field.LETTERFORM);
        if (letterformValue >= 9) {
            return this;
        }
        byte[] newArray = (byte[])this.panoseArray.clone();
        newArray[Field.LETTERFORM.getIndex()] = 9;
        return Panose.forceInstance(newArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Field {
        FAMILY_TYPE(0, 5),
        SERIF_STYLE(1, 15),
        WEIGHT(2, 11),
        PROPORTION(3, 9),
        CONTRAST(4, 9),
        STROKE_VARIATION(5, 8),
        ARM_STYLE(6, 11),
        LETTERFORM(7, 15),
        MIDLINE(8, 13),
        X_HEIGHT(9, 7);

        private byte index;
        private byte maxValue;

        private Field(byte index, byte maxValue) {
            this.index = index;
            this.maxValue = maxValue;
        }

        public byte getIndex() {
            return this.index;
        }

        public byte getMaxValue() {
            return this.maxValue;
        }
    }
}

