/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import java.util.HashMap;
import java.util.List;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.CustomXmlPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.opendope.StandardisedAnswersPart;
import org.docx4j.utils.SingleTraversalUtilVisitorCallback;
import org.docx4j.utils.TraversalUtilVisitor;
import org.docx4j.wml.Document;
import org.docx4j.wml.SdtElement;
import org.opendope.xpaths.Xpaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomXmlDataStoragePartSelector {
    protected static Logger log = LoggerFactory.getLogger(CustomXmlDataStoragePartSelector.class);

    public static CustomXmlDataStoragePart getCustomXmlDataStoragePart(WordprocessingMLPackage wordMLPackage) throws Docx4JException {
        MainDocumentPart documentPart = wordMLPackage.getMainDocumentPart();
        if (wordMLPackage.getMainDocumentPart().getXPathsPart() == null) {
            log.info("No XPaths part, so inspecting content controls to identify CustomXmlDataStoragePart");
            TraversalUtilCCVisitor visitor = new TraversalUtilCCVisitor();
            visitor.customXmlParts = wordMLPackage.getCustomXmlDataStorageParts();
            SingleTraversalUtilVisitorCallback ccFinder = new SingleTraversalUtilVisitorCallback(visitor);
            ccFinder.walkJAXBElements(((Document)wordMLPackage.getMainDocumentPart().getJaxbElement()).getBody());
            if (visitor.customXmlDataStoragePart == null) {
                log.error("FATAL. Couldn't find CustomXmlDataStoragePart  ");
                return null;
            }
            return visitor.customXmlDataStoragePart;
        }
        Xpaths xPaths = (Xpaths)wordMLPackage.getMainDocumentPart().getXPathsPart().getJaxbElement();
        if (xPaths.getXpath().isEmpty()) {
            log.info("No xpaths found, so can't determine CustomXmlDataStoragePart from them");
            return null;
        }
        for (Xpaths.Xpath xp : xPaths.getXpath()) {
            if (CustomXmlDataStoragePartSelector.shouldSkip(xp.getDataBinding().getPrefixMappings())) continue;
            String itemId = xp.getDataBinding().getStoreItemID().toLowerCase();
            log.debug("Attempting to use item id: " + itemId);
            if (wordMLPackage.getCustomXmlDataStorageParts().get(itemId) == null) {
                if (!log.isWarnEnabled()) continue;
                log.warn("Couldn't find CustomXmlDataStoragePart referenced from " + XmlUtils.marshaltoString(xp));
                continue;
            }
            if (wordMLPackage.getCustomXmlDataStorageParts().get(itemId) instanceof CustomXmlDataStoragePart) {
                log.debug("Using " + xp.getDataBinding().getStoreItemID());
                return (CustomXmlDataStoragePart)wordMLPackage.getCustomXmlDataStorageParts().get(itemId);
            }
            if (wordMLPackage.getCustomXmlDataStorageParts().get(itemId) instanceof StandardisedAnswersPart) {
                log.warn("TODO: support StandardisedAnswersPart");
                return null;
            }
            log.warn(wordMLPackage.getCustomXmlDataStorageParts().get(itemId).getClass().getName() + " --> can't cast");
        }
        log.error("Couldn't identify XML part from XPaths part entries");
        return null;
    }

    private static boolean shouldSkip(String prefixMappings) {
        if (prefixMappings == null) {
            return false;
        }
        if (prefixMappings.contains("http://schemas.microsoft.com/office/2006/coverPageProps")) {
            return true;
        }
        if (prefixMappings.contains("http://schemas.microsoft.com/office/2006/metadata/properties")) {
            return true;
        }
        return prefixMappings.contains("http://schemas.openxmlformats.org/package/2006/metadata/core-properties");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TraversalUtilCCVisitor
    extends TraversalUtilVisitor<SdtElement> {
        HashMap<String, CustomXmlPart> customXmlParts = null;
        CustomXmlDataStoragePart customXmlDataStoragePart = null;

        private TraversalUtilCCVisitor() {
        }

        @Override
        public void apply(SdtElement element, Object parent, List<Object> siblings) {
            if (this.customXmlDataStoragePart == null && element.getSdtPr() != null && element.getSdtPr().getDataBinding() != null && !CustomXmlDataStoragePartSelector.shouldSkip(element.getSdtPr().getDataBinding().getPrefixMappings())) {
                String itemId = element.getSdtPr().getDataBinding().getStoreItemID().toLowerCase();
                log.debug("Attempting to use item id: " + itemId);
                this.customXmlDataStoragePart = (CustomXmlDataStoragePart)this.customXmlParts.get(itemId);
                if (this.customXmlDataStoragePart == null) {
                    log.warn("Couldn't find CustomXmlDataStoragePart referenced from sdt bound with  " + itemId);
                } else {
                    log.debug("Using " + itemId);
                }
                if (this.customXmlParts.get(itemId) == null) {
                    if (log.isWarnEnabled()) {
                        log.warn("Couldn't find CustomXmlDataStoragePart referenced from " + XmlUtils.marshaltoString(element));
                    }
                } else if (this.customXmlParts.get(itemId) instanceof CustomXmlDataStoragePart) {
                    log.debug("Using " + element.getSdtPr().getDataBinding().getStoreItemID());
                    this.customXmlDataStoragePart = (CustomXmlDataStoragePart)this.customXmlParts.get(itemId);
                } else {
                    if (this.customXmlParts.get(itemId) instanceof StandardisedAnswersPart) {
                        log.warn("TODO: support StandardisedAnswersPart");
                        return;
                    }
                    log.warn(this.customXmlParts.get(itemId).getClass().getName() + " --> can't cast");
                }
            }
        }
    }
}

