/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage.xpathtracker;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Histgram {
    private static Logger log = LoggerFactory.getLogger(Histgram.class);
    private final Map<QName, Integer> occurrence = new HashMap<QName, Integer>();
    private String current;
    private int currentValue;

    public void update(String uri, String localName, String qName) {
        if (localName.contains(":")) {
            log.error("Unexpected localName " + localName);
            throw new IllegalArgumentException("Unexpected localName " + localName);
        }
        QName qn = new QName(uri, localName);
        Integer v = this.occurrence.get(qn);
        if (v == null) {
            v = 1;
        } else {
            Integer n = v;
            Integer n2 = v = Integer.valueOf(v + 1);
        }
        this.occurrence.put(qn, v);
        this.current = qName;
        this.currentValue = v;
    }

    public void appendPath(StringBuilder buf) {
        if (this.current == null) {
            return;
        }
        buf.append('/');
        buf.append(this.current);
        buf.append('[');
        buf.append(this.currentValue);
        buf.append(']');
    }
}

