/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.fields;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.JAXBResult;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.stream.StreamSource;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.model.fields.FieldRef;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.utils.ResourceUtils;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.FldChar;
import org.docx4j.wml.P;
import org.docx4j.wml.ProofErr;
import org.docx4j.wml.R;
import org.docx4j.wml.STFldCharType;
import org.docx4j.wml.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldsPreprocessor {
    private static Logger log = LoggerFactory.getLogger(FieldsPreprocessor.class);
    private static final QName _RInstrText_QNAME = new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "instrText");
    private static final QName _PHyperlink_QNAME = new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "hyperlink");
    static Templates xslt;
    private List<FieldRef> fieldRefs;
    private LinkedList<FieldRef> stack;
    private FieldRef currentField = null;
    private R newR;
    private static final QName _RT_QNAME;

    private FieldsPreprocessor(List<FieldRef> fieldRefs) {
        this.fieldRefs = fieldRefs;
    }

    public static void complexifyFields(JaxbXmlPart part) throws Docx4JException {
        Document doc = XmlUtils.marshaltoW3CDomDocument(part.getJaxbElement());
        JAXBContext jc = Context.jc;
        try {
            Unmarshaller u = jc.createUnmarshaller();
            u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
            JAXBResult result = new JAXBResult(u);
            XmlUtils.transform(doc, xslt, null, (Result)result);
            part.setJaxbElement(result);
        }
        catch (Exception e) {
            throw new Docx4JException("Problems transforming fields", e);
        }
    }

    public static P canonicalise(P p, List<FieldRef> fieldRefs) {
        FieldsPreprocessor fp = new FieldsPreprocessor(fieldRefs);
        return fp.canonicaliseInstance(p);
    }

    private P canonicaliseInstance(P p) {
        P newP = Context.getWmlObjectFactory().createP();
        newP.setPPr(p.getPPr());
        this.newR = Context.getWmlObjectFactory().createR();
        this.stack = new LinkedList();
        if (log.isDebugEnabled()) {
            log.debug(XmlUtils.marshaltoString(p));
        }
        this.handleContent(p.getContent(), newP);
        return newP;
    }

    private void handleContent(List<Object> objects, ContentAccessor attachmentPoint) {
        for (Object o : objects) {
            if (o instanceof R) {
                R existingRun = (R)o;
                this.handleRun(existingRun, attachmentPoint);
                continue;
            }
            if (o instanceof ProofErr) continue;
            log.debug("Retaining" + XmlUtils.unwrap(o).getClass().getName());
            attachmentPoint.getContent().add(o);
            this.newR = Context.getWmlObjectFactory().createR();
        }
    }

    private boolean fieldIsTopLevel() {
        return this.stack.size() == 1;
    }

    private boolean inParentResult() {
        FieldRef thisField = this.stack.pop();
        try {
            FieldRef parentField = this.stack.pop();
            boolean inResult = parentField.haveSeenSeparate();
            this.stack.push(parentField);
            this.stack.push(thisField);
            return inResult;
        }
        catch (NoSuchElementException e) {
            this.stack.push(thisField);
            return false;
        }
    }

    private boolean preserveResult(FieldRef fieldRef) {
        if (fieldRef.isLock()) {
            return true;
        }
        String fldName = fieldRef.getFldName();
        if (fldName == null) {
            return true;
        }
        return !fldName.equals("MERGEFIELD") && !fldName.equals("DOCPROPERTY");
    }

    private boolean preserveParentResult() {
        FieldRef thisField = this.stack.pop();
        FieldRef parentField = this.stack.pop();
        boolean preserveParentResult = this.preserveResult(parentField);
        this.stack.push(parentField);
        this.stack.push(thisField);
        return preserveParentResult;
    }

    private void handleRun(R existingRun, ContentAccessor newAttachPoint) {
        if (log.isDebugEnabled()) {
            log.debug("\nInput run: \n " + XmlUtils.marshaltoString((Object)existingRun, true, true));
        }
        for (Object o2 : existingRun.getContent()) {
            this.newR.setRPr(existingRun.getRPr());
            if (FieldsPreprocessor.isCharType(o2, STFldCharType.BEGIN)) {
                log.debug("\n\n begin.. ");
                this.currentField = new FieldRef((FldChar)XmlUtils.unwrap(o2));
                this.currentField.setParent(newAttachPoint);
                this.currentField.setBeginRun(this.newR);
                this.stack.push(this.currentField);
                if (this.inParentResult()) {
                    if (this.preserveParentResult()) {
                        this.newR.getContent().add(o2);
                    } else {
                        log.debug(".. but in result, so don't add to run");
                    }
                } else if (this.fieldIsTopLevel()) {
                    this.newR = Context.getWmlObjectFactory().createR();
                    this.newR.getContent().add(o2);
                    this.currentField.setBeginRun(this.newR);
                    this.fieldRefs.add(this.currentField);
                } else {
                    this.newR.getContent().add(o2);
                    this.stack.peek().getInstructions().add(this.currentField);
                }
            } else if (FieldsPreprocessor.isCharType(o2, STFldCharType.SEPARATE)) {
                this.currentField.setSeenSeparate(true);
                if (this.inParentResult()) {
                    if (this.preserveParentResult()) {
                        this.newR.getContent().add(o2);
                    } else {
                        log.debug(".. but in result, so don't add to run");
                    }
                } else {
                    this.newR.getContent().add(o2);
                    if (!newAttachPoint.getContent().contains(this.newR)) {
                        newAttachPoint.getContent().add(this.newR);
                        if (log.isDebugEnabled()) {
                            log.debug("-- attaching -->" + XmlUtils.marshaltoString((Object)this.newR, true, true));
                        }
                    }
                    if (this.fieldIsTopLevel()) {
                        this.newR = Context.getWmlObjectFactory().createR();
                        this.currentField.setResultsSlot(this.newR);
                    }
                }
            } else if (FieldsPreprocessor.isCharType(o2, STFldCharType.END)) {
                log.debug("\n\n .. end ");
                if (this.inParentResult()) {
                    if (this.preserveParentResult()) {
                        this.newR.getContent().add(o2);
                        if (this.currentField.getFldName().equals("FORMTEXT")) {
                            if (!newAttachPoint.getContent().contains(this.newR)) {
                                newAttachPoint.getContent().add(this.newR);
                                if (log.isDebugEnabled()) {
                                    log.debug("-- attaching -->" + XmlUtils.marshaltoString((Object)this.newR, true, true));
                                }
                            }
                            this.newR = Context.getWmlObjectFactory().createR();
                        }
                    } else {
                        log.debug(".. but in result, so don't add to run");
                    }
                } else if (this.fieldIsTopLevel()) {
                    if (!this.currentField.haveSeenSeparate()) {
                        log.debug(".. ADDING SEP ..  ");
                        FldChar fldChar = Context.getWmlObjectFactory().createFldChar();
                        fldChar.setFldCharType(STFldCharType.SEPARATE);
                        this.newR.getContent().add(fldChar);
                        if (!newAttachPoint.getContent().contains(this.newR)) {
                            newAttachPoint.getContent().add(this.newR);
                            if (log.isDebugEnabled()) {
                                log.debug("-- attaching -->" + XmlUtils.marshaltoString((Object)this.newR, true, true));
                            }
                        }
                    }
                    this.newR = this.currentField.getResultsSlot();
                    if (this.newR == null) {
                        this.newR = Context.getWmlObjectFactory().createR();
                        this.currentField.setResultsSlot(this.newR);
                    }
                    if (!newAttachPoint.getContent().contains(this.newR)) {
                        newAttachPoint.getContent().add(this.newR);
                        if (log.isDebugEnabled()) {
                            log.debug("-- attaching -->" + XmlUtils.marshaltoString((Object)this.newR, true, true));
                        }
                    }
                    this.newR = Context.getWmlObjectFactory().createR();
                    newAttachPoint.getContent().add(this.newR);
                    this.newR.getContent().add(o2);
                    this.currentField.setEndRun(this.newR);
                    this.newR = Context.getWmlObjectFactory().createR();
                } else {
                    this.newR.getContent().add(o2);
                }
                this.stack.pop();
                this.currentField = this.stack.peek();
            } else if (this.currentField == null) {
                this.newR.getContent().add(o2);
                if (!newAttachPoint.getContent().contains(this.newR)) {
                    newAttachPoint.getContent().add(this.newR);
                    if (log.isDebugEnabled()) {
                        log.debug("-- attaching -->" + XmlUtils.marshaltoString((Object)this.newR, true, true));
                    }
                }
                this.newR = Context.getWmlObjectFactory().createR();
            } else if (!this.currentField.haveSeenSeparate()) {
                Object o = XmlUtils.unwrap(o2);
                if (o instanceof Text && ((Text)o).getValue().trim().isEmpty()) {
                    log.debug("Empty w:instrText found. Ignore it!");
                    continue;
                }
                this.currentField.getInstructions().add(o2);
                if (this.inParentResult()) {
                    if (this.preserveParentResult()) {
                        this.newR.getContent().add(o2);
                    } else {
                        log.debug(".. but in result, so don't add to run");
                    }
                } else {
                    this.newR.getContent().add(o2);
                }
            } else if (this.preserveResult(this.currentField)) {
                log.debug("preserveResult-> adding");
                this.newR.getContent().add(o2);
                if (this.currentField.getResultsSlot() == null) {
                    this.currentField.setResultsSlot(this.newR);
                } else if (this.currentField.getResultsSlot() != this.newR) {
                    log.warn("Multiple runs in results slot?");
                }
            } else {
                if (o2 instanceof R && this.currentField.isMergeFormat().booleanValue() && this.currentField.getResultsSlot() == null) {
                    R resultR = Context.getWmlObjectFactory().createR();
                    this.currentField.setResultsSlot(resultR);
                    resultR.setRPr(((R)o2).getRPr());
                    log.debug("MERGEFORMAT Set rPr");
                }
                if (log.isDebugEnabled()) {
                    log.debug("IGNORING " + XmlUtils.marshaltoString(o2, true, true));
                }
            }
            if (this.newR.getContent().size() <= 0 || newAttachPoint.getContent().contains(this.newR)) continue;
            newAttachPoint.getContent().add(this.newR);
        }
    }

    public static boolean isCharType(Object o2, STFldCharType charType) {
        if ((o2 = XmlUtils.unwrap(o2)) instanceof FldChar) {
            FldChar fldChar = (FldChar)o2;
            if (fldChar.getFldCharType().equals((Object)charType)) {
                return true;
            }
            log.debug(fldChar.getFldCharType().toString());
        }
        return false;
    }

    static {
        try {
            StreamSource xsltSource = new StreamSource(ResourceUtils.getResource("org/docx4j/model/fields/FieldsSimpleToComplex.xslt"));
            xslt = XmlUtils.getTransformerTemplate(xsltSource);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        _RT_QNAME = new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "t");
    }
}

