/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.docx4j.openpackaging.exceptions.LocationAwareXMLStreamException;
import org.docx4j.openpackaging.parts.StAXHandlerInterface;

public abstract class StAXHandlerAbstract
implements StAXHandlerInterface {
    public abstract void handleCharacters(XMLStreamReader var1, XMLStreamWriter var2) throws XMLStreamException;

    public void handle(XMLStreamReader xmlr, XMLStreamWriter xmlWriter) throws LocationAwareXMLStreamException, XMLStreamException {
        while (xmlr.hasNext()) {
            try {
                this.write(xmlr, xmlWriter);
            }
            catch (XMLStreamException xse) {
                throw new LocationAwareXMLStreamException(xse.getMessage(), xse, xmlr.getLocation());
            }
            xmlr.next();
        }
    }

    public void write(XMLStreamReader xmlr, XMLStreamWriter writer) throws XMLStreamException {
        switch (xmlr.getEventType()) {
            case 1: {
                String localName = xmlr.getLocalName();
                if (xmlr.getNamespaceURI() == null) {
                    writer.writeStartElement(localName);
                } else {
                    writer.writeStartElement(xmlr.getPrefix(), localName, xmlr.getNamespaceURI());
                }
                int namespaceCount = xmlr.getNamespaceCount();
                for (int i = namespaceCount - 1; i >= 0; --i) {
                    writer.writeNamespace(xmlr.getNamespacePrefix(i), xmlr.getNamespaceURI(i));
                }
                int attributeCount = xmlr.getAttributeCount();
                for (int i = 0; i < attributeCount; ++i) {
                    if (xmlr.getAttributeNamespace(i) == null) {
                        writer.writeAttribute(xmlr.getAttributeLocalName(i), xmlr.getAttributeValue(i));
                        continue;
                    }
                    writer.writeAttribute(xmlr.getAttributePrefix(i), xmlr.getAttributeNamespace(i), xmlr.getAttributeLocalName(i), xmlr.getAttributeValue(i));
                }
                break;
            }
            case 2: {
                writer.writeEndElement();
                break;
            }
            case 6: {
                break;
            }
            case 4: {
                this.handleCharacters(xmlr, writer);
                break;
            }
            case 3: {
                writer.writeProcessingInstruction(xmlr.getPITarget(), xmlr.getPIData());
                break;
            }
            case 12: {
                writer.writeCData(xmlr.getText());
                break;
            }
            case 5: {
                writer.writeComment(xmlr.getText());
                break;
            }
            case 9: {
                writer.writeEntityRef(xmlr.getLocalName());
                break;
            }
            case 7: {
                String encoding = "UTF-8";
                String version = xmlr.getVersion();
                if (encoding != null && version != null) {
                    writer.writeStartDocument(encoding, version);
                    break;
                }
                if (version == null) break;
                writer.writeStartDocument(xmlr.getVersion());
                break;
            }
            case 8: {
                writer.writeEndDocument();
            }
        }
    }
}

