/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.io.IOUtils;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.io3.stores.PartStore;
import org.docx4j.openpackaging.parts.ExternalTarget;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.utils.BufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryPart
extends Part {
    protected static Logger log = LoggerFactory.getLogger(BinaryPart.class);
    ExternalTarget externalTarget = null;
    private ByteBuffer bb;

    public BinaryPart(PartName partName) throws InvalidFormatException {
        super(partName);
    }

    public BinaryPart(ExternalTarget externalTarget) {
        this.externalTarget = externalTarget;
    }

    public ExternalTarget getExternalTarget() {
        return this.externalTarget;
    }

    public void setBinaryData(InputStream binaryData) {
        log.debug("reading input stream");
        try {
            this.bb = BufferUtil.readInputStream(binaryData);
            log.debug(".. done");
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                log.debug("closing binary input stream");
                binaryData.close();
                log.info(".. closed.");
            }
            catch (Exception nested) {
                log.error(nested.getMessage(), (Throwable)nested);
            }
        }
    }

    public void setBinaryData(byte[] bytes) {
        this.bb = ByteBuffer.wrap(bytes);
    }

    public void setBinaryData(ByteBuffer bb) {
        this.bb = bb;
    }

    public boolean isLoaded() {
        return this.bb != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ByteBuffer getBuffer() {
        block13: {
            if (this.bb != null) {
                this.bb.rewind();
                return this.bb;
            }
            if (this.getPackage() == null) {
                log.warn("No package owns this part, and/or you didn't set its contents.");
                return null;
            }
            PartStore partStore = this.getPackage().getSourcePartStore();
            if (partStore == null) {
                log.warn("No PartStore configured for this package");
                return null;
            }
            InputStream is = null;
            try {
                String name = this.getPartName().getName();
                try {
                    this.setContentLengthAsLoaded(partStore.getPartSize(name.substring(1)));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                is = partStore.loadPart(name.substring(1));
                if (is != null) {
                    this.bb = BufferUtil.readInputStream(is);
                    this.bb.rewind();
                    ByteBuffer byteBuffer = this.bb;
                    IOUtils.closeQuietly((InputStream)is);
                    return byteBuffer;
                }
                log.warn(name + " missing from part store");
                IOUtils.closeQuietly((InputStream)is);
            }
            catch (Docx4JException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (IOException e2) {
                log.error(e2.getMessage(), (Throwable)e2);
                break block13;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(is);
            }
        }
        return null;
    }

    public void writeDataToOutputStream(OutputStream out) throws IOException {
        ByteBuffer buf = this.getBuffer();
        buf.rewind();
        WritableByteChannel channel = Channels.newChannel(out);
        channel.write(buf);
        buf.rewind();
    }

    public byte[] getBytes() {
        ByteBuffer bb = this.getBuffer();
        bb.rewind();
        byte[] bytes = new byte[bb.limit()];
        bb.get(bytes, 0, bytes.length);
        bb.rewind();
        return bytes;
    }

    public boolean isContentEqual(Part other) throws Docx4JException {
        if (!(other instanceof BinaryPart)) {
            return false;
        }
        ByteBuffer thisBB = this.getBuffer();
        ByteBuffer thatBB = ((BinaryPart)other).getBuffer();
        return thisBB.equals(thatBB);
    }
}

