/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.relationships;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.jaxb.NamespacePrefixMapperUtils;
import org.docx4j.openpackaging.Base;
import org.docx4j.openpackaging.URIHelper;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.contenttype.ContentTypeManager;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.exceptions.InvalidOperationException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.parts.ExternalTarget;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.relationships.ObjectFactory;
import org.docx4j.relationships.Relationship;
import org.docx4j.relationships.Relationships;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RelationshipsPart
extends JaxbXmlPart<Relationships> {
    private static Logger log = LoggerFactory.getLogger(RelationshipsPart.class);
    private Base sourceP;
    private int nextId = 1;

    public RelationshipsPart(Base sourceP) throws InvalidFormatException {
        super(new PartName(PartName.getRelationshipsPartName(sourceP.getPartName().getName())));
        this.sourceP = sourceP;
        this.init();
        sourceP.setRelationships(this);
        ObjectFactory factory = new ObjectFactory();
        this.jaxbElement = factory.createRelationships();
    }

    public RelationshipsPart() throws InvalidFormatException {
        super(new PartName("/blagh"));
        this.init();
    }

    public static RelationshipsPart createPackageRels() throws InvalidFormatException {
        RelationshipsPart rp = new RelationshipsPart(new PartName("/_rels/.rels"));
        return rp;
    }

    private RelationshipsPart(PartName partname) throws InvalidFormatException {
        super(partname);
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-package.relationships+xml"));
        this.setJAXBContext(Context.jcRelationships);
    }

    @Override
    public PartName getPartName() {
        if (this.getSourceP() != null && !(this.getSourceP() instanceof OpcPackage)) {
            try {
                return new PartName(PartName.getRelationshipsPartName(this.sourceP.getPartName().getName()));
            }
            catch (InvalidFormatException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return super.getPartName();
    }

    public static RelationshipsPart createRelationshipsPartForPart(Base sourcePart) {
        if (sourcePart.relationships != null) {
            return sourcePart.relationships;
        }
        RelationshipsPart rp = null;
        try {
            rp = new RelationshipsPart(sourcePart);
        }
        catch (InvalidFormatException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        rp.setPackage(sourcePart.getPackage());
        sourcePart.getPackage().getContentTypeManager().addDefaultContentType("rels", "application/vnd.openxmlformats-package.relationships+xml");
        return rp;
    }

    public Relationships getRelationships() {
        return (Relationships)this.jaxbElement;
    }

    public void setRelationships(Relationships jaxbElement) {
        this.jaxbElement = jaxbElement;
    }

    public Base getSourceP() {
        return this.sourceP;
    }

    public void setSourceP(Base sourcePart) {
        this.sourceP = sourcePart;
    }

    public URI getSourceURI() {
        if (this.sourceP == null) {
            return URIHelper.PACKAGE_ROOT_URI;
        }
        return this.sourceP.getPartName().getURI();
    }

    public boolean isPackageRelationshipPart() {
        return this.sourceP instanceof OpcPackage;
    }

    public Part getPart(String id) {
        log.debug("looking for: " + id);
        Relationship r = this.getRelationshipByID(id);
        log.debug(id + " points to " + r.getTarget());
        return this.getPart(r);
    }

    public Relationship getRelationshipByID(String id) {
        for (Relationship r : ((Relationships)this.jaxbElement).getRelationship()) {
            if (!r.getId().equals(id)) continue;
            return r;
        }
        return null;
    }

    public Relationship getRelationshipByType(String type) {
        for (Relationship r : ((Relationships)this.jaxbElement).getRelationship()) {
            if (!r.getType().equals(type)) continue;
            return r;
        }
        return null;
    }

    public List<Relationship> getRelationshipsByType(String type) {
        ArrayList<Relationship> rels = new ArrayList<Relationship>();
        for (Relationship r : ((Relationships)this.jaxbElement).getRelationship()) {
            if (!r.getType().equals(type)) continue;
            rels.add(r);
        }
        return rels;
    }

    public Part getPart(Relationship r) {
        if (r.getTargetMode() == null || !r.getTargetMode().equals("External")) {
            URI uri = null;
            try {
                uri = URIHelper.resolvePartUri(this.sourceP.getPartName().getURI(), new URI(r.getTarget()));
            }
            catch (URISyntaxException e) {
                log.error("Cannot convert " + r.getTarget() + " in a valid relationship URI-> ignored", (Throwable)e);
            }
            try {
                return this.getPackage().getParts().get(new PartName(uri, true));
            }
            catch (InvalidFormatException e) {
                log.error("Couldn't get part using PartName: " + uri, (Throwable)e);
                return null;
            }
        }
        return this.getPackage().getExternalResources().get(new ExternalTarget(r.getTarget()));
    }

    public String getNextId() {
        String id = "rId" + this.nextId;
        do {
            id = "rId" + this.nextId;
            ++this.nextId;
        } while (this.isRelIdOccupied(id));
        return id;
    }

    public boolean isRelIdOccupied(String relId) {
        for (Relationship existing : ((Relationships)this.jaxbElement).getRelationship()) {
            if (!existing.getId().equals(relId)) continue;
            log.debug(relId + " already in use, with target " + existing.getTarget());
            return true;
        }
        return false;
    }

    public void resetIdAllocator() {
        int highestId = 0;
        for (Relationship rel : ((Relationships)this.jaxbElement).getRelationship()) {
            String id = rel.getId();
            try {
                String idNum = id.substring(3);
                int current = Integer.parseInt(idNum);
                if (current <= highestId) continue;
                highestId = current;
            }
            catch (Exception e) {
                log.warn("Couldn't process id: " + id);
            }
        }
        this.nextId = highestId + 1;
        log.debug("nextId reset to : " + this.nextId);
    }

    public void loadPart(Part part, Relationship sourceRelationship) {
        if (part == null) {
            log.error("Failed trying to load null part.");
            throw new IllegalArgumentException("part");
        }
        PartName partName = part.getPartName();
        log.debug("Loading part " + partName.getName());
        part.setOwningRelationshipPart(this);
        part.getSourceRelationships().add(sourceRelationship);
        this.getPackage().getParts().put(part);
        part.setPackage(this.getPackage());
    }

    public Relationship addPart(Part part, AddPartBehaviour mode, ContentTypeManager ctm) throws InvalidFormatException {
        return this.addPart(part, mode, ctm, null);
    }

    public Relationship addPart(Part part, AddPartBehaviour mode, ContentTypeManager ctm, String relId) throws InvalidFormatException {
        Relationship rel2;
        PartName newPartName = part.getPartName();
        log.info("adding part with proposed name: " + newPartName.getName());
        if (this.getPackage().getParts().get(newPartName) != null) {
            if (mode.equals((Object)AddPartBehaviour.REUSE_EXISTING)) {
                part = this.getPackage().getParts().get(newPartName);
                if (log.isDebugEnabled()) {
                    boolean exists = part != null;
                    log.debug("part exists: " + exists);
                }
            }
            if (mode.equals((Object)AddPartBehaviour.RENAME_IF_NAME_EXISTS)) {
                String proposedName = part.getPartName().getName();
                log.debug("Detected duplicate partname: " + proposedName);
                newPartName = proposedName.indexOf(".") > 0 ? this.getNewPartName(proposedName.substring(0, proposedName.indexOf(".")), "." + part.getPartName().getExtension(), this.getPackage().getParts().getParts()) : this.getNewPartName(proposedName, ".", this.getPackage().getParts().getParts());
                part.setPartName(newPartName);
                log.debug(".. renamed to " + newPartName);
            }
        }
        URI tobeRelativized = part.getPartName().getURI();
        URI relativizeAgainst = this.sourceP.getPartName().getURI();
        log.debug("Relativising target " + tobeRelativized + " against source " + relativizeAgainst);
        String target = URIHelper.relativizeURI(relativizeAgainst, tobeRelativized).toString();
        if (relativizeAgainst.getPath().equals("/") && target.startsWith("/")) {
            target = target.substring(1);
        }
        log.debug("Result " + target);
        Relationship existsAlready = null;
        for (Relationship rel2 : ((Relationships)this.jaxbElement).getRelationship()) {
            if (!rel2.getTarget().equals(target)) continue;
            existsAlready = rel2;
            break;
        }
        if (log.isDebugEnabled()) {
            boolean exists = existsAlready != null;
            log.debug("rel exists: " + exists);
        }
        if (existsAlready != null && mode.equals((Object)AddPartBehaviour.REUSE_EXISTING)) {
            log.debug("Returning preexisting rel");
            return existsAlready;
        }
        if (existsAlready != null && mode.equals((Object)AddPartBehaviour.RENAME_IF_NAME_EXISTS)) {
            throw new InvalidFormatException("Found existing rel, and yet constructed part name should be globally unique!");
        }
        if (this.getPackage().getParts().get(newPartName) != null && mode.equals((Object)AddPartBehaviour.OVERWRITE_IF_NAME_EXISTS) && existsAlready != null) {
            existsAlready.setType(part.getRelationshipType());
            this.loadPart(part, existsAlready);
            return existsAlready;
        }
        ObjectFactory factory = new ObjectFactory();
        rel2 = factory.createRelationship();
        rel2.setTarget(target);
        rel2.setType(part.getRelationshipType());
        if (relId != null) {
            rel2.setId(relId);
        }
        this.addRelationship(rel2);
        String ext = part.getPartName().getExtension();
        if (part.getContentType().equals("image/jpeg")) {
            ctm.addDefaultContentType(ext, "image/jpeg");
        } else if (part.getContentType().equals("gif")) {
            ctm.addDefaultContentType(ext, "gif");
        } else if (part.getContentType().equals("png")) {
            ctm.addDefaultContentType(ext, "image/png");
        } else {
            ctm.addOverrideContentType(part.getPartName().getURI(), part.getContentType());
        }
        if (this.getPackage().getParts().get(newPartName) != null) {
            if (mode.equals((Object)AddPartBehaviour.REUSE_EXISTING)) {
                // empty if block
            }
            if (mode.equals((Object)AddPartBehaviour.RENAME_IF_NAME_EXISTS)) {
                this.loadPart(part, rel2);
            }
            if (mode.equals((Object)AddPartBehaviour.OVERWRITE_IF_NAME_EXISTS)) {
                this.loadPart(part, rel2);
            }
            return rel2;
        }
        this.loadPart(part, rel2);
        return rel2;
    }

    public boolean addRelationship(Relationship rel) throws InvalidOperationException {
        String relId;
        if (rel.getId() == null) {
            String id = this.getNextId();
            rel.setId(id);
        }
        if (this.isRelIdOccupied(relId = rel.getId())) {
            log.error("Refusing to add another rel with id " + relId + ". Target is " + rel.getTarget());
            throw new InvalidOperationException("Refusing to add another rel with id " + relId + ". Target is " + rel.getTarget());
        }
        ((Relationships)this.jaxbElement).getRelationship().add(rel);
        rel.setParent(this.jaxbElement);
        return true;
    }

    public List<PartName> removeParts() {
        ArrayList<PartName> removedParts = new ArrayList<PartName>();
        ArrayList<Relationship> relationshipsToGo = new ArrayList<Relationship>();
        for (Relationship r : ((Relationships)this.jaxbElement).getRelationship()) {
            relationshipsToGo.add(r);
        }
        for (Relationship r : relationshipsToGo) {
            try {
                String resolvedPartUri = URIHelper.resolvePartUri(this.getSourceURI(), new URI(r.getTarget())).toString();
                log.info("Removing part: " + resolvedPartUri);
                removedParts.addAll(this.removePart(new PartName(resolvedPartUri)));
            }
            catch (URISyntaxException e) {
                log.error("Cannot convert " + r.getTarget() + " in a valid relationship URI-> ignored", (Throwable)e);
            }
            catch (InvalidFormatException e) {
                e.printStackTrace();
            }
        }
        return removedParts;
    }

    public List<PartName> removePart(PartName partName) {
        log.info("trying to removePart " + partName.getName());
        ArrayList<PartName> removedParts = new ArrayList<PartName>();
        if (partName == null) {
            throw new IllegalArgumentException("partName was null");
        }
        Part part = this.getPackage().getParts().get(partName);
        if (part != null) {
            this.removeRelationship(partName);
            if (part.getRelationshipsPart() != null) {
                removedParts.addAll(part.getRelationshipsPart().removeParts());
            }
            this.getPackage().getParts().remove(partName);
            removedParts.add(partName);
        }
        return removedParts;
    }

    @Deprecated
    public boolean isATarget(PartName partName) {
        return this.getRel(partName) != null;
    }

    public Relationship getRel(PartName partName) {
        for (Relationship rel : ((Relationships)this.jaxbElement).getRelationship()) {
            if (rel.getTargetMode() != null && rel.getTargetMode().equals("External") || !this.isTarget(partName, rel)) continue;
            return rel;
        }
        return null;
    }

    public boolean isTarget(PartName partName, Relationship rel) {
        URI resolvedTargetURI = null;
        try {
            resolvedTargetURI = this.sourceP == null ? URIHelper.resolvePartUri(new URI(RelationshipsPart.inferSourcePartName(this.getPartName().getName())), new URI(rel.getTarget())) : URIHelper.resolvePartUri(this.sourceP.getPartName().getURI(), new URI(rel.getTarget()));
        }
        catch (URISyntaxException e) {
            log.error("Cannot convert " + rel.getTarget() + " in a valid relationship URI-> ignored", (Throwable)e);
        }
        return partName.getName().equals(resolvedTargetURI.toString());
    }

    public void removeRelationship(Relationship rel) {
        if (rel == null) {
            throw new IllegalArgumentException("rel");
        }
        if (!((Relationships)this.jaxbElement).getRelationship().remove(rel)) {
            log.warn("Couldn't find rel " + rel.getId() + " " + rel.getTarget());
        }
    }

    public void removeRelationship(PartName partName) {
        Relationship relToBeRemoved = null;
        for (Relationship rel : ((Relationships)this.jaxbElement).getRelationship()) {
            if (rel.getTargetMode() != null && rel.getTargetMode().equals("External") || !this.isTarget(partName, rel)) continue;
            log.info("True - will delete relationship with id " + rel.getId() + " and target " + rel.getTarget());
            relToBeRemoved = rel;
            break;
        }
        if (relToBeRemoved == null) {
            throw new IllegalArgumentException(partName + " is not a target of " + this.getPartName());
        }
        this.removeRelationship(relToBeRemoved);
    }

    public void removeRelationshipsByType(String type) {
        ArrayList<Relationship> relsToClear = new ArrayList<Relationship>();
        for (Relationship r : this.getRelationships().getRelationship()) {
            if (!r.getType().equals(type)) continue;
            relsToClear.add(r);
        }
        for (Relationship r : relsToClear) {
            this.getRelationships().getRelationship().remove(r);
        }
    }

    public int size() {
        return ((Relationships)this.jaxbElement).getRelationship().size();
    }

    @Override
    public Relationships unmarshal(InputStream is) throws JAXBException {
        try {
            XMLInputFactory xif = XMLInputFactory.newInstance();
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            xif.setProperty("javax.xml.stream.supportDTD", false);
            XMLStreamReader xsr = xif.createXMLStreamReader(is);
            Unmarshaller u = this.jc.createUnmarshaller();
            u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
            log.debug("unmarshalling " + this.getClass().getName());
            this.jaxbElement = (Relationships)u.unmarshal(xsr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.resetIdAllocator();
        return (Relationships)this.jaxbElement;
    }

    @Override
    public Relationships unmarshal(Element el) throws JAXBException {
        try {
            Unmarshaller u = this.jc.createUnmarshaller();
            u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
            this.jaxbElement = (Relationships)u.unmarshal((Node)el);
        }
        catch (JAXBException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        this.resetIdAllocator();
        return (Relationships)this.jaxbElement;
    }

    @Override
    public void marshal(Node node) throws JAXBException {
        this.marshal(node, NamespacePrefixMapperUtils.getPrefixMapperRelationshipsPart());
    }

    @Override
    public void marshal(OutputStream os) throws JAXBException {
        this.marshal(os, NamespacePrefixMapperUtils.getPrefixMapperRelationshipsPart());
    }

    public List<Relationship> uniqueToThis(RelationshipsPart otherRP) {
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        for (Relationship r : ((Relationships)this.jaxbElement).getRelationship()) {
            if (RelationshipsPart.getRelationshipByTarget(otherRP, r.getTarget()) != null) continue;
            log.debug("Unique: " + r.getTarget());
            results.add(r);
        }
        return results;
    }

    public List<Relationship> uniqueToOther(RelationshipsPart otherRP) {
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        for (Relationship r : ((Relationships)otherRP.jaxbElement).getRelationship()) {
            if (RelationshipsPart.getRelationshipByTarget(this, r.getTarget()) != null) continue;
            results.add(r);
        }
        return results;
    }

    public List<Relationship> differingContent(RelationshipsPart otherRP) throws Docx4JException {
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        for (Relationship r : ((Relationships)this.jaxbElement).getRelationship()) {
            Part otherPart;
            Relationship otherR = RelationshipsPart.getRelationshipByTarget(otherRP, r.getTarget());
            if (otherR == null) continue;
            if (r.getTargetMode() != null && r.getTargetMode().equals("External")) {
                if (otherR.getTargetMode() != null && otherR.getTargetMode().equals("External")) {
                    if (r.getTarget().equals(otherR.getTarget())) continue;
                    throw new Docx4JException("broken logic!");
                }
                results.add(r);
                log.debug("External: " + r.getTarget());
                continue;
            }
            Part thisPart = this.getPart(r);
            if (thisPart.isContentEqual(otherPart = otherRP.getPart(otherR))) continue;
            results.add(r);
            log.debug("Different: " + r.getTarget());
        }
        return results;
    }

    public static Relationship getRelationshipByTarget(RelationshipsPart rp, String relativeTarget) {
        for (Relationship r : ((Relationships)rp.jaxbElement).getRelationship()) {
            if (!r.getTarget().equals(relativeTarget)) continue;
            return r;
        }
        return null;
    }

    public static String inferSourcePartName(String relationshipsPartName) {
        String result = relationshipsPartName;
        if (result.endsWith(".rels")) {
            result = result.substring(0, result.length() - 5);
        }
        if (result.contains("_rels")) {
            result = result.substring(0, result.indexOf("_rels")) + result.substring(result.indexOf("_rels") + 6);
        }
        return result;
    }

    private PartName getNewPartName(String prefix, String suffix, HashMap<PartName, Part> parts) throws InvalidFormatException {
        PartName proposed = null;
        int i = 1;
        do {
            proposed = i > 1 ? new PartName(prefix + i + suffix) : new PartName(prefix + suffix);
            ++i;
        } while (parts.get(proposed) != null);
        return proposed;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AddPartBehaviour {
        OVERWRITE_IF_NAME_EXISTS("overwrite"),
        REUSE_EXISTING("reuse"),
        RENAME_IF_NAME_EXISTS("rename");

        private final String value;

        private AddPartBehaviour(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }
    }
}

