/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.apache.poi.poifs.crypt.agile;

import org.docx4j.com.microsoft.schemas.office.x2006.encryption.CTDataIntegrity;
import org.docx4j.com.microsoft.schemas.office.x2006.encryption.CTEncryption;
import org.docx4j.com.microsoft.schemas.office.x2006.encryption.CTKeyData;
import org.docx4j.com.microsoft.schemas.office.x2006.encryption.STCipherChaining;
import org.docx4j.org.apache.poi.EncryptedDocumentException;
import org.docx4j.org.apache.poi.poifs.crypt.ChainingMode;
import org.docx4j.org.apache.poi.poifs.crypt.CipherAlgorithm;
import org.docx4j.org.apache.poi.poifs.crypt.EncryptionHeader;
import org.docx4j.org.apache.poi.poifs.crypt.HashAlgorithm;
import org.docx4j.org.apache.poi.poifs.crypt.agile.AgileEncryptionInfoBuilder;

public class AgileEncryptionHeader
extends EncryptionHeader {
    private byte[] encryptedHmacKey;
    private byte[] encryptedHmacValue;

    public AgileEncryptionHeader(String descriptor) {
        this(AgileEncryptionInfoBuilder.parseDescriptor(descriptor));
    }

    protected AgileEncryptionHeader(CTEncryption ed) {
        CTKeyData keyData;
        try {
            keyData = ed.getKeyData();
            if (keyData == null) {
                throw new NullPointerException("keyData not set");
            }
        }
        catch (Exception e) {
            throw new EncryptedDocumentException("Unable to parse keyData");
        }
        this.setKeySize((int)keyData.getKeyBits());
        this.setFlags(0);
        this.setSizeExtra(0);
        this.setCspName(null);
        this.setBlockSize((int)keyData.getBlockSize());
        int keyBits = (int)keyData.getKeyBits();
        CipherAlgorithm ca = CipherAlgorithm.fromXmlId(keyData.getCipherAlgorithm().toString(), keyBits);
        this.setCipherAlgorithm(ca);
        this.setCipherProvider(ca.provider);
        if (keyData.getCipherChaining() == STCipherChaining.CHAINING_MODE_CBC) {
            this.setChainingMode(ChainingMode.cbc);
        } else if (keyData.getCipherChaining() == STCipherChaining.CHAINING_MODE_CFB) {
            this.setChainingMode(ChainingMode.cfb);
        } else {
            throw new EncryptedDocumentException("Unsupported chaining mode - " + keyData.getCipherChaining().toString());
        }
        int hashSize = (int)keyData.getHashSize();
        HashAlgorithm ha = HashAlgorithm.fromEcmaId(keyData.getHashAlgorithm().value());
        this.setHashAlgorithm(ha);
        if (this.getHashAlgorithmEx().hashSize != hashSize) {
            throw new EncryptedDocumentException("Unsupported hash algorithm: " + keyData.getHashAlgorithm().value() + " @ " + hashSize + " bytes");
        }
        int saltLength = (int)keyData.getSaltSize();
        this.setKeySalt(keyData.getSaltValue());
        if (this.getKeySalt().length != saltLength) {
            throw new EncryptedDocumentException("Invalid salt length");
        }
        CTDataIntegrity di = ed.getDataIntegrity();
        this.setEncryptedHmacKey(di.getEncryptedHmacKey());
        this.setEncryptedHmacValue(di.getEncryptedHmacValue());
    }

    public AgileEncryptionHeader(CipherAlgorithm algorithm, HashAlgorithm hashAlgorithm, int keyBits, int blockSize, ChainingMode chainingMode) {
        this.setCipherAlgorithm(algorithm);
        this.setHashAlgorithm(hashAlgorithm);
        this.setKeySize(keyBits);
        this.setBlockSize(blockSize);
        this.setChainingMode(chainingMode);
    }

    protected void setKeySalt(byte[] salt) {
        if (salt == null || salt.length != this.getBlockSize()) {
            throw new EncryptedDocumentException("invalid verifier salt");
        }
        super.setKeySalt(salt);
    }

    public byte[] getEncryptedHmacKey() {
        return this.encryptedHmacKey;
    }

    protected void setEncryptedHmacKey(byte[] encryptedHmacKey) {
        this.encryptedHmacKey = encryptedHmacKey;
    }

    public byte[] getEncryptedHmacValue() {
        return this.encryptedHmacValue;
    }

    protected void setEncryptedHmacValue(byte[] encryptedHmacValue) {
        this.encryptedHmacValue = encryptedHmacValue;
    }
}

