/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.apache.poi.poifs.crypt.agile;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBException;
import org.docx4j.XmlUtils;
import org.docx4j.com.microsoft.schemas.office.x2006.encryption.CTEncryption;
import org.docx4j.jaxb.Context;
import org.docx4j.org.apache.poi.EncryptedDocumentException;
import org.docx4j.org.apache.poi.poifs.crypt.ChainingMode;
import org.docx4j.org.apache.poi.poifs.crypt.CipherAlgorithm;
import org.docx4j.org.apache.poi.poifs.crypt.EncryptionInfo;
import org.docx4j.org.apache.poi.poifs.crypt.EncryptionInfoBuilder;
import org.docx4j.org.apache.poi.poifs.crypt.EncryptionMode;
import org.docx4j.org.apache.poi.poifs.crypt.HashAlgorithm;
import org.docx4j.org.apache.poi.poifs.crypt.agile.AgileDecryptor;
import org.docx4j.org.apache.poi.poifs.crypt.agile.AgileEncryptionHeader;
import org.docx4j.org.apache.poi.poifs.crypt.agile.AgileEncryptionVerifier;
import org.docx4j.org.apache.poi.poifs.crypt.agile.AgileEncryptor;
import org.docx4j.org.apache.poi.util.LittleEndianInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgileEncryptionInfoBuilder
implements EncryptionInfoBuilder {
    private static Logger log = LoggerFactory.getLogger(AgileEncryptionInfoBuilder.class);
    EncryptionInfo info;
    AgileEncryptionHeader header;
    AgileEncryptionVerifier verifier;
    AgileDecryptor decryptor;
    AgileEncryptor encryptor;

    public void initialize(EncryptionInfo info, LittleEndianInput dis) throws IOException {
        this.info = info;
        CTEncryption ed = AgileEncryptionInfoBuilder.parseDescriptor((InputStream)((Object)dis));
        this.header = new AgileEncryptionHeader(ed);
        this.verifier = new AgileEncryptionVerifier(ed);
        if (info.getVersionMajor() == EncryptionMode.agile.versionMajor && info.getVersionMinor() == EncryptionMode.agile.versionMinor) {
            this.decryptor = new AgileDecryptor(this);
            this.encryptor = new AgileEncryptor(this);
        }
    }

    public void initialize(EncryptionInfo info, CipherAlgorithm cipherAlgorithm, HashAlgorithm hashAlgorithm, int keyBits, int blockSize, ChainingMode chainingMode) {
        this.info = info;
        if (cipherAlgorithm == null) {
            cipherAlgorithm = CipherAlgorithm.aes128;
        }
        if (cipherAlgorithm == CipherAlgorithm.rc4) {
            throw new EncryptedDocumentException("RC4 must not be used with agile encryption.");
        }
        if (hashAlgorithm == null) {
            hashAlgorithm = HashAlgorithm.sha1;
        }
        if (chainingMode == null) {
            chainingMode = ChainingMode.cbc;
        }
        if (chainingMode != ChainingMode.cbc && chainingMode != ChainingMode.cfb) {
            throw new EncryptedDocumentException("Agile encryption only supports CBC/CFB chaining.");
        }
        if (keyBits == -1) {
            keyBits = cipherAlgorithm.defaultKeySize;
        }
        if (blockSize == -1) {
            blockSize = cipherAlgorithm.blockSize;
        }
        boolean found = false;
        for (int ks : cipherAlgorithm.allowedKeySize) {
            found |= ks == keyBits;
        }
        if (!found) {
            throw new EncryptedDocumentException("KeySize " + keyBits + " not allowed for Cipher " + cipherAlgorithm.toString());
        }
        this.header = new AgileEncryptionHeader(cipherAlgorithm, hashAlgorithm, keyBits, blockSize, chainingMode);
        this.verifier = new AgileEncryptionVerifier(cipherAlgorithm, hashAlgorithm, keyBits, blockSize, chainingMode);
        this.decryptor = new AgileDecryptor(this);
        this.encryptor = new AgileEncryptor(this);
    }

    public AgileEncryptionHeader getHeader() {
        return this.header;
    }

    public AgileEncryptionVerifier getVerifier() {
        return this.verifier;
    }

    public AgileDecryptor getDecryptor() {
        return this.decryptor;
    }

    public AgileEncryptor getEncryptor() {
        return this.encryptor;
    }

    protected EncryptionInfo getInfo() {
        return this.info;
    }

    protected static CTEncryption parseDescriptor(String descriptor) {
        log.error(descriptor);
        CTEncryption encryption = null;
        try {
            encryption = (CTEncryption)XmlUtils.unmarshalString(descriptor, Context.jcEncryption, CTEncryption.class);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return encryption;
    }

    protected static CTEncryption parseDescriptor(InputStream descriptor) {
        CTEncryption encryption = null;
        try {
            encryption = (CTEncryption)XmlUtils.unwrap(XmlUtils.unmarshal(descriptor, Context.jcEncryption));
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return encryption;
    }
}

