/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.apache.poi.poifs.crypt.cryptoapi;

import java.io.IOException;
import org.docx4j.org.apache.poi.EncryptedDocumentException;
import org.docx4j.org.apache.poi.poifs.crypt.ChainingMode;
import org.docx4j.org.apache.poi.poifs.crypt.CipherAlgorithm;
import org.docx4j.org.apache.poi.poifs.crypt.CipherProvider;
import org.docx4j.org.apache.poi.poifs.crypt.HashAlgorithm;
import org.docx4j.org.apache.poi.poifs.crypt.standard.StandardEncryptionHeader;
import org.docx4j.org.apache.poi.util.LittleEndianInput;

public class CryptoAPIEncryptionHeader
extends StandardEncryptionHeader {
    public CryptoAPIEncryptionHeader(LittleEndianInput is) throws IOException {
        super(is);
    }

    protected CryptoAPIEncryptionHeader(CipherAlgorithm cipherAlgorithm, HashAlgorithm hashAlgorithm, int keyBits, int blockSize, ChainingMode chainingMode) {
        super(cipherAlgorithm, hashAlgorithm, keyBits, blockSize, chainingMode);
    }

    public void setKeySize(int keyBits) {
        boolean found = false;
        for (int size : this.getCipherAlgorithm().allowedKeySize) {
            if (size != keyBits) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new EncryptedDocumentException("invalid keysize " + keyBits + " for cipher algorithm " + (Object)((Object)this.getCipherAlgorithm()));
        }
        super.setKeySize(keyBits);
        if (keyBits > 40) {
            this.setCspName("Microsoft Enhanced Cryptographic Provider v1.0");
        } else {
            this.setCspName(CipherProvider.rc4.cipherProviderName);
        }
    }
}

