/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.apache.poi.poifs.nio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.docx4j.org.apache.poi.poifs.nio.DataSource;
import org.docx4j.org.apache.poi.util.IOUtils;

public class FileBackedDataSource
extends DataSource {
    private FileChannel channel;
    private boolean writable;
    private RandomAccessFile srcFile;

    public FileBackedDataSource(File file) throws FileNotFoundException {
        this(FileBackedDataSource.newSrcFile(file, "r"), true);
    }

    public FileBackedDataSource(File file, boolean readOnly) throws FileNotFoundException {
        this(FileBackedDataSource.newSrcFile(file, readOnly ? "r" : "rw"), readOnly);
    }

    public FileBackedDataSource(RandomAccessFile srcFile, boolean readOnly) {
        this(srcFile.getChannel(), readOnly);
        this.srcFile = srcFile;
    }

    public FileBackedDataSource(FileChannel channel, boolean readOnly) {
        this.channel = channel;
        this.writable = !readOnly;
    }

    public boolean isWriteable() {
        return this.writable;
    }

    public FileChannel getChannel() {
        return this.channel;
    }

    public ByteBuffer read(int length, long position) throws IOException {
        ByteBuffer dst;
        if (position >= this.size()) {
            throw new IllegalArgumentException("Position " + position + " past the end of the file");
        }
        int worked = -1;
        if (this.writable) {
            dst = this.channel.map(FileChannel.MapMode.READ_WRITE, position, length);
            worked = 0;
        } else {
            this.channel.position(position);
            dst = ByteBuffer.allocate(length);
            worked = IOUtils.readFully(this.channel, dst);
        }
        if (worked == -1) {
            throw new IllegalArgumentException("Position " + position + " past the end of the file");
        }
        dst.position(0);
        return dst;
    }

    public void write(ByteBuffer src, long position) throws IOException {
        this.channel.write(src, position);
    }

    public void copyTo(OutputStream stream) throws IOException {
        WritableByteChannel out = Channels.newChannel(stream);
        this.channel.transferTo(0L, this.channel.size(), out);
    }

    public long size() throws IOException {
        return this.channel.size();
    }

    public void close() throws IOException {
        if (this.srcFile != null) {
            this.srcFile.close();
        } else {
            this.channel.close();
        }
    }

    private static RandomAccessFile newSrcFile(File file, String mode) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        return new RandomAccessFile(file, mode);
    }
}

