/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.apache.poi.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.docx4j.org.apache.poi.util.LittleEndianOutput;

public final class LittleEndianOutputStream
extends FilterOutputStream
implements LittleEndianOutput {
    public LittleEndianOutputStream(OutputStream out) {
        super(out);
    }

    public void writeByte(int v) {
        try {
            this.out.write(v);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeDouble(double v) {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeInt(int v) {
        int b3 = v >>> 24 & 0xFF;
        int b2 = v >>> 16 & 0xFF;
        int b1 = v >>> 8 & 0xFF;
        int b0 = v >>> 0 & 0xFF;
        try {
            this.out.write(b0);
            this.out.write(b1);
            this.out.write(b2);
            this.out.write(b3);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeLong(long v) {
        this.writeInt((int)(v >> 0));
        this.writeInt((int)(v >> 32));
    }

    public void writeShort(int v) {
        int b1 = v >>> 8 & 0xFF;
        int b0 = v >>> 0 & 0xFF;
        try {
            this.out.write(b0);
            this.out.write(b1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write(byte[] b) {
        try {
            super.write(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write(byte[] b, int off, int len) {
        try {
            super.write(b, off, len);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

