/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.apache.poi.util;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Method;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class SAXHelper {
    private static Logger logger = LoggerFactory.getLogger(SAXHelper.class);
    static final EntityResolver IGNORING_ENTITY_RESOLVER = new EntityResolver(){

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new StringReader(""));
        }
    };
    private static final SAXParserFactory saxFactory = SAXParserFactory.newInstance();

    private SAXHelper() {
    }

    public static synchronized XMLReader newXMLReader() throws SAXException, ParserConfigurationException {
        XMLReader xmlReader = saxFactory.newSAXParser().getXMLReader();
        xmlReader.setEntityResolver(IGNORING_ENTITY_RESOLVER);
        SAXHelper.trySetSAXFeature(xmlReader, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        SAXHelper.trySetXercesSecurityManager(xmlReader);
        return xmlReader;
    }

    private static void trySetSAXFeature(XMLReader xmlReader, String feature, boolean enabled) {
        try {
            xmlReader.setFeature(feature, enabled);
        }
        catch (Exception e) {
            logger.warn("SAX Feature unsupported " + feature, (Throwable)e);
        }
        catch (AbstractMethodError ame) {
            logger.warn("Cannot set SAX feature because outdated XML parser in classpath" + feature, (Throwable)ame);
        }
    }

    private static void trySetXercesSecurityManager(XMLReader xmlReader) {
        for (String securityManagerClassName : new String[]{"com.sun.org.apache.xerces.internal.util.SecurityManager", "org.apache.xerces.util.SecurityManager"}) {
            try {
                Object mgr = Class.forName(securityManagerClassName).newInstance();
                Method setLimit = mgr.getClass().getMethod("setEntityExpansionLimit", Integer.TYPE);
                setLimit.invoke(mgr, 4096);
                xmlReader.setProperty("http://apache.org/xml/properties/security-manager", mgr);
                return;
            }
            catch (Exception e) {
                logger.warn("SAX Security Manager could not be setup", (Throwable)e);
            }
        }
    }

    static {
        saxFactory.setValidating(false);
        saxFactory.setNamespaceAware(true);
    }
}

