/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.services.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.Immutable;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class MyRetryHandler
implements HttpRequestRetryHandler {
    private static final int RETRY_SLEEP_TIME = 2000;
    public static final MyRetryHandler INSTANCE = new MyRetryHandler();
    private final int retryCount;
    private final boolean requestSentRetryEnabled;
    private final Set<Class<? extends IOException>> nonRetriableClasses;

    protected MyRetryHandler(int retryCount, boolean requestSentRetryEnabled, Collection<Class<? extends IOException>> clazzes) {
        this.retryCount = retryCount;
        this.requestSentRetryEnabled = requestSentRetryEnabled;
        this.nonRetriableClasses = new HashSet<Class<? extends IOException>>();
        for (Class<? extends IOException> clazz : clazzes) {
            this.nonRetriableClasses.add(clazz);
        }
    }

    public MyRetryHandler(int retryCount, boolean requestSentRetryEnabled) {
        this(retryCount, requestSentRetryEnabled, Arrays.asList(InterruptedIOException.class, UnknownHostException.class, ConnectException.class, SSLException.class, SocketException.class));
    }

    public MyRetryHandler() {
        this(3, false);
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        Args.notNull((Object)exception, (String)"Exception parameter");
        Args.notNull((Object)context, (String)"HTTP context");
        if (executionCount > this.retryCount) {
            return false;
        }
        if (this.nonRetriableClasses.contains(exception.getClass())) {
            return false;
        }
        for (Class<? extends IOException> rejectException : this.nonRetriableClasses) {
            if (!rejectException.isInstance(exception)) continue;
            return false;
        }
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        HttpRequest request = clientContext.getRequest();
        if (this.requestIsAborted(request)) {
            return false;
        }
        try {
            System.out.println("sleeping  " + executionCount);
            Thread.sleep(2000 * executionCount);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.handleAsIdempotent(request)) {
            System.out.println("retry handleAsIdempotent " + executionCount);
            return true;
        }
        if (!clientContext.isRequestSent() || this.requestSentRetryEnabled) {
            System.out.println("retry  " + executionCount);
            return true;
        }
        System.out.println("do not retry  " + exception.getClass().getName() + exception.getMessage());
        return false;
    }

    public boolean isRequestSentRetryEnabled() {
        return this.requestSentRetryEnabled;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    protected boolean handleAsIdempotent(HttpRequest request) {
        return !(request instanceof HttpEntityEnclosingRequest);
    }

    @Deprecated
    protected boolean requestIsAborted(HttpRequest request) {
        HttpRequest req = request;
        if (request instanceof RequestWrapper) {
            req = ((RequestWrapper)request).getOriginal();
        }
        return req instanceof HttpUriRequest && ((HttpUriRequest)req).isAborted();
    }
}

