/*
 * Decompiled with CFR 0.152.
 */
package org.pptx4j.model;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.docx4j.XmlUtils;
import org.docx4j.dml.BaseStyles;
import org.docx4j.dml.CTTextCharacterProperties;
import org.docx4j.dml.CTTextListStyle;
import org.docx4j.dml.CTTextParagraphProperties;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.PresentationML.MainPresentationPart;
import org.docx4j.openpackaging.parts.PresentationML.SlideMasterPart;
import org.docx4j.openpackaging.parts.ThemePart;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.DocDefaults;
import org.docx4j.wml.HpsMeasure;
import org.docx4j.wml.Jc;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.PPr;
import org.docx4j.wml.RFonts;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Style;
import org.docx4j.wml.U;
import org.docx4j.wml.UnderlineEnumeration;
import org.pptx4j.pml.CTSlideMasterTextStyles;
import org.pptx4j.pml.Presentation;
import org.pptx4j.pml.SldMaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextStyles {
    private static final Logger log = LoggerFactory.getLogger(TextStyles.class);
    private static DocDefaults docDefaults;

    public static Style convertToWordStyle(CTTextParagraphProperties lvlPPr, String id, String name, String basedOn, BaseStyles.FontScheme fontScheme) {
        ObjectFactory factory = Context.getWmlObjectFactory();
        Style style = factory.createStyle();
        style.setType("paragraph");
        style.setStyleId(id);
        System.out.println("created " + id);
        Style.Name styleName = factory.createStyleName();
        styleName.setVal(name);
        style.setName(styleName);
        Style.BasedOn basedon = factory.createStyleBasedOn();
        basedon.setVal(basedOn);
        style.setBasedOn(basedon);
        if (lvlPPr == null) {
            log.warn("Empty style: " + id);
            if (log.isDebugEnabled()) {
                log.debug(XmlUtils.marshaltoString(lvlPPr, true, true, Context.jc, "URI", "lvl1pPr", CTTextParagraphProperties.class));
                log.debug("Converted to: " + XmlUtils.marshaltoString((Object)style, true, true));
            }
            return style;
        }
        style.setPPr(TextStyles.getWmlPPr(lvlPPr));
        style.setRPr(TextStyles.getWmlRPr(lvlPPr, fontScheme));
        if (log.isDebugEnabled()) {
            log.debug(XmlUtils.marshaltoString(lvlPPr, true, true, Context.jc, "URI", "lvl1pPr", CTTextParagraphProperties.class));
            log.debug("Converted to: " + XmlUtils.marshaltoString((Object)style, true, true));
        }
        return style;
    }

    public static PPr getWmlPPr(CTTextParagraphProperties lvlPPr) {
        ObjectFactory factory = Context.getWmlObjectFactory();
        PPr pPr = factory.createPPr();
        if (lvlPPr.getAlgn() != null) {
            Jc jc = factory.createJc();
            String algn = lvlPPr.getAlgn().value();
            log.debug("algn: " + algn);
            if (algn.equals("l")) {
                jc.setVal(JcEnumeration.LEFT);
            } else if (algn.equals("ctr")) {
                jc.setVal(JcEnumeration.CENTER);
            } else if (algn.equals("r")) {
                jc.setVal(JcEnumeration.RIGHT);
            } else {
                log.warn("How to handle algn: " + algn);
            }
            pPr.setJc(jc);
        }
        return pPr;
    }

    public static RPr getWmlRPr(CTTextParagraphProperties lvlPPr, BaseStyles.FontScheme fontScheme) {
        ObjectFactory factory = Context.getWmlObjectFactory();
        RPr rPr = factory.createRPr();
        if (lvlPPr.getDefRPr() != null) {
            if (lvlPPr.getDefRPr().getSz() != null) {
                rPr.setSz(TextStyles.convertFontSize(lvlPPr.getDefRPr().getSz()));
            }
            if (lvlPPr.getDefRPr().getLatin() != null) {
                RFonts rFonts = factory.createRFonts();
                if (lvlPPr.getDefRPr().getLatin().getTypeface().startsWith("+mj")) {
                    rFonts.setAscii(fontScheme.getMajorFont().getLatin().getTypeface());
                } else if (lvlPPr.getDefRPr().getLatin().getTypeface().startsWith("+mn")) {
                    rFonts.setAscii(fontScheme.getMinorFont().getLatin().getTypeface());
                }
                rPr.setRFonts(rFonts);
            }
        }
        return rPr;
    }

    private static HpsMeasure convertFontSize(Integer in) {
        ObjectFactory factory = Context.getWmlObjectFactory();
        HpsMeasure sz = factory.createHpsMeasure();
        int halfPts = Math.round(in / 50);
        sz.setVal(BigInteger.valueOf(halfPts));
        return sz;
    }

    public static List<Style> generateWordStylesFromPresentationPart(CTTextListStyle textStyles, String suffix, BaseStyles.FontScheme fontScheme) {
        ArrayList<Style> styles = new ArrayList<Style>();
        if (textStyles == null) {
            return styles;
        }
        styles.add(TextStyles.convertToWordStyle(textStyles.getLvl1PPr(), "Lvl1" + suffix, "Lvl1" + suffix, "DocDefaults", fontScheme));
        styles.add(TextStyles.convertToWordStyle(textStyles.getLvl2PPr(), "Lvl2" + suffix, "Lvl2" + suffix, "DocDefaults", fontScheme));
        styles.add(TextStyles.convertToWordStyle(textStyles.getLvl3PPr(), "Lvl3" + suffix, "Lvl3" + suffix, "DocDefaults", fontScheme));
        styles.add(TextStyles.convertToWordStyle(textStyles.getLvl4PPr(), "Lvl4" + suffix, "Lvl4" + suffix, "DocDefaults", fontScheme));
        styles.add(TextStyles.convertToWordStyle(textStyles.getLvl5PPr(), "Lvl5" + suffix, "Lvl5" + suffix, "DocDefaults", fontScheme));
        styles.add(TextStyles.convertToWordStyle(textStyles.getLvl6PPr(), "Lvl6" + suffix, "Lvl6" + suffix, "DocDefaults", fontScheme));
        styles.add(TextStyles.convertToWordStyle(textStyles.getLvl7PPr(), "Lvl7" + suffix, "Lvl7" + suffix, "DocDefaults", fontScheme));
        styles.add(TextStyles.convertToWordStyle(textStyles.getLvl8PPr(), "Lvl8" + suffix, "Lvl8" + suffix, "DocDefaults", fontScheme));
        styles.add(TextStyles.convertToWordStyle(textStyles.getLvl9PPr(), "Lvl9" + suffix, "Lvl9" + suffix, "DocDefaults", fontScheme));
        return styles;
    }

    public static List<Style> generateWordStylesForMaster(CTSlideMasterTextStyles masterTextStyles, int mastern, BaseStyles.FontScheme fontScheme) {
        ArrayList<Style> styles = new ArrayList<Style>();
        if (masterTextStyles == null) {
            return styles;
        }
        styles.addAll(TextStyles.generateLvlNMasterStyle(masterTextStyles.getTitleStyle(), "Master" + mastern + "Title", fontScheme));
        styles.addAll(TextStyles.generateLvlNMasterStyle(masterTextStyles.getBodyStyle(), "Master" + mastern + "Body", fontScheme));
        styles.addAll(TextStyles.generateLvlNMasterStyle(masterTextStyles.getOtherStyle(), "Master" + mastern + "Other", fontScheme));
        return styles;
    }

    private static List<Style> generateLvlNMasterStyle(CTTextListStyle textStyles, String suffix, BaseStyles.FontScheme fontScheme) {
        ArrayList<Style> styles = new ArrayList<Style>();
        if (textStyles == null) {
            textStyles = new CTTextListStyle();
        }
        styles.add(TextStyles.convertToWordStyle(textStyles.getLvl1PPr(), "Lvl1" + suffix, "Lvl1" + suffix, "Lvl1", fontScheme));
        styles.add(TextStyles.convertToWordStyle(textStyles.getLvl2PPr(), "Lvl2" + suffix, "Lvl2" + suffix, "Lvl2", fontScheme));
        styles.add(TextStyles.convertToWordStyle(textStyles.getLvl3PPr(), "Lvl3" + suffix, "Lvl3" + suffix, "Lvl3", fontScheme));
        styles.add(TextStyles.convertToWordStyle(textStyles.getLvl4PPr(), "Lvl4" + suffix, "Lvl4" + suffix, "Lvl4", fontScheme));
        styles.add(TextStyles.convertToWordStyle(textStyles.getLvl5PPr(), "Lvl5" + suffix, "Lvl5" + suffix, "Lvl5", fontScheme));
        styles.add(TextStyles.convertToWordStyle(textStyles.getLvl6PPr(), "Lvl6" + suffix, "Lvl6" + suffix, "Lvl6", fontScheme));
        styles.add(TextStyles.convertToWordStyle(textStyles.getLvl7PPr(), "Lvl7" + suffix, "Lvl7" + suffix, "Lvl7", fontScheme));
        styles.add(TextStyles.convertToWordStyle(textStyles.getLvl8PPr(), "Lvl8" + suffix, "Lvl8" + suffix, "Lvl8", fontScheme));
        styles.add(TextStyles.convertToWordStyle(textStyles.getLvl9PPr(), "Lvl9" + suffix, "Lvl9" + suffix, "Lvl9", fontScheme));
        return styles;
    }

    protected static DocDefaults generateDocDefaults(BaseStyles.FontScheme fontScheme) {
        ObjectFactory factory = Context.getWmlObjectFactory();
        DocDefaults docDefaults = factory.createDocDefaults();
        DocDefaults.RPrDefault rPrDefault = factory.createDocDefaultsRPrDefault();
        docDefaults.setRPrDefault(rPrDefault);
        RPr rPr = factory.createRPr();
        rPrDefault.setRPr(rPr);
        RFonts rFonts = factory.createRFonts();
        rFonts.setAscii(fontScheme.getMinorFont().getLatin().getTypeface());
        rPr.setRFonts(rFonts);
        return docDefaults;
    }

    public static DocDefaults generateDocDefaults() {
        return docDefaults;
    }

    public static List<Style> generateStyles(PresentationMLPackage presentationMLPackage) throws InvalidFormatException {
        ThemePart tp = (ThemePart)presentationMLPackage.getParts().getParts().get(new PartName("/ppt/theme/theme1.xml"));
        BaseStyles.FontScheme fontScheme = tp.getFontScheme();
        ArrayList<Style> styles = new ArrayList<Style>();
        TextStyles.generateDocDefaults(fontScheme);
        MainPresentationPart pp = (MainPresentationPart)presentationMLPackage.getParts().getParts().get(new PartName("/ppt/presentation.xml"));
        styles.addAll(TextStyles.generateWordStylesFromPresentationPart(((Presentation)pp.getJaxbElement()).getDefaultTextStyle(), "", fontScheme));
        SlideMasterPart master = (SlideMasterPart)presentationMLPackage.getParts().getParts().get(new PartName("/ppt/slideMasters/slideMaster1.xml"));
        styles.addAll(TextStyles.generateWordStylesForMaster(((SldMaster)master.getJaxbElement()).getTxStyles(), 1, fontScheme));
        return styles;
    }

    public static RPr getWmlRPr(CTTextCharacterProperties in) {
        ObjectFactory factory = Context.getWmlObjectFactory();
        RPr rPr = factory.createRPr();
        if (in == null) {
            System.out.println("Was passed null");
            return rPr;
        }
        if (in.isI() != null && in.isI().booleanValue()) {
            rPr.setI(new BooleanDefaultTrue());
        }
        if (in.isB() != null && in.isB().booleanValue()) {
            rPr.setB(new BooleanDefaultTrue());
        }
        if (in.getU() != null) {
            U u = factory.createU();
            u.setVal(UnderlineEnumeration.SINGLE);
            rPr.setU(u);
        }
        if (in.getSz() != null) {
            rPr.setSz(TextStyles.convertFontSize(in.getSz()));
        }
        return rPr;
    }
}

