/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import mockit.internal.util.StackTrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CallPoint
implements Serializable {
    private static final long serialVersionUID = 362727169057343840L;
    private static final Map<StackTraceElement, Boolean> steCache;
    private static final Class<? extends Annotation> testAnnotation;
    private static final boolean checkTestAnnotationOnClass;
    private static final boolean checkIfTestCaseSubclass;
    private final StackTraceElement ste;

    private static Class<?> getTestNGAnnotationIfAvailable() {
        try {
            return Class.forName("org.testng.annotations.Test");
        }
        catch (ClassNotFoundException ignore) {
            try {
                return Class.forName("org.testng.Test");
            }
            catch (ClassNotFoundException ignored) {
                return null;
            }
        }
    }

    private static boolean checkForJUnit3Availability() {
        try {
            Class.forName("junit.framework.TestCase");
            return true;
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }

    public CallPoint(StackTraceElement ste) {
        this.ste = ste;
    }

    public StackTraceElement getStackTraceElement() {
        return this.ste;
    }

    static CallPoint create(Throwable newThrowable) {
        StackTrace st = new StackTrace(newThrowable);
        int n = st.getDepth();
        for (int i = 2; i < n; ++i) {
            StackTraceElement ste = st.getElement(i);
            if (!CallPoint.isTestMethod(ste)) continue;
            return new CallPoint(ste);
        }
        return null;
    }

    private static boolean isTestMethod(StackTraceElement ste) {
        if (steCache.containsKey(ste)) {
            return steCache.get(ste);
        }
        if (ste.getFileName() == null || ste.getLineNumber() < 0) {
            steCache.put(ste, false);
            return false;
        }
        Class<?> aClass = CallPoint.loadClass(ste.getClassName());
        Method method = CallPoint.findMethod(aClass, ste.getMethodName());
        if (method == null) {
            steCache.put(ste, false);
            return false;
        }
        boolean isTestMethod = checkTestAnnotationOnClass && aClass.isAnnotationPresent(testAnnotation) || CallPoint.containsATestFrameworkAnnotation(method.getDeclaredAnnotations()) || checkIfTestCaseSubclass && CallPoint.isJUnit3xTestMethod(aClass, method);
        steCache.put(ste, isTestMethod);
        return isTestMethod;
    }

    private static Class<?> loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static Method findMethod(Class<?> aClass, String name) {
        try {
            for (Method method : aClass.getDeclaredMethods()) {
                if (!Modifier.isPublic(method.getModifiers()) || method.getReturnType() != Void.TYPE || !name.equals(method.getName())) continue;
                return method;
            }
        }
        catch (NoClassDefFoundError e) {
            System.out.println(e + " when attempting to find method \"" + name + "\" in " + aClass);
        }
        return null;
    }

    private static boolean containsATestFrameworkAnnotation(Annotation[] methodAnnotations) {
        for (Annotation annotation : methodAnnotations) {
            String annotationName = annotation.annotationType().getName();
            if (!annotationName.startsWith("org.junit.") && !annotationName.startsWith("org.testng.")) continue;
            return true;
        }
        return false;
    }

    private static boolean isJUnit3xTestMethod(Class<?> aClass, Method method) {
        if (!method.getName().startsWith("test")) {
            return false;
        }
        for (Class<?> superClass = aClass.getSuperclass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            if (!"junit.framework.TestCase".equals(superClass.getName())) continue;
            return true;
        }
        return false;
    }

    static {
        Class<?> annotation;
        steCache = new HashMap<StackTraceElement, Boolean>();
        boolean checkOnClassAlso = true;
        try {
            annotation = Class.forName("org.junit.Test");
            checkOnClassAlso = false;
        }
        catch (ClassNotFoundException ignore) {
            annotation = CallPoint.getTestNGAnnotationIfAvailable();
        }
        testAnnotation = annotation;
        checkTestAnnotationOnClass = checkOnClassAlso;
        checkIfTestCaseSubclass = CallPoint.checkForJUnit3Availability();
    }
}

