/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import mockit.coverage.Configuration;
import mockit.coverage.standalone.Startup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Metrics {
    LineCoverage{

        public boolean isActive() {
            return this.isActive("line");
        }

        public String toString() {
            return "Line";
        }

        public String itemName() {
            return "Line segments";
        }

        public String htmlDescription() {
            return "Measures how much of the executable production code was exercised by tests.\r\nAn executable line of code contains one or more executable segments.\r\nThe percentages are calculated as 100*NE/NS, where NS is the number of segments and NE the number of executed segments.";
        }
    }
    ,
    PathCoverage{

        public boolean isActive() {
            return this.isActive("path");
        }

        public String toString() {
            return "Path";
        }

        public String itemName() {
            return "Paths";
        }

        public String htmlDescription() {
            return "Measures how many of the possible execution paths through method/constructor bodies were actually executed by tests.\r\nThe percentages are calculated as 100*NPE/NP, where NP is the number of possible paths and NPE the number of fully executed paths.";
        }
    }
    ,
    DataCoverage{

        public boolean isActive() {
            return Startup.isTestRun() && Startup.isJMockitAvailable() && this.isActive("data");
        }

        public String toString() {
            return "Data";
        }

        public String itemName() {
            return "Fields";
        }

        public String htmlDescription() {
            return "Measures how many of the instance and static non-final fields were fully exercised by the test run.\r\nTo be fully exercised, a field must have the last value assigned to it read by at least one test.\r\nThe percentages are calculated as 100*NFE/NF, where NF is the number of non-final fields and NFE the number of fully exercised fields.";
        }
    };


    public abstract boolean isActive();

    public abstract String itemName();

    public abstract String htmlDescription();

    final boolean isActive(String name) {
        String metrics = Configuration.getProperty("metrics", "all");
        boolean all = "all".equals(metrics);
        return all || metrics.contains(name);
    }

    public static void performAction(Action action) {
        for (Metrics metric : Metrics.values()) {
            if (!metric.isActive()) continue;
            action.perform(metric);
        }
    }

    public static interface Action {
        public void perform(Metrics var1);
    }
}

