/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.data;

import java.io.Serializable;
import java.util.Collection;
import java.util.SortedMap;
import mockit.coverage.Metrics;
import mockit.coverage.data.PerFileCoverage;
import mockit.coverage.dataItems.PerFileDataCoverage;
import mockit.coverage.lines.LineCoverageData;
import mockit.coverage.lines.PerFileLineCoverage;
import mockit.coverage.paths.MethodCoverageData;
import mockit.coverage.paths.PerFilePathCoverage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileCoverageData
implements Serializable {
    private static final long serialVersionUID = 3508572808457541012L;
    public final PerFileLineCoverage lineCoverageInfo = new PerFileLineCoverage();
    public final PerFilePathCoverage pathCoverageInfo = new PerFilePathCoverage();
    public final PerFileDataCoverage dataCoverageInfo = new PerFileDataCoverage();
    public String kindOfTopLevelType;
    long lastModified;

    public FileCoverageData(String kindOfTopLevelType) {
        this.kindOfTopLevelType = kindOfTopLevelType;
    }

    public LineCoverageData addLine(int line) {
        return this.lineCoverageInfo.addLine(line);
    }

    public SortedMap<Integer, LineCoverageData> getLineToLineData() {
        return this.lineCoverageInfo.lineToLineData;
    }

    public void addMethod(MethodCoverageData methodData) {
        this.pathCoverageInfo.addMethod(methodData);
    }

    public Collection<MethodCoverageData> getMethods() {
        return this.pathCoverageInfo.firstLineToMethodData.values();
    }

    public PerFileCoverage getPerFileCoverage(Metrics metric) {
        switch (metric) {
            case LineCoverage: {
                return this.lineCoverageInfo;
            }
            case PathCoverage: {
                return this.pathCoverageInfo;
            }
        }
        return this.dataCoverageInfo;
    }

    void mergeWithDataFromPreviousTestRun(FileCoverageData previousInfo) {
        this.lineCoverageInfo.mergeInformation(previousInfo.lineCoverageInfo);
        this.pathCoverageInfo.mergeInformation(previousInfo.pathCoverageInfo);
        this.dataCoverageInfo.mergeInformation(previousInfo.dataCoverageInfo);
    }

    void reset() {
        this.lineCoverageInfo.reset();
        this.pathCoverageInfo.reset();
    }
}

