/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.dataItems;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mockit.coverage.CoveragePercentage;
import mockit.coverage.data.PerFileCoverage;
import mockit.coverage.dataItems.FieldData;
import mockit.coverage.dataItems.InstanceFieldData;
import mockit.coverage.dataItems.StaticFieldData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PerFileDataCoverage
implements PerFileCoverage {
    private static final long serialVersionUID = -4561686103982673490L;
    public final List<String> allFields = new ArrayList<String>(2);
    public final Map<String, StaticFieldData> staticFieldsData = new LinkedHashMap<String, StaticFieldData>();
    public final Map<String, InstanceFieldData> instanceFieldsData = new LinkedHashMap<String, InstanceFieldData>();
    private transient int coveredDataItems = -1;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.coveredDataItems = -1;
        in.defaultReadObject();
    }

    public void addField(String className, String fieldName, boolean isStatic) {
        String classAndField = className + '.' + fieldName;
        this.allFields.add(classAndField);
        if (isStatic) {
            this.staticFieldsData.put(classAndField, new StaticFieldData());
        } else {
            this.instanceFieldsData.put(classAndField, new InstanceFieldData());
        }
    }

    public boolean isFieldWithCoverageData(String classAndFieldNames) {
        return this.instanceFieldsData.containsKey(classAndFieldNames) || this.staticFieldsData.containsKey(classAndFieldNames);
    }

    public void registerAssignmentToStaticField(String classAndFieldNames) {
        StaticFieldData staticData = this.getStaticFieldData(classAndFieldNames);
        staticData.registerAssignment();
    }

    public StaticFieldData getStaticFieldData(String classAndFieldNames) {
        return this.staticFieldsData.get(classAndFieldNames);
    }

    public void registerReadOfStaticField(String classAndFieldNames) {
        StaticFieldData staticData = this.getStaticFieldData(classAndFieldNames);
        staticData.registerRead();
    }

    public void registerAssignmentToInstanceField(Object instance, String classAndFieldNames) {
        InstanceFieldData instanceData = this.getInstanceFieldData(classAndFieldNames);
        instanceData.registerAssignment(instance);
    }

    public InstanceFieldData getInstanceFieldData(String classAndFieldNames) {
        return this.instanceFieldsData.get(classAndFieldNames);
    }

    public void registerReadOfInstanceField(Object instance, String classAndFieldNames) {
        InstanceFieldData instanceData = this.getInstanceFieldData(classAndFieldNames);
        instanceData.registerRead(instance);
    }

    public boolean hasFields() {
        return !this.allFields.isEmpty();
    }

    public boolean isCovered(String classAndFieldNames) {
        InstanceFieldData instanceData = this.getInstanceFieldData(classAndFieldNames);
        if (instanceData != null && instanceData.isCovered()) {
            return true;
        }
        StaticFieldData staticData = this.getStaticFieldData(classAndFieldNames);
        return staticData != null && staticData.isCovered();
    }

    @Override
    public int getTotalItems() {
        return this.staticFieldsData.size() + this.instanceFieldsData.size();
    }

    @Override
    public int getCoveredItems() {
        if (this.coveredDataItems >= 0) {
            return this.coveredDataItems;
        }
        this.coveredDataItems = 0;
        for (StaticFieldData staticData : this.staticFieldsData.values()) {
            if (!staticData.isCovered()) continue;
            ++this.coveredDataItems;
        }
        for (InstanceFieldData instanceData : this.instanceFieldsData.values()) {
            if (!instanceData.isCovered()) continue;
            ++this.coveredDataItems;
        }
        return this.coveredDataItems;
    }

    @Override
    public int getCoveragePercentage() {
        int totalFields = this.getTotalItems();
        if (totalFields == 0) {
            return -1;
        }
        return CoveragePercentage.calculate(this.getCoveredItems(), totalFields);
    }

    public void mergeInformation(PerFileDataCoverage previousInfo) {
        this.addInfoFromPreviousTestRun(this.staticFieldsData, previousInfo.staticFieldsData);
        this.addFieldsFromPreviousTestRunIfAbsent(this.staticFieldsData, previousInfo.staticFieldsData);
        this.addInfoFromPreviousTestRun(this.instanceFieldsData, previousInfo.instanceFieldsData);
        this.addFieldsFromPreviousTestRunIfAbsent(this.instanceFieldsData, previousInfo.instanceFieldsData);
    }

    private <FI extends FieldData> void addInfoFromPreviousTestRun(Map<String, FI> currentInfo, Map<String, FI> previousInfo) {
        for (Map.Entry<String, FI> nameAndInfo : currentInfo.entrySet()) {
            String fieldName = nameAndInfo.getKey();
            FieldData previousFieldInfo = (FieldData)previousInfo.get(fieldName);
            if (previousFieldInfo == null) continue;
            FieldData fieldInfo = (FieldData)nameAndInfo.getValue();
            fieldInfo.addCountsFromPreviousTestRun(previousFieldInfo);
        }
    }

    private <FI extends FieldData> void addFieldsFromPreviousTestRunIfAbsent(Map<String, FI> currentInfo, Map<String, FI> previousInfo) {
        for (Map.Entry<String, FI> nameAndInfo : previousInfo.entrySet()) {
            String fieldName = nameAndInfo.getKey();
            if (currentInfo.containsKey(fieldName)) continue;
            currentInfo.put(fieldName, previousInfo.get(fieldName));
        }
    }
}

