/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.lines;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import mockit.coverage.CallPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineSegmentData
implements Serializable {
    private static final long serialVersionUID = -6233980722802474992L;
    boolean unreachable;
    int executionCount;
    private List<CallPoint> callPoints;

    public final boolean isUnreachable() {
        return this.unreachable;
    }

    public final void markAsUnreachable() {
        this.unreachable = true;
    }

    public final void registerExecution(CallPoint callPoint) {
        this.addCallPointIfAny(callPoint);
        ++this.executionCount;
    }

    final void addCallPointIfAny(CallPoint callPoint) {
        if (callPoint != null) {
            if (this.callPoints == null) {
                this.callPoints = new ArrayList<CallPoint>();
            }
            this.callPoints.add(callPoint);
        }
    }

    public final boolean containsCallPoints() {
        return this.callPoints != null;
    }

    public final List<CallPoint> getCallPoints() {
        return this.callPoints;
    }

    public int getExecutionCount() {
        return this.executionCount;
    }

    public boolean isCovered() {
        return this.unreachable || this.executionCount > 0;
    }

    final void addExecutionCountAndCallPointsFromPreviousTestRun(LineSegmentData previousData) {
        this.executionCount += previousData.executionCount;
        if (previousData.containsCallPoints()) {
            if (this.containsCallPoints()) {
                this.callPoints.addAll(0, previousData.callPoints);
            } else {
                this.callPoints = previousData.callPoints;
            }
        }
    }

    void reset() {
        this.executionCount = 0;
    }
}

