/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.modification;

import java.lang.instrument.ClassDefinition;
import java.lang.instrument.UnmodifiableClassException;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Set;
import mockit.coverage.modification.ClassSelection;
import mockit.coverage.modification.CoverageModifier;
import mockit.coverage.modification.VisitInterruptedException;
import mockit.coverage.standalone.Startup;
import mockit.external.asm4.ClassReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassModification {
    final Set<String> modifiedClasses = new HashSet<String>();
    final Set<ProtectionDomain> protectionDomains = new HashSet<ProtectionDomain>();
    private final ClassSelection classSelection = new ClassSelection();

    public ClassModification() {
        this.redefineClassesAlreadyLoadedForCoverage();
    }

    private void redefineClassesAlreadyLoadedForCoverage() {
        Class[] loadedClasses;
        for (Class loadedClass : loadedClasses = Startup.instrumentation().getAllLoadedClasses()) {
            if (loadedClass.getClassLoader() == null || loadedClass.isAnnotation() || loadedClass.isSynthetic() || !this.isToBeConsideredForCoverage(loadedClass.getName(), loadedClass.getProtectionDomain())) continue;
            this.redefineClassForCoverage(loadedClass);
        }
    }

    private void redefineClassForCoverage(Class<?> loadedClass) {
        byte[] modifiedClassfile = this.readAndModifyClassForCoverage(loadedClass);
        if (modifiedClassfile != null) {
            this.redefineClassForCoverage(loadedClass, modifiedClassfile);
            this.registerModifiedClass(loadedClass.getName(), loadedClass.getProtectionDomain());
        }
    }

    private void registerModifiedClass(String className, ProtectionDomain pd) {
        this.modifiedClasses.add(className);
        if (pd.getClassLoader() != null && pd.getCodeSource() != null && pd.getCodeSource().getLocation() != null) {
            this.protectionDomains.add(pd);
        }
    }

    private byte[] readAndModifyClassForCoverage(Class<?> aClass) {
        try {
            return this.modifyClassForCoverage(aClass);
        }
        catch (VisitInterruptedException ignore) {
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).printStackTrace();
        }
        return null;
    }

    private byte[] modifyClassForCoverage(Class<?> aClass) {
        String className = aClass.getName();
        byte[] modifiedBytecode = CoverageModifier.recoverModifiedByteCodeIfAvailable(className);
        if (modifiedBytecode != null) {
            return modifiedBytecode;
        }
        ClassReader cr = CoverageModifier.createClassReader(aClass);
        return cr == null ? null : this.modifyClassForCoverage(cr);
    }

    private byte[] modifyClassForCoverage(ClassReader cr) {
        CoverageModifier modifier = new CoverageModifier(cr);
        cr.accept(modifier, 0);
        return modifier.toByteArray();
    }

    private void redefineClassForCoverage(Class<?> loadedClass, byte[] modifiedClassfile) {
        ClassDefinition[] classDefs = new ClassDefinition[]{new ClassDefinition(loadedClass, modifiedClassfile)};
        try {
            Startup.instrumentation().redefineClasses(classDefs);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (UnmodifiableClassException e) {
            throw new RuntimeException(e);
        }
    }

    boolean isToBeConsideredForCoverage(String className, ProtectionDomain protectionDomain) {
        return protectionDomain != null && !this.modifiedClasses.contains(className) && this.classSelection.isSelected(className, protectionDomain);
    }

    public byte[] modifyClass(String className, ProtectionDomain protectionDomain, byte[] originalClassfile) {
        boolean modifyClassForCoverage = this.isToBeConsideredForCoverage(className, protectionDomain);
        if (modifyClassForCoverage) {
            try {
                byte[] modifiedClassfile = this.modifyClassForCoverage(className, originalClassfile);
                this.registerModifiedClass(className, protectionDomain);
                return modifiedClassfile;
            }
            catch (VisitInterruptedException ignore) {
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            catch (AssertionError e) {
                ((Throwable)((Object)e)).printStackTrace();
            }
        }
        return null;
    }

    private byte[] modifyClassForCoverage(String className, byte[] classBytecode) {
        byte[] modifiedBytecode = CoverageModifier.recoverModifiedByteCodeIfAvailable(className);
        if (modifiedBytecode != null) {
            return modifiedBytecode;
        }
        ClassReader cr = new ClassReader(classBytecode);
        return this.modifyClassForCoverage(cr);
    }
}

