/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.modification;

import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mockit.coverage.Configuration;
import mockit.coverage.standalone.Startup;

final class ClassSelection {
    private final Matcher classesToInclude = this.getClassNameRegex("classes");
    private final Matcher classesToExclude = this.getClassNameRegex("excludes");
    private final Matcher testCode = Startup.isTestRun() ? Pattern.compile(".+Test(\\$.+)?").matcher("") : null;

    ClassSelection() {
    }

    private Matcher getClassNameRegex(String propertySuffix) {
        String regex = Configuration.getProperty(propertySuffix, "");
        return regex.length() == 0 ? null : Pattern.compile(regex).matcher("");
    }

    boolean isSelected(String className, ProtectionDomain protectionDomain) {
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null || className.charAt(0) == '[' || className.startsWith("mockit.") || className.startsWith("org.junit.") || className.startsWith("junit.") || className.startsWith("org.testng.")) {
            return false;
        }
        if (this.classesToExclude != null && this.classesToExclude.reset(className).matches()) {
            return false;
        }
        if (this.classesToInclude != null && this.classesToInclude.reset(className).matches()) {
            return true;
        }
        if (this.testCode != null && this.testCode.reset(className).matches()) {
            return false;
        }
        String location = codeSource.getLocation().getPath();
        return !location.endsWith(".jar") && !location.endsWith("/.cp/") && (this.testCode == null || !location.endsWith("/test-classes/") && !location.endsWith("/jmockit/main/classes/"));
    }
}

