/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.modification;

import java.io.File;
import java.security.ProtectionDomain;
import mockit.coverage.modification.ClassModification;

public final class ClassesNotLoaded {
    private final ClassModification classModification;
    private ProtectionDomain protectionDomain;
    private int firstPosAfterParentDir;

    public ClassesNotLoaded(ClassModification classModification) {
        this.classModification = classModification;
    }

    public void gatherCoverageData() {
        for (ProtectionDomain pd : this.classModification.protectionDomains) {
            File classPathEntry = new File(pd.getCodeSource().getLocation().getPath());
            if (classPathEntry.getPath().endsWith(".jar")) continue;
            this.protectionDomain = pd;
            this.firstPosAfterParentDir = classPathEntry.getPath().length() + 1;
            this.loadAdditionalClasses(classPathEntry);
        }
    }

    private void loadAdditionalClasses(File classPathEntry) {
        File[] filesInDir = classPathEntry.listFiles();
        if (filesInDir != null) {
            for (File fileInDir : filesInDir) {
                if (fileInDir.isDirectory()) {
                    this.loadAdditionalClasses(fileInDir);
                    continue;
                }
                this.loadAdditionalClass(fileInDir.getPath());
            }
        }
    }

    private void loadAdditionalClass(String filePath) {
        String relativePath;
        String className;
        int p = filePath.lastIndexOf(".class");
        if (p > 0 && this.classModification.isToBeConsideredForCoverage(className = (relativePath = filePath.substring(this.firstPosAfterParentDir, p)).replace(File.separatorChar, '.'), this.protectionDomain)) {
            this.loadClass(className);
        }
    }

    private void loadClass(String className) {
        try {
            Class.forName(className, false, this.protectionDomain.getClassLoader());
        }
        catch (ClassNotFoundException ignore) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

