/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.paths;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mockit.coverage.paths.Node;
import mockit.external.asm4.Label;

public final class NodeBuilder {
    public int firstLine;
    final List<Node> nodes = new ArrayList<Node>();
    private Node.Entry entryNode;
    private Node.SimpleFork currentSimpleFork;
    private Node.BasicBlock currentBasicBlock;
    private Node.Join currentJoin;
    private final Map<Label, List<Node.Fork>> jumpTargetToForks = new LinkedHashMap<Label, List<Node.Fork>>();
    private final Map<Label, List<Node.GotoSuccessor>> gotoTargetToSuccessors = new LinkedHashMap<Label, List<Node.GotoSuccessor>>();
    private int potentiallyTrivialJump;

    public void handleEntry(int line) {
        this.firstLine = line;
        this.entryNode = new Node.Entry(line);
        this.addNewNode(this.entryNode);
    }

    private int addNewNode(Node newNode) {
        int newNodeIndex = this.nodes.size();
        this.nodes.add(newNode);
        if (newNodeIndex > 0) {
            Node precedingNode = this.nodes.get(newNodeIndex - 1);
            if (precedingNode.line == newNode.line) {
                newNode.setSegmentAccordingToPrecedingNode(precedingNode);
            }
        }
        return newNodeIndex;
    }

    public int handleRegularInstruction(int line, int opcode) {
        if (this.currentSimpleFork == null && this.currentJoin == null) {
            this.potentiallyTrivialJump = 0;
            return -1;
        }
        assert (this.currentBasicBlock == null);
        Node.BasicBlock newNode = new Node.BasicBlock(line);
        this.connectNodes(newNode, opcode);
        return this.addNewNode(newNode);
    }

    public int handleJump(Label targetBlock, int line, boolean conditional) {
        if (conditional) {
            Node.SimpleFork newFork = new Node.SimpleFork(line);
            assert (this.currentSimpleFork == null);
            this.connectNodes(targetBlock, newFork);
            this.currentSimpleFork = newFork;
            this.potentiallyTrivialJump = 1;
            return this.addNewNode(newFork);
        }
        if (this.currentBasicBlock == null && this.currentJoin == null) {
            Node.Goto newGoto = new Node.Goto(line);
            this.connectNodes(newGoto);
            this.setUpMappingFromGotoTargetToCurrentGotoSuccessor(targetBlock, newGoto);
            return this.addNewNode(newGoto);
        }
        this.setUpMappingFromGotoTargetToCurrentGotoSuccessor(targetBlock, null);
        return -1;
    }

    public int handleJumpTarget(Label basicBlock, int line) {
        if (this.isNewLineTarget(basicBlock)) {
            return -1;
        }
        Node.Join newNode = new Node.Join(line);
        this.connectNodes(basicBlock, newNode);
        return this.addNewNode(newNode);
    }

    private boolean isNewLineTarget(Label basicBlock) {
        return !this.jumpTargetToForks.containsKey(basicBlock) && !this.gotoTargetToSuccessors.containsKey(basicBlock);
    }

    private void connectNodes(Node.BasicBlock newBasicBlock, int opcode) {
        if (this.currentSimpleFork != null) {
            this.currentSimpleFork.nextConsecutiveNode = newBasicBlock;
            this.currentSimpleFork = null;
            if (this.potentiallyTrivialJump == 1) {
                this.potentiallyTrivialJump = opcode == 4 ? 2 : 0;
            }
        } else {
            if (this.potentiallyTrivialJump == 3) {
                if (opcode == 3) {
                    this.currentJoin.fromTrivialFork = true;
                }
                this.potentiallyTrivialJump = 0;
            }
            this.currentJoin.nextNode = newBasicBlock;
            this.currentJoin = null;
        }
        this.currentBasicBlock = newBasicBlock;
    }

    private void connectNodes(Label targetBlock, Node.Fork newFork) {
        if (this.entryNode.nextNode == null) {
            this.entryNode.nextNode = newFork;
        }
        this.setUpMappingFromConditionalTargetToFork(targetBlock, newFork);
        this.connectNodes(newFork);
    }

    private void setUpMappingFromConditionalTargetToFork(Label targetBlock, Node.Fork newFork) {
        List<Node.Fork> forksWithSameTarget = this.jumpTargetToForks.get(targetBlock);
        if (forksWithSameTarget == null) {
            forksWithSameTarget = new LinkedList<Node.Fork>();
            this.jumpTargetToForks.put(targetBlock, forksWithSameTarget);
        }
        forksWithSameTarget.add(newFork);
    }

    private void setUpMappingFromGotoTargetToCurrentGotoSuccessor(Label targetBlock, Node.Goto gotoNode) {
        List<Node.GotoSuccessor> successors = this.gotoTargetToSuccessors.get(targetBlock);
        if (successors == null) {
            successors = new LinkedList<Node.GotoSuccessor>();
            this.gotoTargetToSuccessors.put(targetBlock, successors);
        }
        if (this.currentBasicBlock != null) {
            assert (this.currentJoin == null) : "Ambiguous situation for " + targetBlock;
            successors.add(this.currentBasicBlock);
            this.currentBasicBlock = null;
            if (this.potentiallyTrivialJump == 2) {
                this.potentiallyTrivialJump = 3;
            }
        } else if (this.currentJoin != null) {
            successors.add(this.currentJoin);
            this.currentJoin = null;
        } else {
            successors.add(gotoNode);
        }
    }

    private void connectNodes(Label basicBlock, Node.Join newJoin) {
        this.connectNodes(newJoin);
        this.connectSourceForksToTargetedJoin(basicBlock, newJoin);
        this.connectGotoSuccessorsToNewJoin(basicBlock, newJoin);
        this.currentJoin = newJoin;
    }

    public int handleExit(int exitLine) {
        Node.Exit newNode = new Node.Exit(exitLine);
        this.connectNodes(newNode);
        return this.addNewNode(newNode);
    }

    private void connectNodes(Node.ConditionalSuccessor newNode) {
        if (this.currentSimpleFork != null) {
            this.currentSimpleFork.nextConsecutiveNode = newNode;
            this.currentSimpleFork = null;
            assert (this.currentJoin == null);
            assert (this.currentBasicBlock == null);
        }
        if (this.currentJoin != null) {
            this.currentJoin.nextNode = newNode;
            this.currentJoin = null;
            assert (this.currentBasicBlock == null);
        }
        if (this.currentBasicBlock != null) {
            this.currentBasicBlock.nextConsecutiveNode = newNode;
            this.currentBasicBlock = null;
        }
    }

    private void connectSourceForksToTargetedJoin(Label targetBlock, Node.Join newJoin) {
        List<Node.Fork> forks = this.jumpTargetToForks.get(targetBlock);
        if (forks != null) {
            for (Node.Fork fork : forks) {
                fork.addNextNode(newJoin);
            }
            this.jumpTargetToForks.remove(targetBlock);
        }
    }

    private void connectGotoSuccessorsToNewJoin(Label targetBlock, Node.Join newJoin) {
        List<Node.GotoSuccessor> successors = this.gotoTargetToSuccessors.get(targetBlock);
        if (successors != null) {
            for (Node.GotoSuccessor successorToGoto : successors) {
                successorToGoto.setNextNodeAfterGoto(newJoin);
            }
            this.gotoTargetToSuccessors.remove(targetBlock);
        }
    }

    public int handleForwardJumpsToNewTargets(Label defaultBlock, Label[] caseBlocks, int line) {
        Node.MultiFork newJoin = new Node.MultiFork(line);
        for (Label targetBlock : caseBlocks) {
            if (targetBlock == defaultBlock) continue;
            this.connectNodes(targetBlock, newJoin);
        }
        this.connectNodes(defaultBlock, newJoin);
        return this.addNewNode(newJoin);
    }
}

