/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.lineCoverage;

import java.io.PrintWriter;
import java.util.Map;
import mockit.coverage.lines.LineCoverageData;
import mockit.coverage.reporting.lineCoverage.LineCoverageFormatter;
import mockit.coverage.reporting.parsing.LineParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LineCoverageOutput {
    private final PrintWriter output;
    private final Map<Integer, LineCoverageData> lineToLineData;
    private final LineCoverageFormatter lineCoverageFormatter;
    private LineCoverageData lineData;

    public LineCoverageOutput(PrintWriter output, Map<Integer, LineCoverageData> lineToLineData, boolean withCallPoints) {
        this.output = output;
        this.lineToLineData = lineToLineData;
        this.lineCoverageFormatter = new LineCoverageFormatter(withCallPoints);
    }

    public boolean writeLineWithCoverageInfo(LineParser lineParser) {
        this.lineData = this.lineToLineData.get(lineParser.getNumber());
        if (this.lineData == null) {
            return false;
        }
        this.writeLineExecutionCount();
        this.writeExecutableCode(lineParser);
        return true;
    }

    private void writeLineExecutionCount() {
        this.output.write("<td class='count'>");
        this.output.print(this.lineData.getExecutionCount());
        this.output.println("</td>");
    }

    private void writeExecutableCode(LineParser lineParser) {
        String formattedLine = this.lineCoverageFormatter.format(lineParser, this.lineData);
        this.output.write("      <td>");
        this.output.write(formattedLine);
        this.output.println("</td>");
    }
}

