/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.parsing;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LineElement
implements Iterable<LineElement> {
    private static final List<String> CONDITIONAL_OPERATORS = Arrays.asList("||", "&&", ":", "else");
    private static final List<String> CONDITIONAL_INSTRUCTIONS = Arrays.asList("if", "for", "while");
    private final ElementType type;
    private final String text;
    private String openingTag;
    private String closingTag;
    private LineElement next;
    private boolean underConditionalStatement;
    private int parenthesesBalance;

    LineElement(ElementType type, String text) {
        this.type = type;
        this.text = text.replaceAll("<", "&lt;");
    }

    public boolean isCode() {
        return this.type == ElementType.CODE;
    }

    public boolean isComment() {
        return this.type == ElementType.COMMENT;
    }

    public boolean isKeyword(String keyword) {
        return this.isCode() && this.text.equals(keyword);
    }

    public boolean isDotSeparator() {
        return this.type == ElementType.SEPARATOR && this.text.charAt(0) == '.';
    }

    public String getText() {
        return this.text;
    }

    public LineElement getNext() {
        return this.next;
    }

    void setNext(LineElement next) {
        this.next = next;
    }

    public LineElement getNextCodeElement() {
        if (this.next != null) {
            for (LineElement element : this.next) {
                if (!element.isCode()) continue;
                return element;
            }
        }
        return null;
    }

    public void wrapText(String openingTag, String closingTag) {
        this.openingTag = openingTag;
        this.closingTag = closingTag;
    }

    public LineElement appendUntilNextCodeElement(StringBuilder line) {
        LineElement element = this;
        while (!element.isCode()) {
            element.appendText(line);
            element = element.next;
            if (element == null) break;
            this.copyConditionalTrackingState(element);
        }
        return element;
    }

    private void copyConditionalTrackingState(LineElement destination) {
        destination.underConditionalStatement = this.underConditionalStatement;
        destination.parenthesesBalance = this.parenthesesBalance;
    }

    private void appendText(StringBuilder line) {
        if (this.openingTag == null) {
            line.append(this.text);
        } else {
            line.append(this.openingTag).append(this.text).append(this.closingTag);
        }
    }

    public LineElement findNextBranchingPoint() {
        if (!this.underConditionalStatement) {
            this.underConditionalStatement = this.isConditionalStatement();
        }
        if (this.isBranchingElement()) {
            if (this.next != null) {
                this.copyConditionalTrackingState(this.next);
            }
            return this;
        }
        if (this.underConditionalStatement) {
            int balance = this.getParenthesisBalance();
            this.parenthesesBalance += balance;
            if (balance != 0 && this.parenthesesBalance == 0) {
                return this.next;
            }
        }
        if (this.next == null) {
            return null;
        }
        this.copyConditionalTrackingState(this.next);
        return this.next.findNextBranchingPoint();
    }

    private boolean isConditionalStatement() {
        return CONDITIONAL_INSTRUCTIONS.contains(this.text);
    }

    public boolean isBranchingElement() {
        return CONDITIONAL_OPERATORS.contains(this.text);
    }

    private int getParenthesisBalance() {
        if (this.text.indexOf(40) >= 0) {
            return 1;
        }
        if (this.text.indexOf(41) >= 0) {
            return -1;
        }
        return 0;
    }

    public LineElement findWord(String word) {
        for (LineElement element : this) {
            if (!element.isCode() || !word.equals(element.text)) continue;
            return element;
        }
        return null;
    }

    public int getBraceBalanceUntilEndOfLine() {
        int balance = 0;
        for (LineElement element : this) {
            balance += element.getBraceBalance();
        }
        return balance;
    }

    private int getBraceBalance() {
        if (this.isCode() && this.text.length() == 1) {
            char c = this.text.charAt(0);
            if (c == '{') {
                return 1;
            }
            if (c == '}') {
                return -1;
            }
        }
        return 0;
    }

    public void appendAllBefore(StringBuilder line, LineElement elementToStopBefore) {
        LineElement elementToPrint = this;
        do {
            elementToPrint.appendText(line);
        } while ((elementToPrint = elementToPrint.next) != elementToStopBefore);
    }

    @Override
    public Iterator<LineElement> iterator() {
        return new Iterator<LineElement>(){
            private LineElement current;
            {
                this.current = LineElement.this;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public LineElement next() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                LineElement next = this.current;
                this.current = this.current.next;
                return next;
            }

            @Override
            public void remove() {
            }
        };
    }

    public String toString() {
        StringBuilder line = new StringBuilder(200);
        for (LineElement element : this) {
            element.appendText(line);
        }
        return line.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ElementType {
        CODE,
        COMMENT,
        SEPARATOR;

    }
}

