/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.pathCoverage;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import mockit.coverage.CoveragePercentage;
import mockit.coverage.paths.MethodCoverageData;
import mockit.coverage.paths.Path;
import mockit.coverage.reporting.pathCoverage.PathCoverageFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PathCoverageOutput {
    private final PrintWriter output;
    private final PathCoverageFormatter pathFormatter;
    private final Iterator<MethodCoverageData> nextMethod;
    private MethodCoverageData currentMethod;

    public PathCoverageOutput(PrintWriter output, Collection<MethodCoverageData> methods) {
        this.output = output;
        this.pathFormatter = new PathCoverageFormatter(output);
        this.nextMethod = methods.iterator();
        this.moveToNextMethod();
    }

    private void moveToNextMethod() {
        this.currentMethod = this.nextMethod.hasNext() ? this.nextMethod.next() : null;
    }

    public void writePathCoverageInfoIfLineStartsANewMethodOrConstructor(int lineNumber) {
        if (this.currentMethod != null && lineNumber == this.currentMethod.getFirstLineInBody()) {
            this.writePathCoverageInformationForMethod();
            this.moveToNextMethod();
        }
    }

    private void writePathCoverageInformationForMethod() {
        List<Path> paths = this.currentMethod.getPaths();
        if (paths.size() > 1) {
            this.writeHeaderForAllPaths();
            this.pathFormatter.writeInformationForEachPath(paths);
            this.writeFooterForAllPaths();
        }
    }

    private void writeHeaderForAllPaths() {
        int coveredPaths = this.currentMethod.getCoveredPaths();
        int totalPaths = this.currentMethod.getTotalPaths();
        this.output.println("    <tr>");
        this.output.write("      <td></td><td class='count'>");
        this.output.print(this.currentMethod.getExecutionCount());
        this.output.println("</td>");
        this.output.println("      <td class='paths'>");
        this.output.write("        <span style='cursor:default; background-color:#");
        this.output.write(CoveragePercentage.percentageColor(coveredPaths, totalPaths));
        this.output.write("' onclick='hidePath()'>Path coverage: ");
        this.output.print(coveredPaths);
        this.output.print('/');
        this.output.print(totalPaths);
        this.output.println("</span>");
    }

    private void writeFooterForAllPaths() {
        this.output.println("      </td>");
        this.output.println("    </tr>");
    }
}

