/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.sourceFiles;

import java.io.IOException;
import java.util.Collection;
import mockit.coverage.Metrics;
import mockit.coverage.data.FileCoverageData;
import mockit.coverage.dataItems.PerFileDataCoverage;
import mockit.coverage.paths.MethodCoverageData;
import mockit.coverage.reporting.OutputFile;
import mockit.coverage.reporting.dataCoverage.DataCoverageOutput;
import mockit.coverage.reporting.lineCoverage.LineCoverageOutput;
import mockit.coverage.reporting.parsing.FileParser;
import mockit.coverage.reporting.parsing.LineElement;
import mockit.coverage.reporting.parsing.LineParser;
import mockit.coverage.reporting.pathCoverage.PathCoverageOutput;
import mockit.coverage.reporting.sourceFiles.InputFile;
import mockit.coverage.reporting.sourceFiles.NeutralOutput;

public final class FileCoverageReport {
    private final InputFile inputFile;
    private final OutputFile output;
    private final FileParser fileParser;
    private final NeutralOutput neutralOutput;
    private final LineCoverageOutput lineCoverage;
    private final PathCoverageOutput pathCoverage;
    private final DataCoverageOutput dataCoverage;

    public FileCoverageReport(String outputDir, InputFile inputFile, FileCoverageData fileData, boolean withCallPoints) throws IOException {
        this.inputFile = inputFile;
        this.output = new OutputFile(outputDir, inputFile.filePath);
        this.fileParser = new FileParser();
        this.neutralOutput = new NeutralOutput(this.output);
        this.lineCoverage = new LineCoverageOutput(this.output, fileData.getLineToLineData(), withCallPoints);
        this.pathCoverage = this.createPathCoverageOutput(fileData);
        this.dataCoverage = this.createDataCoverageOutput(fileData);
    }

    private PathCoverageOutput createPathCoverageOutput(FileCoverageData fileData) {
        if (Metrics.PathCoverage.isActive()) {
            Collection<MethodCoverageData> methods = fileData.getMethods();
            return methods.isEmpty() ? null : new PathCoverageOutput(this.output, methods);
        }
        return null;
    }

    private DataCoverageOutput createDataCoverageOutput(FileCoverageData fileData) {
        if (Metrics.DataCoverage.isActive()) {
            PerFileDataCoverage dataCoverageInfo = fileData.dataCoverageInfo;
            return dataCoverageInfo.hasFields() ? new DataCoverageOutput(dataCoverageInfo) : null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws IOException {
        try {
            this.writeHeader();
            this.writeFormattedSourceLines();
            this.writeFooter();
        }
        finally {
            this.inputFile.close();
            this.output.close();
        }
    }

    private void writeHeader() {
        this.output.writeCommonHeader(this.inputFile.getSourceFileName());
        this.output.println("  <table cellpadding='0' cellspacing='1'>");
        this.output.println("    <caption>" + this.inputFile.getSourceFilePath() + "</caption>");
    }

    private void writeFormattedSourceLines() throws IOException {
        String line;
        LineParser lineParser = this.fileParser.lineParser;
        while ((line = this.inputFile.nextLine()) != null) {
            boolean lineWithCodeElements = this.fileParser.parseCurrentLine(line);
            if (lineWithCodeElements) {
                if (this.dataCoverage != null) {
                    this.dataCoverage.writeCoverageInfoIfLineStartsANewFieldDeclaration(this.fileParser);
                }
                if (this.pathCoverage != null) {
                    this.pathCoverage.writePathCoverageInfoIfLineStartsANewMethodOrConstructor(lineParser.getNumber());
                }
            }
            if (this.neutralOutput.writeLineWithoutCoverageInfo(lineParser)) continue;
            this.writeOpeningOfNewLine(lineParser.getNumber());
            if (!this.lineCoverage.writeLineWithCoverageInfo(lineParser)) {
                this.writeLineWithoutCoverageInfo(lineParser.getInitialElement());
            }
            this.output.println("    </tr>");
        }
    }

    private void writeOpeningOfNewLine(int lineNumber) {
        this.output.println("    <tr>");
        this.output.write("      <td class='line'>");
        this.output.print(lineNumber);
        this.output.write("</td>");
    }

    private void writeLineWithoutCoverageInfo(LineElement initialElement) {
        this.output.println("<td>&nbsp;</td>");
        this.output.write("      <td><pre class='");
        this.output.write(initialElement.isComment() ? "comment'>" : "prettyprint'>");
        this.output.write(initialElement.toString());
        this.output.println("</pre></td>");
    }

    private void writeFooter() {
        this.output.println("  </table>");
        this.output.writeCommonFooter();
    }
}

