/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.sourceFiles;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InputFile {
    final String filePath;
    private final File sourceFile;
    private final BufferedReader input;

    public InputFile(List<File> sourceDirs, String filePath) throws FileNotFoundException {
        this.filePath = filePath;
        this.sourceFile = this.findSourceFile(sourceDirs, filePath);
        this.input = this.sourceFile == null ? null : new BufferedReader(new FileReader(this.sourceFile));
    }

    private File findSourceFile(List<File> sourceDirs, String filePath) {
        int p = filePath.indexOf(47);
        String topLevelPackage = p < 0 ? "" : filePath.substring(0, p);
        for (File sourceDir : sourceDirs) {
            File file = this.getSourceFile(sourceDir, topLevelPackage, filePath);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    private File getSourceFile(File sourceDir, String topLevelPackage, String filePath) {
        File[] subDirs;
        File file = new File(sourceDir, filePath);
        if (file.exists()) {
            return file;
        }
        for (File subDir : subDirs = sourceDir.listFiles()) {
            if (!subDir.isDirectory() || subDir.isHidden() || subDir.getName().equals(topLevelPackage) || (file = this.getSourceFile(subDir, topLevelPackage, filePath)) == null) continue;
            return file;
        }
        return null;
    }

    public boolean wasFileFound() {
        return this.sourceFile != null;
    }

    String getSourceFileName() {
        return this.sourceFile.getName();
    }

    String getSourceFilePath() {
        String path = this.sourceFile.getPath();
        return path.startsWith("..") ? path.substring(3) : path;
    }

    String nextLine() throws IOException {
        return this.input.readLine();
    }

    void close() throws IOException {
        this.input.close();
    }
}

