/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.startup;

import java.io.IOException;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.util.Properties;
import java.util.logging.LogManager;
import mockit.MockUp;
import mockit.internal.expectations.transformation.ExpectationsTransformer;
import mockit.internal.mockups.MockClassSetup;
import mockit.internal.startup.AgentInitialization;
import mockit.internal.startup.JMockitInitialization;
import mockit.internal.startup.Startup;
import mockit.internal.state.CachedClassfiles;
import mockit.internal.util.FieldReflection;
import mockit.internal.util.MethodReflection;
import mockit.internal.util.StackTrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Startup {
    static final String javaSpecVersion = System.getProperty("java.specification.version");
    static final boolean jdk6OrLater = "1.6".equals(javaSpecVersion) || "1.7".equals(javaSpecVersion) || "1.8".equals(javaSpecVersion);
    public static boolean initializing;
    private static Instrumentation instrumentation;
    private static boolean initializedOnDemand;

    private Startup() {
    }

    public static boolean isJava6OrLater() {
        return jdk6OrLater;
    }

    public static void premain(String agentArgs, Instrumentation inst) throws IOException {
        Startup.initialize(true, inst);
    }

    private static void initialize(boolean initializeTestNG, Instrumentation inst) throws IOException {
        if (instrumentation == null) {
            instrumentation = inst;
            Startup.applyStartupMocks(initializeTestNG);
            inst.addTransformer((ClassFileTransformer)CachedClassfiles.INSTANCE);
            inst.addTransformer((ClassFileTransformer)new ExpectationsTransformer(inst));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void applyStartupMocks(boolean initializeTestNG) throws IOException {
        initializing = true;
        try {
            new JMockitInitialization().initialize(initializeTestNG);
        }
        finally {
            initializing = false;
        }
    }

    public static void agentmain(String agentArgs, Instrumentation inst) throws IOException {
        Startup.initialize(false, inst);
        Properties properties = System.getProperties();
        properties.put("jmockit-instrumentation", inst);
        ClassLoader customCL = (ClassLoader)properties.remove("jmockit-customCL");
        if (customCL != null) {
            Startup.reinitializeJMockitUnderCustomClassLoader(customCL);
        }
    }

    private static void reinitializeJMockitUnderCustomClassLoader(ClassLoader customLoader) {
        Class<?> startupClass;
        try {
            startupClass = customLoader.loadClass(Startup.class.getName());
        }
        catch (ClassNotFoundException ignore) {
            return;
        }
        Startup.replaceCustomLogManagerAsNeeded();
        System.out.println("JMockit: Reinitializing under custom class loader " + customLoader);
        FieldReflection.setField(startupClass, null, (String)"instrumentation", (Object)instrumentation);
        MethodReflection.invoke(startupClass, (Object)null, (String)"reapplyStartupMocks", (Object[])new Object[0]);
    }

    private static void replaceCustomLogManagerAsNeeded() {
        LogManager logManager = LogManager.getLogManager();
        if (logManager.getClass() != LogManager.class) {
            1 newLogManager = new /* Unavailable Anonymous Inner Class!! */;
            FieldReflection.setField(LogManager.class, null, (String)"manager", (Object)newLogManager);
        }
    }

    private static void reapplyStartupMocks() {
        try {
            Startup.applyStartupMocks(false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Instrumentation instrumentation() {
        Startup.verifyInitialization();
        return instrumentation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Instrumentation inst, Class<? extends MockUp<?>> ... mockUpClasses) throws IOException {
        boolean fullJMockit = false;
        try {
            Class.forName("mockit.internal.expectations.transformation.ExpectationsTransformer");
            fullJMockit = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        instrumentation = inst;
        initializing = true;
        try {
            if (fullJMockit) {
                new JMockitInitialization().initialize(true);
            }
            Startup.applyMockUpClasses(mockUpClasses);
        }
        finally {
            initializing = false;
        }
        if (fullJMockit) {
            inst.addTransformer((ClassFileTransformer)CachedClassfiles.INSTANCE);
            inst.addTransformer((ClassFileTransformer)new ExpectationsTransformer(inst));
        }
    }

    private static void applyMockUpClasses(Class<? extends MockUp<?>>[] mockUpClasses) {
        for (Class<? extends MockUp<?>> mockUpClass : mockUpClasses) {
            try {
                new MockClassSetup(mockUpClass).redefineMethods();
            }
            catch (UnsupportedOperationException ignored) {
            }
            catch (Throwable unexpectedFailure) {
                StackTrace.filterStackTrace(unexpectedFailure);
                unexpectedFailure.printStackTrace();
            }
        }
    }

    public static boolean wasInitializedOnDemand() {
        return initializedOnDemand;
    }

    public static void verifyInitialization() {
        if (Startup.getInstrumentation() == null && (initializedOnDemand = new AgentInitialization().initializeAccordingToJDKVersion())) {
            System.out.println("WARNING: JMockit was initialized on demand, which may cause certain tests to fail;\nplease check the documentation for better ways to get it initialized.");
        }
    }

    private static Instrumentation getInstrumentation() {
        if (instrumentation == null && (instrumentation = (Instrumentation)System.getProperties().remove("jmockit-instrumentation")) != null) {
            Startup.reapplyStartupMocks();
        }
        return instrumentation;
    }

    public static boolean initializeIfPossible() {
        if (Startup.getInstrumentation() == null) {
            ClassLoader currentCL;
            if (jdk6OrLater && (currentCL = Startup.class.getClassLoader()) != ClassLoader.getSystemClassLoader()) {
                System.getProperties().put("jmockit-customCL", currentCL);
            }
            try {
                return new AgentInitialization().initializeAccordingToJDKVersion();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }
        return false;
    }

    public static void redefineMethods(Class<?> classToRedefine, byte[] modifiedClassfile) {
        Startup.redefineMethods(new ClassDefinition(classToRedefine, modifiedClassfile));
    }

    public static void redefineMethods(ClassDefinition ... classDefs) {
        CachedClassfiles.INSTANCE.setClassesBeingMocked(classDefs);
        try {
            Startup.instrumentation().redefineClasses(classDefs);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (UnmodifiableClassException e) {
            throw new RuntimeException(e);
        }
        catch (InternalError e) {
            for (ClassDefinition classDef : classDefs) {
                Startup.detectMissingDependenciesIfAny(classDef.getDefinitionClass());
            }
            throw e;
        }
        finally {
            CachedClassfiles.INSTANCE.setClassesBeingMocked(null);
        }
    }

    private static void detectMissingDependenciesIfAny(Class<?> mockedClass) {
        try {
            Class.forName(mockedClass.getName(), true, mockedClass.getClassLoader());
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException("Unable to mock " + mockedClass + " due to a missing dependency", e);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

