/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.state;

import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.mocking.SharedFieldTypeRedefinitions;
import mockit.internal.mockups.MockInvocation;
import mockit.internal.mockups.MockStates;
import mockit.internal.state.ExecutingTest;
import mockit.internal.state.MockClasses;
import mockit.internal.state.MockFixture;
import mockit.internal.state.SavePoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestRun {
    private static final TestRun INSTANCE = new TestRun();
    private static final ThreadLocal<Integer> noMockingCount = new /* Unavailable Anonymous Inner Class!! */;
    private int testId;
    private Class<?> currentTestClass;
    private Object currentTestInstance;
    private SavePoint savePointForTestMethod;
    private SavePoint savePointForTestClass;
    private SharedFieldTypeRedefinitions sharedFieldTypeRedefinitions;
    private final MockFixture mockFixture = new MockFixture();
    private final ExecutingTest executingTest = new ExecutingTest();
    private final MockClasses mockClasses = new MockClasses();

    private TestRun() {
    }

    public static boolean isInsideNoMockingZone() {
        return noMockingCount.get() > 0;
    }

    public static Class<?> getCurrentTestClass() {
        return TestRun.INSTANCE.currentTestClass;
    }

    public static Object getCurrentTestInstance() {
        return TestRun.INSTANCE.currentTestInstance;
    }

    public static int getTestId() {
        return TestRun.INSTANCE.testId;
    }

    public static SavePoint getSavePointForTestClass() {
        return TestRun.INSTANCE.savePointForTestClass;
    }

    public static SharedFieldTypeRedefinitions getSharedFieldTypeRedefinitions() {
        return TestRun.INSTANCE.sharedFieldTypeRedefinitions;
    }

    public static MockFixture mockFixture() {
        return TestRun.INSTANCE.mockFixture;
    }

    public static ExecutingTest getExecutingTest() {
        return TestRun.INSTANCE.executingTest;
    }

    public static RecordAndReplayExecution getRecordAndReplayForRunningTest() {
        return TestRun.INSTANCE.currentTestInstance == null ? null : TestRun.INSTANCE.executingTest.getCurrentRecordAndReplay();
    }

    public static RecordAndReplayExecution getRecordAndReplayForRunningTest(boolean create) {
        if (TestRun.INSTANCE.currentTestInstance == null) {
            return null;
        }
        return TestRun.INSTANCE.executingTest.getRecordAndReplay(TestRun.INSTANCE.savePointForTestMethod != null && create);
    }

    public static MockClasses getMockClasses() {
        return TestRun.INSTANCE.mockClasses;
    }

    public static void verifyExpectationsOnAnnotatedMocks() {
        TestRun.getMockClasses().getMockStates().verifyExpectations();
    }

    public static void resetExpectationsOnAnnotatedMocks() {
        TestRun.getMockClasses().getMockStates().resetExpectations();
    }

    public static void setCurrentTestClass(Class<?> testClass) {
        TestRun.INSTANCE.currentTestClass = testClass;
    }

    public static void prepareForNextTest() {
        ++TestRun.INSTANCE.testId;
        TestRun.INSTANCE.executingTest.setRecordAndReplay(null);
    }

    public static void setSavePointForTestMethod(SavePoint savePointForTestMethod) {
        TestRun.INSTANCE.savePointForTestMethod = savePointForTestMethod;
        if (savePointForTestMethod != null) {
            TestRun.INSTANCE.executingTest.clearRecordAndReplayForVerifications();
        }
    }

    public static void enterNoMockingZone() {
        noMockingCount.set(1);
    }

    public static void exitNoMockingZone() {
        noMockingCount.set(-1);
    }

    public static void setRunningIndividualTest(Object testInstance) {
        TestRun.INSTANCE.currentTestInstance = testInstance;
    }

    public static void setSavePointForTestClass(SavePoint savePoint) {
        TestRun.INSTANCE.savePointForTestClass = savePoint;
    }

    public static void setSharedFieldTypeRedefinitions(SharedFieldTypeRedefinitions redefinitions) {
        TestRun.INSTANCE.sharedFieldTypeRedefinitions = redefinitions;
    }

    public static void finishCurrentTestExecution(boolean clearSharedMocks) {
        TestRun.INSTANCE.savePointForTestMethod = null;
        TestRun.INSTANCE.executingTest.finishExecution(clearSharedMocks);
    }

    public static Object getMock(int index) {
        return TestRun.getMockClasses().regularMocks.getMock(index);
    }

    public static Object getStartupMock(int index) {
        return TestRun.getMockClasses().startupMocks.getMock(index);
    }

    public static boolean updateMockState(String mockClassDesc, int mockStateIndex) {
        MockStates mockStates = TestRun.getMockStates();
        return mockStates.updateMockState(mockClassDesc, mockStateIndex);
    }

    private static MockStates getMockStates() {
        return TestRun.getMockClasses().getMockStates();
    }

    public static void exitReentrantMock(String mockClassDesc, int mockStateIndex) {
        MockStates mockStates = TestRun.getMockStates();
        mockStates.exitReentrantMock(mockClassDesc, mockStateIndex);
    }

    public static MockInvocation createMockInvocation(String mockClassDesc, int mockStateIndex, Object mockedInstance, Object[] mockArgs) {
        MockStates mockStates = TestRun.getMockStates();
        return mockStates.createMockInvocation(mockClassDesc, mockStateIndex, mockedInstance, mockArgs);
    }
}

