/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StackTrace {
    private static final Method getStackTraceDepth = StackTrace.getThrowableMethod("getStackTraceDepth", new Class[0]);
    private static final Method getStackTraceElement = StackTrace.getThrowableMethod("getStackTraceElement", Integer.TYPE);
    private final Throwable t;
    private final StackTraceElement[] elements;

    private static Method getThrowableMethod(String name, Class<?> ... parameterTypes) {
        Method m;
        try {
            m = Throwable.class.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException ignore) {
            return null;
        }
        m.setAccessible(true);
        return m;
    }

    public StackTrace() {
        this(new Throwable());
    }

    public StackTrace(Throwable t) {
        this.t = t;
        this.elements = getStackTraceDepth == null ? t.getStackTrace() : null;
    }

    public int getDepth() {
        if (this.elements != null) {
            return this.elements.length;
        }
        int depth = 0;
        try {
            depth = (Integer)getStackTraceDepth.invoke((Object)this.t, new Object[0]);
        }
        catch (IllegalAccessException ignore) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return depth;
    }

    public StackTraceElement getElement(int index) {
        if (this.elements != null) {
            return this.elements[index];
        }
        StackTraceElement element = null;
        try {
            element = (StackTraceElement)getStackTraceElement.invoke((Object)this.t, index);
        }
        catch (IllegalAccessException ignore) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return element;
    }

    public static void filterStackTrace(Throwable t) {
        new StackTrace(t).filter();
    }

    public void filter() {
        int n = this.getDepth();
        StackTraceElement[] filteredST = new StackTraceElement[n];
        int j = 0;
        for (int i = 0; i < n; ++i) {
            StackTraceElement ste = this.getElement(i);
            if (ste.getFileName() == null) continue;
            String where = ste.getClassName();
            if (StackTrace.isSunMethod(ste) || StackTrace.isTestFrameworkMethod(where) || StackTrace.isJMockitMethod(where)) continue;
            filteredST[j] = ste;
            ++j;
        }
        StackTraceElement[] newStackTrace = new StackTraceElement[j];
        System.arraycopy(filteredST, 0, newStackTrace, 0, j);
        this.t.setStackTrace(newStackTrace);
        Throwable cause = this.t.getCause();
        if (cause != null) {
            new StackTrace(cause).filter();
        }
    }

    private static boolean isSunMethod(StackTraceElement ste) {
        return ste.getClassName().startsWith("sun.") && !ste.isNativeMethod();
    }

    private static boolean isTestFrameworkMethod(String where) {
        return where.startsWith("org.junit.") || where.startsWith("junit.") || where.startsWith("org.testng.");
    }

    private static boolean isJMockitMethod(String where) {
        return where.startsWith("mockit.") && (where.contains(".internal.") || !where.contains("Test"));
    }

    public StackTraceElement findPositionInTestMethod() {
        int n = this.getDepth();
        for (int i = 0; i < n; ++i) {
            StackTraceElement ste = this.getElement(i);
            if (ste.getFileName() == null) continue;
            String where = ste.getClassName();
            if (StackTrace.isSunMethod(ste) || StackTrace.isTestFrameworkMethod(where) || StackTrace.isJMockitMethod(where)) continue;
            return ste;
        }
        return null;
    }
}

