/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.headers;

import com.ibm.mq.MQMessage;
import com.ibm.mq.headers.MQHeaderContext;
import com.ibm.mq.headers.internal.HeaderMessages;
import java.io.DataInput;
import java.io.IOException;

class MQMessageContext
extends MQHeaderContext {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/headers/MQMessageContext.java, java.classes.headers, k701, k701-112-140304 1.8.1.3 13/07/09 14:57:20";
    private final MQMessage message;
    private int mark;
    private static final int SIZEOF_INT = 4;

    MQMessageContext(MQMessage message) {
        super(message.format, message.encoding, message.characterSet);
        int traceContext = 0;
        int fid = 362;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 362, new Object[]{message});
        }
        this.message = message;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 362);
        }
    }

    public static MQHeaderContext getInstance(DataInput message) {
        if (message instanceof MQMessage) {
            return new MQMessageContext((MQMessage)message);
        }
        throw new UnsupportedOperationException(HeaderMessages.getMessage((String)"MQHDR0001", (Object[])new Object[]{message.getClass()}));
    }

    public DataInput getDataInput() {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JH, 973, "returning: ", (Object)this.message);
        }
        return this.message;
    }

    public int available() throws IOException {
        int traceContext = 0;
        int fid = 363;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 363);
        }
        int traceRet1 = this.message.getMessageLength() - this.message.getDataOffset();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 363, (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void mark() throws IOException {
        int traceContext = 0;
        int fid = 364;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 364);
        }
        this.mark = this.message.getDataOffset();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 364);
        }
    }

    public void rewind() throws IOException {
        int traceContext = 0;
        int fid = 365;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 365);
        }
        this.message.setDataOffset(this.mark);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 365);
        }
    }

    public int sniff() throws IOException {
        int traceContext = 0;
        int fid = 366;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 366);
        }
        int origEncoding = this.message.encoding;
        this.message.encoding = this.nextEncoding();
        int value = this.message.readInt();
        this.message.encoding = origEncoding;
        this.message.seek(this.message.getDataOffset() - 4);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 366, (Object)new Integer(value));
        }
        return value;
    }
}

