/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.headers.internal;

import com.ibm.mq.MQMessage;
import com.ibm.mq.headers.internal.HeaderMessages;
import com.ibm.mq.headers.internal.MessageWrapper;
import com.ibm.mq.headers.internal.ReversingDataOutput;
import com.ibm.mq.headers.internal.store.MQMessageStore;
import com.ibm.mq.headers.internal.store.Store;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MQMessageWrapper
extends MessageWrapper {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/headers/internal/MQMessageWrapper.java, java.classes.headers, k701, k701-112-140304 1.5.1.1 09/08/17 09:16:23";
    MQMessage delegate = null;
    static final int SHUFFLE_SIZE = 4096;

    public MQMessageWrapper(DataInput in) {
        if (!(in instanceof MQMessage)) {
            throw new UnsupportedOperationException(HeaderMessages.getMessage((String)"MQHDR0001"));
        }
        this.delegate = (MQMessage)in;
    }

    public MQMessageWrapper(DataOutput out) {
        if (!(out instanceof MQMessage)) {
            throw new UnsupportedOperationException(HeaderMessages.getMessage((String)"MQHDR0001"));
        }
        this.delegate = (MQMessage)out;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public int getDataOffset() throws IOException {
        return this.delegate.getDataOffset();
    }

    public void seek(int offset) throws IOException {
        this.delegate.seek(offset);
    }

    public void writeBytes(String s) throws IOException {
        this.delegate.writeBytes(s);
    }

    public int readInt() throws IOException {
        return this.delegate.readInt();
    }

    public void writeString(String string) throws IOException {
        this.delegate.writeString(string);
    }

    public void writeInt(int i) throws IOException {
        this.delegate.writeInt(i);
    }

    public int getCharacterSet() {
        return this.delegate.characterSet;
    }

    public int getEncoding() {
        return this.delegate.encoding;
    }

    public Store getStore(int encoding, int characterSet, int size) throws IOException {
        return new MQMessageStore(this.delegate, encoding, characterSet, size);
    }

    public DataOutput getReversed() {
        return new ReversingDataOutput((DataOutput)this.delegate);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.delegate.readFully(b, off, len);
    }

    public void readFully(byte[] b) throws IOException {
        this.delegate.readFully(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.delegate.write(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        this.delegate.write(b);
    }

    public String getFormat() {
        return this.delegate.format;
    }

    public int getTotalMessageLength() {
        return this.delegate.getTotalMessageLength();
    }

    public void shuffle(int from, int to, int length) throws IOException {
        int savedPos = this.getDataOffset();
        int offset = to - from;
        byte[] bytes = new byte[Math.min(length, 4096)];
        if (offset > 0) {
            int remainder = length % bytes.length;
            int pos = from + length - remainder;
            if (remainder != 0) {
                this.seek(pos);
                this.readFully(bytes, 0, remainder);
                this.seek(pos + offset);
                this.write(bytes, 0, remainder);
            }
            while (pos > from) {
                this.seek(pos -= bytes.length);
                this.readFully(bytes);
                this.seek(pos + offset);
                this.write(bytes);
            }
        } else if (offset < 0) {
            int remainder = length % bytes.length;
            int pos = from;
            if (remainder != 0) {
                this.seek(pos);
                this.readFully(bytes, 0, remainder);
                this.seek(pos + offset);
                this.write(bytes, 0, remainder);
            }
            pos += remainder;
            while (pos <= from + length - bytes.length) {
                this.seek(pos);
                this.readFully(bytes);
                this.seek(pos + offset);
                this.write(bytes);
                pos += bytes.length;
            }
        }
        this.seek(savedPos);
    }

    public void resizeBuffer(int size) throws IOException {
        this.delegate.resizeBuffer(size);
    }

    public boolean isMQMessage() {
        return true;
    }

    public int getMessageType() throws IOException {
        int type = this.delegate.readInt();
        this.delegate.skipBytes(-4);
        return type;
    }

    public boolean readBoolean() throws IOException {
        return this.delegate.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.delegate.readByte();
    }

    public char readChar() throws IOException {
        return this.delegate.readChar();
    }

    public double readDouble() throws IOException {
        return this.delegate.readDouble();
    }

    public float readFloat() throws IOException {
        return this.delegate.readFloat();
    }

    public String readLine() throws IOException {
        return this.delegate.readLine();
    }

    public long readLong() throws IOException {
        return this.delegate.readLong();
    }

    public short readShort() throws IOException {
        return this.delegate.readShort();
    }

    public String readUTF() throws IOException {
        return this.delegate.readUTF();
    }

    public int readUnsignedByte() throws IOException {
        return this.delegate.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.delegate.readUnsignedShort();
    }

    public int skipBytes(int n) throws IOException {
        return this.delegate.skipBytes(n);
    }
}

