/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.headers.internal.store;

import com.ibm.mq.MQMessage;
import com.ibm.mq.headers.Charsets;
import com.ibm.mq.headers.internal.Header;
import com.ibm.mq.headers.internal.HeaderField;
import com.ibm.mq.headers.internal.MQMessageWrapper;
import com.ibm.mq.headers.internal.store.Store;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class MQMessageStore
extends Store {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/headers/internal/store/MQMessageStore.java, java.classes.headers, k701, k701-112-140304 1.13.1.1 09/08/17 08:53:04";
    private final MQMessage message;
    private final int origin;
    private final int encoding;
    private final int characterSet;
    private int size;

    public MQMessageStore(MQMessage message, int encoding, int characterSet, int size) throws IOException {
        int traceContext = 0;
        int fid = 214;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 214, new Object[]{message, new Integer(encoding), new Integer(characterSet), new Integer(size)});
        }
        this.message = message;
        this.origin = message.getDataOffset();
        this.encoding = encoding;
        this.characterSet = characterSet;
        this.size = size;
        message.seek(this.origin + size);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 214);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(HeaderField field, int offset) throws IOException {
        int traceContext = 0;
        int fid = 215;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 215, new Object[]{field, new Integer(offset)});
        }
        MQMessage mQMessage = this.message;
        synchronized (mQMessage) {
            int pos = this.message.getDataOffset();
            this.message.seek(this.origin + offset);
            int result = this.matchesEncoding(this.message.encoding) ? this.message.readInt() : MQMessageStore.reverse((int)this.message.readInt());
            this.message.seek(pos);
            if (this.trace.isOn) {
                this.trace.exit(traceContext, (Object)this, COMP_JH, 215, (Object)new Integer(result));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInt(int offset, int value) throws IOException {
        int traceContext = 0;
        int fid = 216;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 216, new Object[]{new Integer(offset), new Integer(value)});
        }
        MQMessage mQMessage = this.message;
        synchronized (mQMessage) {
            int pos = this.message.getDataOffset();
            this.message.seek(this.origin + offset);
            this.message.writeInt(this.matchesEncoding(this.message.encoding) ? value : MQMessageStore.reverse((int)value));
            this.message.seek(pos);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 216);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(HeaderField field, int offset) throws IOException {
        int traceContext = 0;
        int fid = 217;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 217, new Object[]{field, new Integer(offset)});
        }
        MQMessage mQMessage = this.message;
        synchronized (mQMessage) {
            int pos = this.message.getDataOffset();
            this.message.seek(this.origin + offset);
            long result = this.matchesEncoding(this.message.encoding) ? this.message.readLong() : MQMessageStore.reverse((long)this.message.readLong());
            this.message.seek(pos);
            if (this.trace.isOn) {
                this.trace.exit(traceContext, (Object)this, COMP_JH, 217, (Object)new Long(result));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLong(int offset, long value) throws IOException {
        int traceContext = 0;
        int fid = 218;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 218, new Object[]{new Integer(offset), new Long(value)});
        }
        MQMessage mQMessage = this.message;
        synchronized (mQMessage) {
            int pos = this.message.getDataOffset();
            this.message.seek(this.origin + offset);
            this.message.writeLong(this.matchesEncoding(this.message.encoding) ? value : MQMessageStore.reverse((long)value));
            this.message.seek(pos);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 218);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(HeaderField field, int offset, int length) throws IOException {
        int traceContext = 0;
        int fid = 219;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 219, new Object[]{field, new Integer(offset), new Integer(length)});
        }
        MQMessage mQMessage = this.message;
        synchronized (mQMessage) {
            byte[] bytes = new byte[length];
            int pos = this.message.getDataOffset();
            this.message.seek(this.origin + offset);
            this.message.readFully(bytes);
            this.message.seek(pos);
            if (this.trace.isOn) {
                this.trace.exit(traceContext, (Object)this, COMP_JH, 219, (Object)bytes);
            }
            return bytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytes(int offset, byte[] bytes, int length) throws IOException {
        int traceContext = 0;
        int fid = 220;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 220, new Object[]{new Integer(offset), bytes, new Integer(length)});
        }
        MQMessage mQMessage = this.message;
        synchronized (mQMessage) {
            int pos = this.message.getDataOffset();
            this.message.seek(this.origin + offset);
            if (bytes.length < length) {
                this.message.write(bytes, 0, bytes.length);
                while (length-- > bytes.length) {
                    this.message.writeByte(0);
                }
            } else {
                this.message.write(bytes, 0, length);
            }
            this.message.seek(pos);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 220);
        }
    }

    public String getString(HeaderField field, int offset, int length, int ccsid) throws IOException {
        int traceContext = 0;
        int fid = 784;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 784, new Object[]{field, new Integer(offset), new Integer(length), new Integer(ccsid)});
        }
        String traceRet1 = Charsets.convert((byte[])this.getBytes(field, offset, length), (int)ccsid);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 784, (Object)traceRet1);
        }
        return traceRet1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setString(int offset, String value, int length, int ccsid) throws IOException {
        int traceContext = 0;
        int fid = 785;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 785, new Object[]{new Integer(offset), value, new Integer(length), new Integer(ccsid)});
        }
        MQMessage mQMessage = this.message;
        synchronized (mQMessage) {
            byte[] bytes = Charsets.convert((String)value, (int)ccsid);
            if (length == 0) {
                int totalLength = MQMessageStore.getPaddedLength((int)bytes.length, (int)4);
                this.allocate(null, offset, value.length(), totalLength);
                this.setBytes(offset, bytes, bytes.length);
                if (totalLength > bytes.length) {
                    this.fill(offset + bytes.length, totalLength - bytes.length, this.getPadByte(ccsid));
                }
                if (this.trace.isOn) {
                    this.trace.exit(traceContext, (Object)this, COMP_JH, 785, (Object)new Integer(bytes.length), 1);
                }
                return bytes.length;
            }
            if (length > bytes.length) {
                this.setBytes(offset, bytes, bytes.length);
                this.fill(offset + bytes.length, length - bytes.length, this.getPadByte(ccsid));
                if (this.trace.isOn) {
                    this.trace.exit(traceContext, (Object)this, COMP_JH, 785, (Object)new Integer(bytes.length), 2);
                }
                return bytes.length;
            }
            this.setBytes(offset, bytes, length);
            if (this.trace.isOn) {
                this.trace.exit(traceContext, (Object)this, COMP_JH, 785, (Object)new Integer(length), 3);
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getStrings(HeaderField field, int offset, int count, int length, int ccsid) throws IOException {
        int traceContext = 0;
        int fid = 786;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 786, new Object[]{field, new Integer(offset), new Integer(count), new Integer(length), new Integer(ccsid)});
        }
        MQMessage mQMessage = this.message;
        synchronized (mQMessage) {
            String[] array = new String[count];
            for (int i = 0; i < array.length; ++i) {
                array[i] = Charsets.convert((byte[])this.getBytes(field, offset, length), (int)ccsid);
                offset += length;
            }
            if (this.trace.isOn) {
                this.trace.exit(traceContext, (Object)this, COMP_JH, 786, (Object)array);
            }
            return array;
        }
    }

    public int setStrings(int offset, String[] array, int length, int ccsid) throws IOException {
        int traceContext = 0;
        int fid = 787;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 787, new Object[]{new Integer(offset), array, new Integer(length), new Integer(ccsid)});
        }
        byte[][] bytes = new byte[array.length][];
        int stringLength = length;
        for (int i = 0; i < array.length; ++i) {
            bytes[i] = Charsets.convert((String)array[i], (int)ccsid);
            if (length != 0 || bytes[i].length <= stringLength) continue;
            stringLength = bytes[i].length;
        }
        int totalLength = MQMessageStore.getPaddedLength((int)(stringLength * array.length), (int)4);
        this.allocate(null, offset + totalLength);
        for (int i = 0; i < array.length; ++i) {
            this.setBytes(offset, bytes[i], stringLength);
            if (stringLength > bytes[i].length) {
                this.fill(offset + bytes.length, stringLength - bytes.length, this.getPadByte(ccsid));
            }
            offset += stringLength;
        }
        if (totalLength > stringLength * array.length) {
            this.fill(offset, totalLength - stringLength * array.length, this.getPadByte(ccsid));
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 787, (Object)new Integer(stringLength));
        }
        return stringLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFrom(DataInput input, int offset, int length) throws IOException {
        int traceContext = 0;
        int fid = 223;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 223, new Object[]{input, new Integer(offset), new Integer(length)});
        }
        if (input == this.message) {
            this.size = offset + length;
            this.message.seek(this.origin + this.size);
        } else if (input instanceof MQMessageWrapper && ((MQMessageWrapper)((Object)input)).getDelegate() == this.message) {
            this.size = offset + length;
            this.message.seek(this.origin + this.size);
        } else {
            MQMessage mQMessage = this.message;
            synchronized (mQMessage) {
                this.message.seek(this.origin + offset);
                for (int i = 0; i < length; ++i) {
                    this.message.writeByte((int)input.readByte());
                }
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 223);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(DataOutput output, int offset, int length) throws IOException {
        int traceContext = 0;
        int fid = 224;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 224, new Object[]{output, new Integer(offset), new Integer(length)});
        }
        MQMessage mQMessage = this.message;
        synchronized (mQMessage) {
            if (output == this.message) {
                if (offset + this.origin == this.message.getDataOffset()) {
                    this.message.seek(this.message.getDataOffset() + length);
                } else {
                    byte[] bytes = new byte[length];
                    int writePos = this.message.getDataOffset();
                    this.message.seek(this.origin + offset);
                    this.message.readFully(bytes);
                    this.message.seek(writePos);
                    this.message.write(bytes);
                }
            } else {
                int pos = this.message.getDataOffset();
                this.message.seek(this.origin + offset);
                for (int i = 0; i < length; ++i) {
                    output.writeByte(this.message.readByte());
                }
                this.message.seek(pos);
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 224);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(byte[] target, int offset, int length) throws IOException {
        int traceContext = 0;
        int fid = 225;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 225, new Object[]{target, new Integer(offset), new Integer(length)});
        }
        MQMessage mQMessage = this.message;
        synchronized (mQMessage) {
            int pos = this.message.getDataOffset();
            this.message.seek(this.origin + offset);
            this.message.readFully(target, 0, length);
            this.message.seek(pos);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 225);
        }
    }

    public void clear(int offset, int length) throws IOException {
        int traceContext = 0;
        int fid = 226;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 226, new Object[]{new Integer(offset), new Integer(length)});
        }
        this.fill(offset, length, (byte)0);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 226);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill(int offset, int length, byte value) throws IOException {
        int traceContext = 0;
        int fid = 227;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 227, new Object[]{new Integer(offset), new Integer(length), new Byte(value)});
        }
        MQMessage mQMessage = this.message;
        synchronized (mQMessage) {
            int pos = this.message.getDataOffset();
            this.message.seek(this.origin + offset);
            while (length-- > 0) {
                this.message.writeByte((int)value);
            }
            this.message.seek(pos);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 227);
        }
    }

    public int encoding() {
        int traceContext = 0;
        int fid = 228;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 228);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 228, (Object)new Integer(this.encoding));
        }
        return this.encoding;
    }

    public int characterSet() {
        int traceContext = 0;
        int fid = 229;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 229);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 229, (Object)new Integer(this.characterSet));
        }
        return this.characterSet;
    }

    public boolean hasData() {
        int traceContext = 0;
        int fid = 230;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 230);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 230, (Object)true);
        }
        return true;
    }

    public Store allocate(Header header, int size) throws IOException {
        int traceContext = 0;
        int fid = 231;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 231, new Object[]{header, new Integer(size)});
        }
        this.resizeBuffer(this.message.getMessageLength(), size);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 231, (Object)this);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store allocate(Header header, int offset, int oldSize, int newSize) throws IOException {
        int expansion;
        int traceContext = 0;
        int fid = 232;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 232, new Object[]{header, new Integer(offset), new Integer(oldSize), new Integer(newSize)});
        }
        if ((expansion = newSize - oldSize) != 0) {
            MQMessage mQMessage = this.message;
            synchronized (mQMessage) {
                int totalSize = this.message.getMessageLength();
                if (expansion > 0) {
                    this.resizeBuffer(totalSize, totalSize + expansion);
                    byte[] section = new byte[totalSize - offset];
                    this.copyTo(section, offset, section.length);
                    this.message.seek(offset + expansion);
                    this.message.write(section);
                } else {
                    byte[] section = new byte[totalSize - offset + expansion];
                    this.copyTo(section, offset - expansion, section.length);
                    this.message.seek(offset);
                    this.message.write(section);
                    this.resizeBuffer(totalSize, totalSize + expansion);
                }
            }
            this.size += expansion;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 232, (Object)this);
        }
        return this;
    }

    private void resizeBuffer(int totalSize, int size) throws IOException {
        int traceContext = 0;
        int fid = 233;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 233, new Object[]{new Integer(totalSize), new Integer(size)});
        }
        if (size + this.origin > totalSize) {
            this.message.resizeBuffer(size);
            if (size > totalSize) {
                this.message.seek(totalSize);
                while (totalSize++ < size) {
                    this.message.writeByte(0);
                }
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 233);
        }
    }
}

