/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.headers.pcf;

import com.ibm.mq.MQMessage;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.headers.MQDataException;
import com.ibm.mq.headers.pcf.PCFAgent;
import com.ibm.mq.headers.pcf.PCFException;
import com.ibm.mq.headers.pcf.PCFMessage;
import com.ibm.mq.headers.pcf.PCFMessageAgentResponseTracker;
import com.ibm.mq.headers.pcf.PCFMessageAgentResponseTracker390;
import com.ibm.mq.headers.pcf.PCFMessageAgentResponseTrackerNon390;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;

public class PCFMessageAgent
extends PCFAgent {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/headers/pcf/PCFMessageAgent.java, java.classes.headers, k701, k701-112-140304 1.3.2.1 09/08/17 09:18:11";
    static final String copyright = "Copyright (c) IBM Corp. 2000, 2004   All rights reserved.";
    protected boolean check = true;
    protected boolean usePlatformSettings = true;

    public PCFMessageAgent() {
    }

    public PCFMessageAgent(MQQueueManager qmanager) throws MQDataException {
        super(qmanager);
    }

    public PCFMessageAgent(String host, int port, String channel) throws MQDataException {
        super(host, port, channel);
    }

    public PCFMessageAgent(String qmanager) throws MQDataException {
        super(qmanager);
    }

    public synchronized PCFMessage[] send(PCFMessage request) throws PCFException, MQDataException, IOException {
        PCFMessage response;
        PCFMessageAgentResponseTracker tracker;
        if (this.adminQueue == null) {
            throw new MQDataException(2, 6124, (Object)this);
        }
        if (this.usePlatformSettings && this.qmanager_platform == 1) {
            request.header.setType(16);
            request.header.setVersion(3);
            tracker = new PCFMessageAgentResponseTracker390();
        } else {
            tracker = new PCFMessageAgentResponseTrackerNon390();
        }
        MQMessage message = this.setRequestMQMD(new MQMessage());
        request.write((DataOutput)message);
        try {
            this.adminQueue.put(message, this.pmo);
        }
        catch (Exception e) {
            throw MQDataException.getMQDataException((Exception)e);
        }
        Vector<PCFMessage> v = new Vector<PCFMessage>();
        int exceptionReason = 3008;
        boolean failed = false;
        do {
            message.messageId = null;
            message.encoding = this.encoding;
            message.characterSet = defaultCharacterSet;
            try {
                this.replyQueue.get(message, this.gmo);
            }
            catch (Exception e) {
                MQDataException mqe = MQDataException.getMQDataException((Exception)e);
                if (mqe.completionCode == 1 && mqe.reasonCode == 2120) {
                    if (this.trace.isOn) {
                        String value = "caught CMQC.MQRC_CONVERTED_MSG_TOO_BIG and ignoring it";
                        this.trace.data((Object)this, COMP_JH, 0, "send(PCFMessage request)", (Object)value);
                    }
                }
                throw mqe;
            }
            response = new PCFMessage((DataInput)message);
            v.addElement(response);
            if (!this.check || response.getCompCode() != 2) continue;
            if (response.getReason() == 3008) {
                failed = true;
                continue;
            }
            if (exceptionReason != 3008) continue;
            exceptionReason = response.getReason();
        } while (!tracker.isLast(response));
        Object[] responses = new PCFMessage[v.size()];
        v.copyInto(responses);
        if (failed) {
            throw new PCFException(2, exceptionReason, (Object)responses);
        }
        if (this.check && responses.length == 1 && responses[0].getCompCode() == 2) {
            throw new PCFException(2, responses[0].getReason(), (Object)responses);
        }
        return responses;
    }

    public PCFMessage[] send(PCFMessage request, boolean check) throws PCFException, MQDataException, IOException {
        this.check = check;
        return this.send(request);
    }

    public PCFMessage[] send(PCFMessage request, boolean check, boolean usePlatformSettings) throws PCFException, MQDataException, IOException {
        this.check = check;
        this.usePlatformSettings = usePlatformSettings;
        return this.send(request);
    }

    public void setCheckResponses(boolean option) {
        this.check = option;
    }

    public void setUsePlatformSettings(boolean option) {
        this.usePlatformSettings = option;
    }
}

