/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf;

import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.internal.MQCommonServices;
import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiObject;
import com.ibm.mq.pcf.MQCFH;
import com.ibm.mq.pcf.MQCFIL;
import com.ibm.mq.pcf.MQCFIN;
import com.ibm.mq.pcf.MQCFST;
import com.ibm.mq.pcf.PCFAgentResponseTracker;
import com.ibm.mq.pcf.PCFAgentResponseTracker390;
import com.ibm.mq.pcf.PCFAgentResponseTrackerNon390;
import com.ibm.mq.pcf.PCFParameter;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class PCFAgent
extends JmqiObject {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/pcf/PCFAgent.java, java.classes.headers, k701, k701-112-140304 1.16.2.6 11/06/06 10:31:38";
    static final String copyright = "Copyright (c) IBM Corp. 1998, 2004   All rights reserved.";
    static final String DEFAULT_MODEL_QUEUE_NAME = "SYSTEM.DEFAULT.MODEL.QUEUE";
    static final String DEFAULT_HOST_NAME = "localhost";
    static final String DEFAULT_CHANNEL_NAME = "SYSTEM.DEF.SVRCONN";
    protected final MQPutMessageOptions pmo = new MQPutMessageOptions();
    protected final MQGetMessageOptions gmo = new MQGetMessageOptions();
    protected String modelQueueName = "SYSTEM.DEFAULT.MODEL.QUEUE";
    protected String replyQueuePrefix = "";
    protected MQQueueManager qmanager;
    protected MQQueue adminQueue;
    protected MQQueue replyQueue;
    protected int expiryTime = 300;
    protected int waitInterval = 30000;
    protected int encoding = 273;
    protected static int defaultCharacterSet = 1208;
    protected String qmanager_name;
    protected int qmanager_level;
    protected int qmanager_platform;
    protected int qmanager_ccsid = defaultCharacterSet;
    private boolean ccsid_specified = false;
    public String replyQueueName;

    public static JmqiEnvironment getJmqiEnv() {
        return MQCommonServices.jmqiEnv;
    }

    public PCFAgent() {
        super(PCFAgent.getJmqiEnv());
        this.pmo.options = 128;
        this.gmo.options = 24577;
        this.gmo.waitInterval = this.waitInterval;
    }

    public PCFAgent(MQQueueManager qmanager) throws MQException {
        this();
        this.connect(qmanager);
    }

    public PCFAgent(String host, int port, String channel) throws MQException {
        this();
        this.connect(host, port, channel);
    }

    public PCFAgent(String qmanager) throws MQException {
        this();
        this.connect(qmanager);
    }

    public synchronized void connect(MQQueueManager qmanager) throws MQException {
        this.open(qmanager, true);
    }

    public synchronized void connect(MQQueueManager qmanager, String targetQueue, String targetQmanager) throws MQException {
        this.open(qmanager, targetQueue, targetQmanager, true);
    }

    public synchronized void connect(String host, int port, String channel) throws MQException {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("port", new Integer(port));
        if (host == null || host.trim().length() == 0) {
            host = DEFAULT_HOST_NAME;
        }
        props.put("hostname", host);
        if (channel == null || channel.trim().length() == 0) {
            channel = DEFAULT_CHANNEL_NAME;
        }
        props.put("channel", channel);
        this.open(new MQQueueManager("", props), false);
    }

    public synchronized void connect(String host, int port, String channel, String targetQueue, String targetQmanager) throws MQException {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("port", new Integer(port));
        if (host == null || host.trim().length() == 0) {
            host = DEFAULT_HOST_NAME;
        }
        props.put("hostname", host);
        if (channel == null || channel.trim().length() == 0) {
            channel = DEFAULT_CHANNEL_NAME;
        }
        props.put("channel", channel);
        this.open(new MQQueueManager("", props), targetQueue, targetQmanager, false);
    }

    public synchronized void connect(String qmanager) throws MQException {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("port", new Integer(1414));
        props.put("hostname", "");
        props.put("channel", "");
        this.open(new MQQueueManager(qmanager, props), false);
    }

    public synchronized void connect(String qmanager, String targetQueue, String targetQmanager) throws MQException {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("port", new Integer(1414));
        props.put("hostname", "");
        props.put("channel", "");
        this.open(new MQQueueManager(qmanager, props), targetQueue, targetQmanager, false);
    }

    protected synchronized void open(MQQueueManager qmanager, boolean external) throws MQException {
        this.open(qmanager, null, null, external);
    }

    protected synchronized void open(MQQueueManager qmanager, String targetQueue, String targetQmanager, boolean external) throws MQException {
        String prefix;
        try {
            this.disconnect();
        }
        catch (MQException mqe) {
            // empty catch block
        }
        if (targetQueue == null || targetQueue.length() == 0) {
            targetQueue = qmanager.getCommandInputQueueName();
        }
        if ((prefix = this.replyQueuePrefix) != null && prefix.length() > 0) {
            prefix = prefix + Integer.toString(((Object)((Object)this)).hashCode());
        }
        this.adminQueue = qmanager.accessQueue(targetQueue, 8208, targetQmanager, "", "mqm");
        this.replyQueue = qmanager.accessQueue(this.modelQueueName, 8196, "", prefix, "mqm");
        this.replyQueueName = this.replyQueue.name;
        this.replyQueue.closeOptions = 2;
        if (!external) {
            this.qmanager = qmanager;
        }
        this.getBasicQmgrInfo(qmanager, true);
    }

    private void getBasicQmgrInfo(MQQueueManager qmgr, boolean tryBacklevel) throws MQException {
        block12: {
            this.qmanager_level = qmgr.getCommandLevel();
            int type = 16;
            int version = 3;
            if (tryBacklevel) {
                type = 1;
                version = 1;
            }
            try {
                MQMessage message = this.setRequestMQMD(new MQMessage());
                MQCFH.write(message, 2, 1, type, version);
                MQCFIL.write(message, 1001, new int[]{32, 2015, 2});
                this.adminQueue.put(message, this.pmo);
                message.messageId = null;
                message.encoding = this.encoding;
                message.characterSet = defaultCharacterSet;
                this.replyQueue.get(message, this.gmo);
                MQCFH cfh = new MQCFH(message);
                if (cfh.reason == 0) {
                    int parameterCount = cfh.parameterCount;
                    while (parameterCount-- > 0) {
                        PCFParameter p = PCFParameter.nextParameter(message);
                        switch (p.getParameter()) {
                            case 32: {
                                this.qmanager_platform = ((MQCFIN)p).value;
                                break;
                            }
                            case 2015: {
                                String temp = ((MQCFST)p).string;
                                if (temp != null) {
                                    this.qmanager_name = ((MQCFST)p).string.trim();
                                    break;
                                }
                                this.qmanager_name = null;
                                break;
                            }
                            case 2: {
                                this.qmanager_ccsid = ((MQCFIN)p).value;
                                break;
                            }
                        }
                    }
                    break block12;
                }
                if ((cfh.reason == 3001 || cfh.reason == 3003) && tryBacklevel) {
                    this.getBasicQmgrInfo(qmgr, false);
                    break block12;
                }
                throw new MQException(cfh.compCode, cfh.reason, (Object)this);
            }
            catch (IOException e) {
                MQException returnException = new MQException(2, 2195, (Object)this);
                returnException.initCause((Throwable)e);
                throw returnException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect() throws MQException {
        try {
            block5: {
                try {
                    if (this.qmanager != null) {
                        this.qmanager.disconnect();
                        break block5;
                    }
                    this.adminQueue.close();
                    this.replyQueue.close();
                }
                catch (NullPointerException nullPointerException) {
                    Object var3_2 = null;
                    this.adminQueue = null;
                    this.replyQueue = null;
                    this.replyQueueName = null;
                    this.qmanager = null;
                    this.qmanager_name = null;
                    this.qmanager_platform = 0;
                }
            }
            Object var3_1 = null;
            this.adminQueue = null;
            this.replyQueue = null;
            this.replyQueueName = null;
            this.qmanager = null;
            this.qmanager_name = null;
            this.qmanager_platform = 0;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.adminQueue = null;
            this.replyQueue = null;
            this.replyQueueName = null;
            this.qmanager = null;
            this.qmanager_name = null;
            this.qmanager_platform = 0;
            throw throwable;
        }
    }

    public synchronized MQMessage[] send(int command, PCFParameter[] parameters) throws MQException, IOException {
        PCFAgentResponseTracker tracker;
        int count;
        if (this.adminQueue == null) {
            throw new MQException(2, 6124, (Object)this);
        }
        MQMessage message = this.setRequestMQMD(new MQMessage());
        int n = count = parameters == null ? 0 : parameters.length;
        if (this.qmanager_platform == 1) {
            tracker = new PCFAgentResponseTracker390();
            MQCFH.write(message, command, count, 16, 3);
        } else {
            tracker = new PCFAgentResponseTrackerNon390();
            int version = 1;
            for (int i = 0; i < count && version < 3; ++i) {
                version = Math.max(version, parameters[i].getHeaderVersion());
            }
            MQCFH.write(message, command, count, 1, version);
        }
        for (int i = 0; i < count; ++i) {
            parameters[i].write((DataOutput)message);
        }
        this.adminQueue.put(message, this.pmo);
        byte[] correlationId = message.correlationId;
        Vector<MQMessage> v = new Vector<MQMessage>();
        do {
            message = new MQMessage();
            message.correlationId = correlationId;
            message.encoding = this.encoding;
            message.characterSet = defaultCharacterSet;
            this.replyQueue.get(message, this.gmo);
            v.addElement(message);
        } while (!tracker.isLast(message));
        Object[] responses = new MQMessage[v.size()];
        v.copyInto(responses);
        return responses;
    }

    protected MQMessage setRequestMQMD(MQMessage message) throws MQException {
        if (this.qmanager_level < 500) {
            message.setVersion(1);
        }
        message.messageType = 1;
        message.expiry = this.expiryTime;
        message.report = 64;
        message.feedback = 0;
        message.format = "MQADMIN ";
        message.encoding = this.encoding;
        message.characterSet = this.ccsid_specified ? defaultCharacterSet : this.qmanager_ccsid;
        message.replyToQueueName = this.replyQueueName;
        message.replyToQueueManagerName = "";
        message.persistence = 0;
        return message;
    }

    public void setWaitInterval(int seconds) {
        this.setWaitInterval(seconds, seconds);
    }

    public void setWaitInterval(int wait, int expiry) {
        if (wait >= 0) {
            this.gmo.waitInterval = this.waitInterval = wait * 1000;
        }
        if (expiry >= 0) {
            this.expiryTime = expiry * 10;
        }
    }

    public int getWaitInterval() {
        return this.waitInterval / 1000;
    }

    public int getExpiry() {
        return this.expiryTime / 10;
    }

    public String getQManagerName() {
        return this.qmanager_name;
    }

    public String getReplyQueueName() {
        return this.replyQueueName;
    }

    public void setEncoding(int encoding) {
        this.encoding = encoding;
    }

    public void setCharacterSet(int ccsid) {
        this.ccsid_specified = true;
        defaultCharacterSet = ccsid;
    }

    public int getPlatform() {
        return this.qmanager_platform;
    }

    public int getCommandLevel() {
        return this.qmanager_level;
    }

    public String getReplyQueuePrefix() {
        return this.replyQueuePrefix;
    }

    public void setReplyQueuePrefix(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            this.replyQueuePrefix = "";
        } else {
            String uniquifier = Integer.toString(((Object)((Object)this)).hashCode());
            if (prefix.length() > 48 - uniquifier.length()) {
                prefix = prefix.substring(48 - uniquifier.length());
            }
            this.replyQueuePrefix = prefix;
        }
    }

    public String getModelQueueName() {
        return this.modelQueueName;
    }

    public void setModelQueueName(String name) {
        this.modelQueueName = name == null ? DEFAULT_MODEL_QUEUE_NAME : name;
    }
}

