/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf;

import com.ibm.mq.MQException;
import com.ibm.mq.headers.MQHeader;
import com.ibm.mq.headers.MQHeaderContext;
import com.ibm.mq.headers.MQHeaderFactory;
import com.ibm.mq.pcf.MQCFBF;
import com.ibm.mq.pcf.MQCFBS;
import com.ibm.mq.pcf.MQCFGR;
import com.ibm.mq.pcf.MQCFH;
import com.ibm.mq.pcf.MQCFIF;
import com.ibm.mq.pcf.MQCFIL;
import com.ibm.mq.pcf.MQCFIL64;
import com.ibm.mq.pcf.MQCFIN;
import com.ibm.mq.pcf.MQCFIN64;
import com.ibm.mq.pcf.MQCFSF;
import com.ibm.mq.pcf.MQCFSL;
import com.ibm.mq.pcf.MQCFST;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;

public class PCFHeaderFactory
implements MQHeaderFactory {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/pcf/PCFHeaderFactory.java, java.classes.headers, k701, k701-112-140304 1.6.2.1 09/08/17 09:04:23";

    public MQHeader create(String type) throws InstantiationException {
        try {
            return (MQHeader)Class.forName(this.getClass().getPackage().getName() + "." + type).newInstance();
        }
        catch (IllegalAccessException e) {
            throw new InstantiationException(e.toString());
        }
        catch (ClassNotFoundException e) {
            throw new InstantiationException(e.toString());
        }
    }

    public MQHeader decode(MQHeaderContext context) throws MQException, IOException {
        switch (context.sniff()) {
            case 1: 
            case 2: 
            case 7: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                return new MQCFH(context.getDataInput(), context.nextEncoding(), context.nextCharacterSet());
            }
            case 3: {
                return new MQCFIN(context.getDataInput(), context.nextEncoding(), context.nextCharacterSet());
            }
            case 5: {
                return new MQCFIL(context.getDataInput(), context.nextEncoding(), context.nextCharacterSet());
            }
            case 4: {
                return new MQCFST(context.getDataInput(), context.nextEncoding(), context.nextCharacterSet());
            }
            case 6: {
                return new MQCFSL(context.getDataInput(), context.nextEncoding(), context.nextCharacterSet());
            }
            case 9: {
                return new MQCFBS(context.getDataInput(), context.nextEncoding(), context.nextCharacterSet());
            }
            case 23: {
                return new MQCFIN64(context.getDataInput(), context.nextEncoding(), context.nextCharacterSet());
            }
            case 25: {
                return new MQCFIL64(context.getDataInput(), context.nextEncoding(), context.nextCharacterSet());
            }
            case 20: {
                return new MQCFGR(context.getDataInput(), context.nextEncoding(), context.nextCharacterSet());
            }
            case 13: {
                return new MQCFIF(context.getDataInput(), context.nextEncoding(), context.nextCharacterSet());
            }
            case 14: {
                return new MQCFSF(context.getDataInput(), context.nextEncoding(), context.nextCharacterSet());
            }
            case 15: {
                return new MQCFBF(context.getDataInput(), context.nextEncoding(), context.nextCharacterSet());
            }
        }
        throw new MQException(2, 3013, (Object)context);
    }

    public Collection getSupportedFormats() {
        return Arrays.asList("MQADMIN ", "MQEVENT ", "MQPCF   ");
    }

    public Collection getSupportedTypes() {
        return Arrays.asList("MQCFH", "MQCFIN", "MQCFIL", "MQCFST", "MQCFSL", "MQCFIN64", "MQCFIL64", "MQCFBS", "MQCFGR", "MQCFIF", "MQCFSF", "MQCFBF");
    }
}

