/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf;

import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.headers.internal.HeaderType;
import com.ibm.mq.pcf.MQCFBF;
import com.ibm.mq.pcf.MQCFBS;
import com.ibm.mq.pcf.MQCFH;
import com.ibm.mq.pcf.MQCFIF;
import com.ibm.mq.pcf.MQCFIL;
import com.ibm.mq.pcf.MQCFIL64;
import com.ibm.mq.pcf.MQCFIN;
import com.ibm.mq.pcf.MQCFIN64;
import com.ibm.mq.pcf.MQCFSF;
import com.ibm.mq.pcf.MQCFSL;
import com.ibm.mq.pcf.MQCFST;
import com.ibm.mq.pcf.PCFContent;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFHeader;
import com.ibm.mq.pcf.PCFParameter;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class PCFMessage
extends PCFHeader
implements PCFContent,
Serializable {
    private static final long serialVersionUID = -3560553901161502304L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/pcf/PCFMessage.java, java.classes.headers, k701, k701-112-140304 1.19.1.2 13/03/04 15:23:45";
    MQCFH header;
    Vector parameters = null;
    private final com.ibm.mq.headers.pcf.PCFMessage myDelegate;

    private PCFMessage() {
        super(new HeaderType("PCFMessage"));
        int traceContext = 0;
        int fid = 656;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 656);
        }
        this.myDelegate = (com.ibm.mq.headers.pcf.PCFMessage)this.delegate;
        this.parameters = this.myDelegate.getParameterVector();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 656);
        }
    }

    public PCFMessage(int command) {
        this(1, command, 1, true);
        int traceContext = 0;
        int fid = 657;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 657, new Object[]{new Integer(command)});
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 657);
        }
    }

    public PCFMessage(int type, int command, int msgSeqNumber, boolean last) {
        this();
        int traceContext = 0;
        int fid = 658;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 658, new Object[]{new Integer(type), new Integer(command), new Integer(msgSeqNumber), last});
        }
        this.header = new MQCFH(command, 0);
        this.myDelegate.setHeader(this.header.delegate);
        this.header.type = type;
        this.header.setType(this.header.type);
        this.header.msgSeqNumber = msgSeqNumber;
        this.header.setMsgSeqNumber(this.header.msgSeqNumber);
        this.header.control = last ? 1 : 0;
        this.header.setControl(this.header.control);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 658);
        }
    }

    public PCFMessage(MQMessage message) throws MQException, IOException {
        this();
        int traceContext = 0;
        int fid = 659;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 659, new Object[]{message});
        }
        this.initialize(message);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 659);
        }
    }

    public void initialize(int command) {
        int traceContext = 0;
        int fid = 660;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 660, new Object[]{new Integer(command)});
        }
        this.initialize(1, command, 1, true);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 660);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(int type, int command, int msgSeqNumber, boolean last) {
        int traceContext = 0;
        int fid = 661;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 661, new Object[]{new Integer(type), new Integer(command), new Integer(msgSeqNumber), last});
        }
        Vector vector = this.parameters;
        synchronized (vector) {
            this.header.type = 1;
            this.header.setType(1);
            this.header.version = 1;
            this.header.setVersion(1);
            this.header.command = command;
            this.header.setCommand(this.header.command);
            this.header.msgSeqNumber = msgSeqNumber;
            this.header.setMsgSeqNumber(this.header.msgSeqNumber);
            this.header.control = last ? 1 : 0;
            this.header.setControl(this.header.control);
            this.header.compCode = 0;
            this.header.setCompCode(0);
            this.header.reason = 0;
            this.header.setReason(0);
            this.header.parameterCount = 0;
            this.header.setParameterCount(0);
            this.parameters.removeAllElements();
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 661);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParameter(PCFParameter parameter) {
        int traceContext = 0;
        int fid = 662;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 662, new Object[]{parameter});
        }
        Vector vector = this.parameters;
        synchronized (vector) {
            this.parameters.addElement(parameter);
            this.header.setParameterCount(this.header.getParameterCount() + 1);
            this.header.setVersion(Math.max(this.header.version, parameter.getHeaderVersion()));
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 662);
        }
    }

    public void addParameter(int parameter, int value) {
        int traceContext = 0;
        int fid = 663;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 663, new Object[]{new Integer(parameter), new Integer(value)});
        }
        this.addParameter(new MQCFIN(parameter, value));
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 663);
        }
    }

    public void addParameter(int parameter, int[] values) {
        int traceContext = 0;
        int fid = 664;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 664, new Object[]{new Integer(parameter), values});
        }
        this.addParameter(new MQCFIL(parameter, values));
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 664);
        }
    }

    public void addParameter(int parameter, long value) {
        int traceContext = 0;
        int fid = 665;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 665, new Object[]{new Integer(parameter), new Long(value)});
        }
        this.addParameter(new MQCFIN64(parameter, value));
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 665);
        }
    }

    public void addParameter(int parameter, long[] values) {
        int traceContext = 0;
        int fid = 666;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 666, new Object[]{new Integer(parameter), values});
        }
        this.addParameter(new MQCFIL64(parameter, values));
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 666);
        }
    }

    public void addParameter(int parameter, String value) {
        int traceContext = 0;
        int fid = 667;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 667, new Object[]{new Integer(parameter), value});
        }
        this.addParameter(new MQCFST(parameter, value));
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 667);
        }
    }

    public void addParameter(int parameter, String[] values) {
        int traceContext = 0;
        int fid = 668;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 668, new Object[]{new Integer(parameter), values});
        }
        this.addParameter(new MQCFSL(parameter, values));
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 668);
        }
    }

    public void addParameter(int parameter, byte[] value) {
        int traceContext = 0;
        int fid = 669;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 669, new Object[]{new Integer(parameter), value});
        }
        this.addParameter(new MQCFBS(parameter, value));
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 669);
        }
    }

    public void addFilterParameter(int parameter, int operator, int value) {
        int traceContext = 0;
        int fid = 670;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 670, new Object[]{new Integer(parameter), new Integer(operator), new Integer(value)});
        }
        this.addParameter(new MQCFIF(parameter, operator, value));
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 670);
        }
    }

    public void addFilterParameter(int parameter, int operator, String value) {
        int traceContext = 0;
        int fid = 671;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 671, new Object[]{new Integer(parameter), new Integer(operator), value});
        }
        this.addParameter(new MQCFSF(parameter, operator, value));
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 671);
        }
    }

    public void addFilterParameter(int parameter, int operator, byte[] value) {
        int traceContext = 0;
        int fid = 672;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 672, new Object[]{new Integer(parameter), new Integer(operator), value});
        }
        this.addParameter(new MQCFBF(parameter, operator, value));
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 672);
        }
    }

    public int getType() {
        int traceRet1 = this.header.getType();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JH, 825, "returning: ", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getCommand() {
        int traceRet1 = this.header.getCommand();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JH, 826, "returning: ", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getMsgSeqNumber() {
        int traceRet1 = this.header.getMsgSeqNumber();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JH, 827, "returning: ", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getControl() {
        int traceRet1 = this.header.getControl();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JH, 828, "returning: ", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getCompCode() {
        int traceRet1 = this.header.getCompCode();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JH, 829, "returning: ", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getReason() {
        int traceRet1 = this.header.getReason();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JH, 830, "returning: ", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getParameterCount() {
        int traceRet1 = this.header.getParameterCount();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JH, 831, "returning: ", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public Enumeration getParameters() {
        Enumeration traceRet1 = this.myDelegate.getParameters();
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JH, 832, "returning: ", (Object)traceRet1);
        }
        return traceRet1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PCFParameter getParameter(int parameter) {
        int traceContext = 0;
        int fid = 673;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 673, new Object[]{new Integer(parameter)});
        }
        PCFParameter match = null;
        Vector vector = this.parameters;
        synchronized (vector) {
            int i = this.parameters.size();
            while (i-- > 0 && match == null) {
                PCFParameter p = (PCFParameter)this.parameters.elementAt(i);
                if (parameter != p.getParameter()) continue;
                match = p;
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 673, (Object)match);
        }
        return match;
    }

    public Object getParameterValue(int parameter) {
        PCFParameter p;
        Object traceRet1;
        int traceContext = 0;
        int fid = 674;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 674, new Object[]{new Integer(parameter)});
        }
        Object object = traceRet1 = (p = this.getParameter(parameter)) == null ? null : p.getValue();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 674, traceRet1);
        }
        return traceRet1;
    }

    public int getIntParameterValue(int parameter) throws PCFException {
        Integer value;
        int traceContext = 0;
        int fid = 675;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 675, new Object[]{new Integer(parameter)});
        }
        if ((value = (Integer)this.getParameterValue(parameter)) == null) {
            PCFException traceRet1 = new PCFException(2, 3014, this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JH, 675, (Throwable)((Object)traceRet1));
            }
            throw traceRet1;
        }
        int traceRet2 = value;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 675, (Object)new Integer(traceRet2));
        }
        return traceRet2;
    }

    public int[] getIntListParameterValue(int parameter) throws PCFException {
        int[] values;
        int traceContext = 0;
        int fid = 676;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 676, new Object[]{new Integer(parameter)});
        }
        if ((values = (int[])this.getParameterValue(parameter)) == null) {
            PCFException traceRet1 = new PCFException(2, 3047, this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JH, 676, (Throwable)((Object)traceRet1));
            }
            throw traceRet1;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 676, (Object)values);
        }
        return values;
    }

    public long getInt64ParameterValue(int parameter) throws PCFException {
        Long value;
        int traceContext = 0;
        int fid = 677;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 677, new Object[]{new Integer(parameter)});
        }
        if ((value = (Long)this.getParameterValue(parameter)) == null) {
            PCFException traceRet1 = new PCFException(2, 3014, this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JH, 677, (Throwable)((Object)traceRet1));
            }
            throw traceRet1;
        }
        long traceRet2 = value;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 677, (Object)new Long(traceRet2));
        }
        return traceRet2;
    }

    public long[] getIntList64ParameterValue(int parameter) throws PCFException {
        long[] values;
        int traceContext = 0;
        int fid = 678;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 678, new Object[]{new Integer(parameter)});
        }
        if ((values = (long[])this.getParameterValue(parameter)) == null) {
            PCFException traceRet1 = new PCFException(2, 3047, this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JH, 678, (Throwable)((Object)traceRet1));
            }
            throw traceRet1;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 678, (Object)values);
        }
        return values;
    }

    public String getStringParameterValue(int parameter) throws PCFException {
        String value;
        int traceContext = 0;
        int fid = 679;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 679, new Object[]{new Integer(parameter)});
        }
        if ((value = (String)this.getParameterValue(parameter)) == null) {
            PCFException traceRet1 = new PCFException(2, 3015, this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JH, 679, (Throwable)((Object)traceRet1));
            }
            throw traceRet1;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 679, (Object)value);
        }
        return value;
    }

    public String[] getStringListParameterValue(int parameter) throws PCFException {
        String[] values;
        int traceContext = 0;
        int fid = 680;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 680, new Object[]{new Integer(parameter)});
        }
        if ((values = (String[])this.getParameterValue(parameter)) == null) {
            PCFException traceRet1 = new PCFException(2, 2238, this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JH, 680, (Throwable)((Object)traceRet1));
            }
            throw traceRet1;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 680, (Object)values);
        }
        return values;
    }

    public byte[] getBytesParameterValue(int parameter) throws PCFException {
        byte[] value;
        int traceContext = 0;
        int fid = 681;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 681, new Object[]{new Integer(parameter)});
        }
        if ((value = (byte[])this.getParameterValue(parameter)) == null) {
            PCFException traceRet1 = new PCFException(2, 3256, this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JH, 681, (Throwable)((Object)traceRet1));
            }
            throw traceRet1;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 681, (Object)value);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(MQMessage message) throws MQException, IOException {
        int traceContext = 0;
        int fid = 682;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 682, new Object[]{message});
        }
        Vector vector = this.parameters;
        synchronized (vector) {
            this.header = new MQCFH(message);
            this.myDelegate.setHeader(this.header.delegate);
            this.parameters.removeAllElements();
            int count = this.header.parameterCount;
            this.header.parameterCount = 0;
            while (count-- > 0) {
                this.addParameter(PCFParameter.nextParameter(message));
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 682);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(MQMessage message) throws IOException {
        int traceContext = 0;
        int fid = 683;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 683, new Object[]{message});
        }
        this.writeCachedContent();
        Vector vector = this.parameters;
        synchronized (vector) {
            int bytes = this.header.write((DataOutput)message);
            int count = this.parameters.size();
            for (int i = 0; i < count; ++i) {
                PCFParameter p = (PCFParameter)this.parameters.elementAt(i);
                bytes += p.write((DataOutput)message);
            }
            if (this.trace.isOn) {
                this.trace.exit(traceContext, (Object)this, COMP_JH, 683, (Object)new Integer(bytes));
            }
            return bytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int traceContext = 0;
        int fid = 684;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 684);
        }
        Vector vector = this.parameters;
        synchronized (vector) {
            int size = this.header.size();
            int i = this.parameters.size();
            while (i-- > 0) {
                PCFParameter p = (PCFParameter)this.parameters.elementAt(i);
                size += p.size();
            }
            if (this.trace.isOn) {
                this.trace.exit(traceContext, (Object)this, COMP_JH, 684, (Object)new Integer(size));
            }
            return size;
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof PCFMessage) {
            PCFMessage other = (PCFMessage)obj;
            if (other.getParameterCount() == this.getParameterCount() && other.header.equals(this.header)) {
                Enumeration otherParameters = other.getParameters();
                Enumeration parameters = this.getParameters();
                boolean match = true;
                try {
                    while (match && parameters.hasMoreElements()) {
                        match = otherParameters.nextElement().equals(parameters.nextElement());
                    }
                }
                catch (NoSuchElementException nsee) {
                    return false;
                }
                return match;
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getUnqualifiedClassName());
        sb.append(": \n");
        if (this.header != null) {
            sb.append(this.header.toString());
        } else {
            sb.append("No header(yet)");
        }
        if (this.parameters != null) {
            Vector vector = this.parameters;
            synchronized (vector) {
                for (int i = 0; i < this.parameters.size(); ++i) {
                    PCFParameter p = (PCFParameter)this.parameters.elementAt(i);
                    sb.append('\n');
                    sb.append(p.toString());
                }
            }
        } else {
            sb.append("\nNo parameters(yet)");
        }
        return new String(sb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardCachedContent() {
        int traceContext = 0;
        int fid = 685;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 685);
        }
        if (this.header != null) {
            this.header.discardCachedContent();
        }
        Vector vector = this.parameters;
        synchronized (vector) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                ((PCFParameter)this.parameters.elementAt(i)).discardCachedContent();
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 685);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readCachedContent() throws MQException, IOException {
        int traceContext = 0;
        int fid = 686;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 686);
        }
        if (this.header != null) {
            this.header.readCachedContent();
        }
        Vector vector = this.parameters;
        synchronized (vector) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                try {
                    ((PCFParameter)this.parameters.elementAt(i)).readCachedContent();
                    continue;
                }
                catch (MQException e) {
                    if (this.trace.isOn) {
                        this.trace.catchBlock((Object)this, COMP_JH, 686, (Throwable)e, 1);
                    }
                    if (this.trace.isOn) {
                        this.trace.throwing((Object)this, COMP_JH, 686, (Throwable)e, 1);
                    }
                    throw e;
                }
                catch (IOException e) {
                    if (this.trace.isOn) {
                        this.trace.catchBlock((Object)this, COMP_JH, 686, (Throwable)e, 2);
                    }
                    if (this.trace.isOn) {
                        this.trace.throwing((Object)this, COMP_JH, 686, (Throwable)e, 2);
                    }
                    throw e;
                }
                catch (Exception e) {
                    if (this.trace.isOn) {
                        this.trace.catchBlock((Object)this, COMP_JH, 686, (Throwable)e, 3);
                    }
                    RuntimeException traceRet1 = new RuntimeException(e);
                    if (this.trace.isOn) {
                        this.trace.throwing((Object)this, COMP_JH, 686, (Throwable)traceRet1, 3);
                    }
                    throw traceRet1;
                }
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 686);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCachedContent() throws IOException {
        int traceContext = 0;
        int fid = 687;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 687);
        }
        if (this.header != null) {
            this.header.writeCachedContent();
        }
        Vector vector = this.parameters;
        synchronized (vector) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                ((PCFParameter)this.parameters.elementAt(i)).writeCachedContent();
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 687);
        }
    }
}

