/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf;

import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.headers.CCSID;
import com.ibm.mq.headers.MQHeader;
import com.ibm.mq.headers.internal.HeaderType;
import com.ibm.mq.headers.internal.store.Store;
import com.ibm.mq.headers.pcf.PCFConstants;
import com.ibm.mq.pcf.MQCFBF;
import com.ibm.mq.pcf.MQCFBS;
import com.ibm.mq.pcf.MQCFGR;
import com.ibm.mq.pcf.MQCFIF;
import com.ibm.mq.pcf.MQCFIL;
import com.ibm.mq.pcf.MQCFIL64;
import com.ibm.mq.pcf.MQCFIN;
import com.ibm.mq.pcf.MQCFIN64;
import com.ibm.mq.pcf.MQCFSF;
import com.ibm.mq.pcf.MQCFSL;
import com.ibm.mq.pcf.MQCFST;
import com.ibm.mq.pcf.PCFHeader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public abstract class PCFParameter
extends PCFHeader {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/pcf/PCFParameter.java, java.classes.headers, k701, k701-112-140304 1.19.1.3 13/10/27 19:28:01";
    static final String[] pads = new String[]{"", " ", "  ", "   ", ""};
    private static Pattern firstLastPattern = Pattern.compile(".*(_FIRST|_FIRST_USED|_LAST|_LAST_USED)$");

    public static PCFParameter nextParameter(MQMessage message) throws MQException, IOException {
        message.writeBytes("");
        int pos = message.getDataOffset();
        int type = message.readInt();
        message.seek(pos);
        switch (type) {
            case 3: {
                return new MQCFIN(message);
            }
            case 5: {
                return new MQCFIL(message);
            }
            case 4: {
                return new MQCFST(message);
            }
            case 6: {
                return new MQCFSL(message);
            }
            case 9: {
                return new MQCFBS(message);
            }
            case 23: {
                return new MQCFIN64(message);
            }
            case 25: {
                return new MQCFIL64(message);
            }
            case 20: {
                return new MQCFGR(message);
            }
            case 13: {
                return new MQCFIF(message);
            }
            case 14: {
                return new MQCFSF(message);
            }
            case 15: {
                return new MQCFBF(message);
            }
        }
        throw new MQException(2, 3013, (Object)message);
    }

    protected static int getStringLength(String string, int characterSet) throws UnsupportedEncodingException {
        if (string == null) {
            return 0;
        }
        return CCSID.convert((String)string, (int)characterSet).length;
    }

    protected static int writeString(MQMessage message, String string) throws IOException {
        if (string == null) {
            return 0;
        }
        int pos = message.getDataOffset();
        message.writeString(string);
        return message.getDataOffset() - pos;
    }

    protected PCFParameter(HeaderType type) {
        super(type);
        int traceContext = 0;
        int fid = 688;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 688, new Object[]{type});
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JH, 688);
        }
    }

    public abstract int getParameter();

    public abstract Object getValue();

    public abstract String getStringValue();

    public abstract Store getStore();

    public int getHeaderVersion() {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JH, 0, "getHeaderVersion()", (Object)new Integer(1));
        }
        return 1;
    }

    public boolean equals(Object obj) {
        boolean areEqual = false;
        if (obj != null && obj instanceof PCFParameter) {
            int t2;
            PCFParameter other = (PCFParameter)obj;
            int t1 = this.getType();
            boolean typesMatch = t1 == (t2 = other.getType());
            int p1 = this.getParameter();
            int p2 = other.getParameter();
            boolean parmsMatch = p1 == p2;
            Object v1 = this.getValue();
            Object v2 = other.getValue();
            boolean valuesMatch = v1.equals(v2);
            areEqual = typesMatch && parmsMatch && valuesMatch;
        }
        return areEqual;
    }

    public final String getParameterName() {
        int traceContext = 0;
        int fid = 541;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JH, 541);
        }
        String parameterName = null;
        try {
            String potentialNames = PCFConstants.lookupParameter((int)this.getParameter());
            if (potentialNames != null) {
                StringBuffer result = new StringBuffer(potentialNames.length());
                StringTokenizer tok = new StringTokenizer(potentialNames, "/");
                while (tok.hasMoreTokens()) {
                    String candidate = tok.nextToken();
                    if (firstLastPattern.matcher(candidate).matches()) continue;
                    result.append(candidate);
                    result.append("/");
                }
                if (result.length() > 0) {
                    result.setLength(result.length() - 1);
                    parameterName = result.toString();
                }
            }
            String traceRet1 = parameterName;
            if (this.trace.isOn) {
                this.trace.exit(traceContext, (Object)this, COMP_JH, 541, traceRet1, 1);
            }
            return traceRet1;
        }
        catch (Throwable e) {
            if (this.trace.isOn) {
                this.trace.catchBlock((Object)this, COMP_JH, 541, e);
            }
            if (this.trace.isOn) {
                this.trace.exit(traceContext, (Object)this, COMP_JH, 541, null, 2);
            }
            return null;
        }
    }

    protected String toString(MQHeader.Field field) {
        String string = super.toString(field);
        if (field.getName().equals("Parameter")) {
            Integer value = (Integer)field.getValue();
            String constant = PCFConstants.lookupParameter((int)value);
            string = string.substring(0, string.indexOf(40)) + "(" + constant + ")";
        }
        return string;
    }
}

